/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.programs;

import com.portto.solana.web3.AccountMeta;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.TransactionInstruction;
import com.portto.solana.web3.programs.Program;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.near.borshj.BorshBuffer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004JD\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/portto/solana/web3/programs/SystemProgram;", "Lcom/portto/solana/web3/programs/Program;", "()V", "PROGRAM_ID", "Lcom/portto/solana/web3/PublicKey;", "getPROGRAM_ID", "()Lcom/portto/solana/web3/PublicKey;", "PROGRAM_INDEX_CREATE_ACCOUNT", "", "PROGRAM_INDEX_TRANSFER", "PROGRAM_INDEX_TRANSFER_WITH_SEED", "createAccount", "Lcom/portto/solana/web3/TransactionInstruction;", "fromPublicKey", "newAccountPublicKey", "lamports", "", "space", "programId", "transfer", "basePubkey", "toPublicKey", "seed", "", "web3"})
public final class SystemProgram
extends Program {
    @NotNull
    public static final SystemProgram INSTANCE = new SystemProgram();
    @NotNull
    private static final PublicKey PROGRAM_ID = new PublicKey("11111111111111111111111111111111");
    private static final int PROGRAM_INDEX_CREATE_ACCOUNT = 0;
    private static final int PROGRAM_INDEX_TRANSFER = 2;
    private static final int PROGRAM_INDEX_TRANSFER_WITH_SEED = 11;

    private SystemProgram() {
    }

    @NotNull
    public final PublicKey getPROGRAM_ID() {
        return PROGRAM_ID;
    }

    @NotNull
    public final TransactionInstruction createAccount(@NotNull PublicKey fromPublicKey, @NotNull PublicKey newAccountPublicKey, long lamports, long space, @NotNull PublicKey programId) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)newAccountPublicKey, (String)"newAccountPublicKey");
        Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(fromPublicKey, true, true));
        keys.add(new AccountMeta(newAccountPublicKey, true, true));
        byte[] data = new byte[52];
        Utils.uint32ToByteArrayLE((long)0L, (byte[])data, (int)0);
        Utils.int64ToByteArrayLE((long)lamports, (byte[])data, (int)4);
        Utils.int64ToByteArrayLE((long)space, (byte[])data, (int)12);
        System.arraycopy(programId.toByteArray(), 0, data, 20, 32);
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, (List<AccountMeta>)keys, data);
    }

    @JvmStatic
    @NotNull
    public static final TransactionInstruction transfer(@NotNull PublicKey fromPublicKey, @Nullable PublicKey basePubkey, @NotNull PublicKey toPublicKey, long lamports, @Nullable String seed, @Nullable PublicKey programId) {
        Intrinsics.checkNotNullParameter((Object)fromPublicKey, (String)"fromPublicKey");
        Intrinsics.checkNotNullParameter((Object)toPublicKey, (String)"toPublicKey");
        if (basePubkey != null && seed != null && programId != null) {
            int rustStringLength = 9;
            Object[] objectArray = BorshBuffer.allocate(12 + rustStringLength + 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"allocate(Int.SIZE_BYTES \u2026ngLength + PUBKEY_LENGTH)");
            Object[] buffer = objectArray;
            buffer.writeU32(11);
            buffer.writeU64(lamports);
            buffer.writeString(seed);
            buffer.write(programId.getPubkey());
            objectArray = new AccountMeta[]{new AccountMeta(fromPublicKey, true, true), new AccountMeta(basePubkey, false, true), new AccountMeta(toPublicKey, false, true)};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = buffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buffer.toByteArray()");
            return Program.Companion.createTransactionInstruction(PROGRAM_ID, list, (byte[])objectArray);
        }
        Object[] objectArray = BorshBuffer.allocate(12);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"allocate(Int.SIZE_BYTES + Long.SIZE_BYTES)");
        Object[] buffer = objectArray;
        buffer.writeU32(2);
        buffer.writeU64(lamports);
        objectArray = new AccountMeta[]{new AccountMeta(fromPublicKey, true, true), new AccountMeta(toPublicKey, false, true)};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buffer.toByteArray()");
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, list, (byte[])objectArray);
    }

    public static /* synthetic */ TransactionInstruction transfer$default(PublicKey publicKey, PublicKey publicKey2, PublicKey publicKey3, long l, String string, PublicKey publicKey4, int n, Object object) {
        if ((n & 2) != 0) {
            publicKey2 = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            publicKey4 = null;
        }
        return SystemProgram.transfer(publicKey, publicKey2, publicKey3, l, string, publicKey4);
    }
}

