/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.programs;

import com.portto.solana.web3.AccountMeta;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.TransactionInstruction;
import com.portto.solana.web3.programs.Program;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/portto/solana/web3/programs/MemoProgram;", "Lcom/portto/solana/web3/programs/Program;", "()V", "PROGRAM_ID", "Lcom/portto/solana/web3/PublicKey;", "getPROGRAM_ID", "()Lcom/portto/solana/web3/PublicKey;", "writeUtf8", "Lcom/portto/solana/web3/TransactionInstruction;", "account", "memo", "", "web3"})
public final class MemoProgram
extends Program {
    @NotNull
    public static final MemoProgram INSTANCE = new MemoProgram();
    @NotNull
    private static final PublicKey PROGRAM_ID = new PublicKey("Memo1UhkJRfHyvLMcVucJwxXeuD728EqVDDwQDxFMNo");

    private MemoProgram() {
    }

    @NotNull
    public final PublicKey getPROGRAM_ID() {
        return PROGRAM_ID;
    }

    @NotNull
    public final TransactionInstruction writeUtf8(@NotNull PublicKey account, @NotNull String memo) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)memo, (String)"memo");
        List keys = CollectionsKt.listOf((Object)new AccountMeta(account, true, false));
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = memo.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] memoBytes = byArray;
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, keys, memoBytes);
    }
}

