/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3;

import com.portto.solana.web3.AccountMeta;
import com.portto.solana.web3.CompiledInstruction;
import com.portto.solana.web3.Connection;
import com.portto.solana.web3.Message;
import com.portto.solana.web3.MessageHeader;
import com.portto.solana.web3.NonceInformation;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.SerializeConfig;
import com.portto.solana.web3.SignaturePubkeyPair;
import com.portto.solana.web3.Signer;
import com.portto.solana.web3.Transaction;
import com.portto.solana.web3.TransactionInstruction;
import com.portto.solana.web3.TransactionKt;
import com.portto.solana.web3.rpc.types.RpcResultTypes;
import com.portto.solana.web3.util.Shortvec;
import com.portto.solana.web3.util.TweetNaclFast;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bitcoinj.core.Base58;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0001JB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u001f\u0010(\u001a\u00020\u00002\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0*\"\u00020\u000b\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001cJ\r\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u0006\u00100\u001a\u00020.J\u0019\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u001e\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020.2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0002J\u001f\u00106\u001a\u00020&2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0*\"\u00020:\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u001c2\b\b\u0002\u0010=\u001a\u00020>J\u0015\u0010<\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020\u001cJ\u000e\u0010B\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015J!\u0010C\u001a\u00020&2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040*\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010DJ\u001f\u0010E\u001a\u00020&2\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0*\"\u00020:\u00a2\u0006\u0002\u0010;J\u0014\u0010E\u001a\u00020&2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\u0006\u0010G\u001a\u00020HJ\u0018\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020HH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010$\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lcom/portto/solana/web3/Transaction;", "", "()V", "feePayer", "Lcom/portto/solana/web3/PublicKey;", "getFeePayer", "()Lcom/portto/solana/web3/PublicKey;", "setFeePayer", "(Lcom/portto/solana/web3/PublicKey;)V", "instructions", "", "Lcom/portto/solana/web3/TransactionInstruction;", "getInstructions", "()Ljava/util/List;", "nonceInfo", "Lcom/portto/solana/web3/NonceInformation;", "getNonceInfo", "()Lcom/portto/solana/web3/NonceInformation;", "setNonceInfo", "(Lcom/portto/solana/web3/NonceInformation;)V", "recentBlockhash", "", "Lcom/portto/solana/web3/Blockhash;", "getRecentBlockhash", "()Ljava/lang/String;", "setRecentBlockhash", "(Ljava/lang/String;)V", "serializedMessage", "", "signature", "getSignature", "()[B", "signatures", "Lcom/portto/solana/web3/SignaturePubkeyPair;", "getSignatures", "setSignatures", "(Ljava/util/List;)V", "_addSignature", "", "pubkey", "add", "instruction", "", "([Lcom/portto/solana/web3/TransactionInstruction;)Lcom/portto/solana/web3/Transaction;", "addSignature", "compile", "Lcom/portto/solana/web3/Message;", "compile$web3", "compileMessage", "getEstimatedFee", "", "connection", "Lcom/portto/solana/web3/Connection;", "(Lcom/portto/solana/web3/Connection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "partialSign", "message", "signers", "", "Lcom/portto/solana/web3/Signer;", "([Lcom/portto/solana/web3/Signer;)V", "serialize", "config", "Lcom/portto/solana/web3/SerializeConfig;", "signData", "serialize$web3", "serializeMessage", "setRecentBlockHash", "setSigners", "([Lcom/portto/solana/web3/PublicKey;)V", "sign", "signer", "verifySignatures", "", "requireAllSignatures", "Companion", "web3"})
public final class Transaction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<SignaturePubkeyPair> signatures = new ArrayList();
    private byte[] serializedMessage;
    @Nullable
    private PublicKey feePayer;
    @NotNull
    private final List<TransactionInstruction> instructions = new ArrayList();
    public String recentBlockhash;
    @Nullable
    private NonceInformation nonceInfo;

    @NotNull
    public final List<SignaturePubkeyPair> getSignatures() {
        return this.signatures;
    }

    public final void setSignatures(@NotNull List<SignaturePubkeyPair> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.signatures = list;
    }

    @Nullable
    public final byte[] getSignature() {
        SignaturePubkeyPair signaturePubkeyPair = (SignaturePubkeyPair)CollectionsKt.firstOrNull(this.signatures);
        return (byte[])(signaturePubkeyPair == null ? null : signaturePubkeyPair.getSignature());
    }

    @Nullable
    public final PublicKey getFeePayer() {
        return this.feePayer;
    }

    public final void setFeePayer(@Nullable PublicKey publicKey) {
        this.feePayer = publicKey;
    }

    @NotNull
    public final List<TransactionInstruction> getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final String getRecentBlockhash() {
        String string = this.recentBlockhash;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recentBlockhash");
        return null;
    }

    public final void setRecentBlockhash(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.recentBlockhash = string;
    }

    @Nullable
    public final NonceInformation getNonceInfo() {
        return this.nonceInfo;
    }

    public final void setNonceInfo(@Nullable NonceInformation nonceInformation) {
        this.nonceInfo = nonceInformation;
    }

    @NotNull
    public final Transaction add(TransactionInstruction ... instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (!(!(instruction.length == 0))) {
            boolean bl = false;
            String string = "No instructions";
            throw new IllegalArgumentException(string.toString());
        }
        CollectionsKt.addAll((Collection)this.instructions, (Object[])instruction);
        return this;
    }

    public final void setRecentBlockHash(@NotNull String recentBlockhash2) {
        Intrinsics.checkNotNullParameter((Object)recentBlockhash2, (String)"recentBlockhash");
        this.setRecentBlockhash(recentBlockhash2);
    }

    public final void sign(Signer ... signer) {
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.sign(ArraysKt.toList((Object[])signer));
    }

    /*
     * WARNING - void declaration
     */
    public final void sign(@NotNull List<? extends Signer> signers) {
        void $this$mapTo$iv$iv;
        Object key;
        Intrinsics.checkNotNullParameter(signers, (String)"signers");
        if (!(!((Collection)signers).isEmpty())) {
            boolean $i$a$-require-Transaction$sign$232 = false;
            String $i$a$-require-Transaction$sign$232 = "No signers";
            throw new IllegalArgumentException($i$a$-require-Transaction$sign$232.toString());
        }
        Set seen = new LinkedHashSet();
        List uniqueSigners = new ArrayList();
        for (Signer signer : signers) {
            key = signer.getPublicKey().toString();
            if (seen.contains(key)) continue;
            seen.add(key);
            uniqueSigners.add(signer);
        }
        Iterable $this$map$iv = uniqueSigners;
        boolean bl = false;
        key = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Signer signer = (Signer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new SignaturePubkeyPair(null, it.getPublicKey()));
        }
        List list = (List)destination$iv$iv;
        boolean bl3 = false;
        this.getSignatures().addAll(list);
        Message message = this.compile$web3();
        this.partialSign(message, uniqueSigners);
        this.verifySignatures(message.serialize(), true);
    }

    public final void partialSign(Signer ... signers) {
        Intrinsics.checkNotNullParameter((Object)signers, (String)"signers");
        if (!(!(signers.length == 0))) {
            boolean $i$a$-require-Transaction$partialSign$22 = false;
            String $i$a$-require-Transaction$partialSign$22 = "No signers";
            throw new IllegalArgumentException($i$a$-require-Transaction$partialSign$22.toString());
        }
        Set seen = new LinkedHashSet();
        List uniqueSigners = new ArrayList();
        for (Signer signer : signers) {
            String key = signer.getPublicKey().toString();
            if (seen.contains(key)) continue;
            seen.add(key);
            uniqueSigners.add(signer);
        }
        Message message = this.compile$web3();
        this.partialSign(message, uniqueSigners);
    }

    private final void partialSign(Message message, List<? extends Signer> signers) {
        byte[] signData = message.serialize();
        Iterable $this$forEach$iv = signers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Signer signer = (Signer)element$iv;
            boolean bl = false;
            byte[] signature = new TweetNaclFast.Signature(new byte[0], signer.getSecretKey()).detached(signData);
            PublicKey publicKey = signer.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            this._addSignature(publicKey, signature);
        }
    }

    public final void addSignature(@NotNull PublicKey pubkey, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.compile$web3();
        this._addSignature(pubkey, signature);
    }

    private final void _addSignature(PublicKey pubkey, byte[] signature) {
        int index;
        block4: {
            int n;
            if (!(signature.length == 64)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            List<SignaturePubkeyPair> $this$indexOfFirst$iv = this.signatures;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<SignaturePubkeyPair> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                SignaturePubkeyPair item$iv;
                SignaturePubkeyPair sigpair = item$iv = iterator.next();
                boolean bl = false;
                if (pubkey.equals(sigpair.getPublicKey())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index < 0) {
            throw new Error(Intrinsics.stringPlus((String)"unknown signer: ", (Object)pubkey));
        }
        this.signatures.get(index).setSignature(signature);
    }

    public final boolean verifySignatures() {
        return this.verifySignatures(this.serializeMessage(), true);
    }

    private final boolean verifySignatures(byte[] signData, boolean requireAllSignatures) {
        Iterable $this$forEach$iv = this.signatures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SignaturePubkeyPair $dstr$signature$publicKey = (SignaturePubkeyPair)element$iv;
            boolean bl = false;
            byte[] signature = $dstr$signature$publicKey.component1();
            PublicKey publicKey = $dstr$signature$publicKey.component2();
            if (!(signature == null ? requireAllSignatures : !new TweetNaclFast.Signature(publicKey.getPubkey(), new byte[0]).detached_verify(signData, signature))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Message compile$web3() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PublicKey pair;
        Message message = this.compileMessage();
        List signedKeys = CollectionsKt.slice(message.getAccountKeys(), (IntRange)RangesKt.until((int)0, (byte)message.getHeader().getNumRequiredSignatures()));
        if (((Collection)this.signatures).size() == ((Collection)signedKeys).size()) {
            boolean valid = false;
            valid = true;
            Iterable $this$forEachIndexed$iv = this.signatures;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SignaturePubkeyPair signaturePubkeyPair = (SignaturePubkeyPair)item$iv;
                int index = n;
                boolean bl = false;
                if (((PublicKey)signedKeys.get(index)).equals(((SignaturePubkeyPair)((Object)pair)).getPublicKey())) continue;
                valid = false;
            }
            if (valid) {
                return message;
            }
        }
        Iterable valid = signedKeys;
        Transaction transaction = this;
        boolean $i$f$map = false;
        void $i$f$forEachIndexed = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void publicKey;
            pair = (PublicKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SignaturePubkeyPair(null, (PublicKey)publicKey));
        }
        transaction.signatures = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        return message;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Message compileMessage() {
        void $this$mapTo$iv$iv;
        int feePayerIndex;
        int uniqueIndex;
        AccountMeta it;
        Object item$iv;
        Object $this$indexOfFirst$iv;
        List uniqueMetas;
        PublicKey feePayer;
        block30: {
            int n;
            PublicKey publicKey;
            Unit unit;
            NonceInformation nonceInformation = this.nonceInfo;
            if (nonceInformation == null) {
                unit = null;
            } else {
                NonceInformation nonceInfo = nonceInformation;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)CollectionsKt.first(this.getInstructions()), (Object)nonceInfo.getNonceInstruction())) {
                    this.setRecentBlockhash(nonceInfo.getNonce());
                    this.getInstructions().add(0, nonceInfo.getNonceInstruction());
                }
                unit = Unit.INSTANCE;
            }
            if (!(((CharSequence)this.getRecentBlockhash()).length() > 0)) {
                boolean $i$a$-require-Transaction$compileMessage$32 = false;
                String $i$a$-require-Transaction$compileMessage$32 = "Transaction recentBlockhash required";
                throw new IllegalArgumentException($i$a$-require-Transaction$compileMessage$32.toString());
            }
            if (((Collection)this.instructions).size() < 1) {
                Logger.INSTANCE.warn("No instructions provided");
            }
            if ((publicKey = this.feePayer) == null) {
                SignaturePubkeyPair signaturePubkeyPair = (SignaturePubkeyPair)CollectionsKt.firstOrNull(this.signatures);
                publicKey = signaturePubkeyPair == null ? null : signaturePubkeyPair.getPublicKey();
            }
            if ((feePayer = publicKey) == null) {
                boolean $i$a$-requireNotNull-Transaction$compileMessage$42 = false;
                String $i$a$-requireNotNull-Transaction$compileMessage$42 = "Transaction fee payer required";
                throw new IllegalArgumentException($i$a$-requireNotNull-Transaction$compileMessage$42.toString());
            }
            Set programIds = new LinkedHashSet();
            List accountMetas = new ArrayList();
            for (TransactionInstruction instruction : this.instructions) {
                for (AccountMeta accountMeta : instruction.getKeys()) {
                    accountMetas.add(accountMeta);
                }
                programIds.add(instruction.getProgramId());
            }
            for (Object programId : programIds) {
                accountMetas.add(new AccountMeta((PublicKey)programId, false, false));
            }
            Iterator<TransactionInstruction> bl = new Function1[]{compileMessage.4.INSTANCE, compileMessage.5.INSTANCE, compileMessage.6.INSTANCE, compileMessage.7.INSTANCE};
            CollectionsKt.sortWith((List)accountMetas, (Comparator)ComparisonsKt.compareBy(bl));
            uniqueMetas = new ArrayList();
            for (AccountMeta accountMeta : accountMetas) {
                block29: {
                    int n2;
                    PublicKey pubkeyString = accountMeta.getPublicKey();
                    $this$indexOfFirst$iv = uniqueMetas;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        item$iv = iterator.next();
                        it = (AccountMeta)item$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getPublicKey(), (Object)pubkeyString)) {
                            n2 = index$iv;
                            break block29;
                        }
                        ++index$iv;
                    }
                    n2 = uniqueIndex = -1;
                }
                if (uniqueIndex > -1) {
                    ((AccountMeta)uniqueMetas.get(uniqueIndex)).setWritable(((AccountMeta)uniqueMetas.get(uniqueIndex)).isWritable() || accountMeta.isWritable());
                    continue;
                }
                uniqueMetas.add(accountMeta);
            }
            List $this$indexOfFirst$iv2 = uniqueMetas;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv2 : $this$indexOfFirst$iv2) {
                AccountMeta it2 = (AccountMeta)item$iv2;
                boolean bl3 = false;
                if (it2.getPublicKey().equals(feePayer)) {
                    n = index$iv;
                    break block30;
                }
                ++index$iv;
            }
            n = feePayerIndex = -1;
        }
        if (feePayerIndex > -1) {
            AccountMeta payerMeta = (AccountMeta)uniqueMetas.remove(feePayerIndex);
            payerMeta.setSigner(true);
            payerMeta.setWritable(true);
            uniqueMetas.add(0, payerMeta);
        } else {
            uniqueMetas.add(0, new AccountMeta(feePayer, true, true));
        }
        for (SignaturePubkeyPair signature : this.signatures) {
            block31: {
                int n;
                $this$indexOfFirst$iv = uniqueMetas;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator bl3 = $this$indexOfFirst$iv.iterator();
                while (bl3.hasNext()) {
                    item$iv = bl3.next();
                    it = (AccountMeta)item$iv;
                    boolean bl = false;
                    if (it.getPublicKey().equals(signature.getPublicKey())) {
                        n = index$iv;
                        break block31;
                    }
                    ++index$iv;
                }
                n = uniqueIndex = -1;
            }
            if (uniqueIndex > -1) {
                if (((AccountMeta)uniqueMetas.get(uniqueIndex)).isSigner()) continue;
                ((AccountMeta)uniqueMetas.get(uniqueIndex)).setSigner(true);
                Logger.INSTANCE.info("Transaction references a signature that is unnecessary, only the fee payer and instruction signer accounts should sign a transaction. This behavior is deprecated and will throw an error in the next major version release");
                continue;
            }
            throw new Error(Intrinsics.stringPlus((String)"unknown signer: ", (Object)signature.getPublicKey()));
        }
        int numRequiredSignatures = 0;
        int numReadonlySignedAccounts = 0;
        int numReadonlyUnsignedAccounts = 0;
        List signedKeys = new ArrayList();
        List unsignedKeys = new ArrayList();
        Iterable $this$forEach$iv = uniqueMetas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccountMeta it3 = (AccountMeta)element$iv;
            boolean bl = false;
            if (it3.isSigner()) {
                signedKeys.add(it3.getPublicKey());
                ++numRequiredSignatures;
                if (it3.isWritable()) continue;
                ++numReadonlySignedAccounts;
                continue;
            }
            unsignedKeys.add(it3.getPublicKey());
            if (it3.isWritable()) continue;
            ++numReadonlyUnsignedAccounts;
        }
        List accountKeys = CollectionsKt.plus((Collection)signedKeys, (Iterable)unsignedKeys);
        Iterable $this$map$iv = this.instructions;
        boolean $i$f$map = false;
        Iterable it3 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void instruction;
            TransactionInstruction transactionInstruction = (TransactionInstruction)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl = false;
            PublicKey programId = instruction.component1();
            byte[] data = instruction.component3();
            Object object = instruction.getKeys();
            int n = accountKeys.indexOf(programId);
            boolean $i$f$map2 = false;
            void var27_61 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void meta;
                AccountMeta accountMeta = (AccountMeta)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(accountKeys.indexOf(meta.getPublicKey()));
            }
            collection = (List)destination$iv$iv2;
            object = Base58.encode((byte[])data);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"encode(data)");
            Object object2 = object;
            List list = collection;
            int n3 = n;
            collection2.add(new CompiledInstruction(n3, list, (String)object2));
        }
        List instructions = (List)destination$iv$iv3;
        Object object = instructions.iterator();
        while (object.hasNext()) {
            CompiledInstruction instruction = (CompiledInstruction)object.next();
            if (!(instruction.getProgramIdIndex() >= 0)) {
                String destination$iv$iv3 = "Failed requirement.";
                throw new IllegalArgumentException(destination$iv$iv3.toString());
            }
            Iterable $this$forEach$iv2 = instruction.getAccounts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                int keyIndex = ((Number)element$iv).intValue();
                boolean bl = false;
                if (keyIndex >= 0) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        Object $this$compileMessage_u24lambda_u2d20 = object = new MessageHeader();
        boolean bl = false;
        ((MessageHeader)$this$compileMessage_u24lambda_u2d20).setNumRequiredSignatures((byte)numRequiredSignatures);
        ((MessageHeader)$this$compileMessage_u24lambda_u2d20).setNumReadonlySignedAccounts((byte)numReadonlySignedAccounts);
        ((MessageHeader)$this$compileMessage_u24lambda_u2d20).setNumReadonlyUnsignedAccounts((byte)numReadonlyUnsignedAccounts);
        List list = instructions;
        String string = this.getRecentBlockhash();
        List list2 = accountKeys;
        Object object3 = object;
        return new Message((MessageHeader)object3, list2, string, list);
    }

    @NotNull
    public final byte[] serializeMessage() {
        return this.compile$web3().serialize();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getEstimatedFee(@NotNull Connection var1_1, @NotNull Continuation<? super Long> var2_2) {
        if (!(var2_2 instanceof getEstimatedFee.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ Transaction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getEstimatedFee(null, (Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = Connection.getFeeForMessage$default((Connection)connection, this.compileMessage(), null, (Continuation)$continuation, 2, null);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Boxing.boxLong((long)((RpcResultTypes.ValueLong)v0).getValue());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final byte[] serialize(@NotNull SerializeConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] signData = this.serializeMessage();
        if (config.getVerifySignatures() && !this.verifySignatures(signData, config.getRequireAllSignatures())) {
            throw new Error("Signature verification failed");
        }
        return this.serialize$web3(signData);
    }

    public static /* synthetic */ byte[] serialize$default(Transaction transaction, SerializeConfig serializeConfig, int n, Object object) {
        if ((n & 1) != 0) {
            serializeConfig = new SerializeConfig(false, false, 3, null);
        }
        return transaction.serialize(serializeConfig);
    }

    @NotNull
    public final byte[] serialize$web3(@NotNull byte[] signData) {
        Intrinsics.checkNotNullParameter((Object)signData, (String)"signData");
        byte[] signatureCount = Shortvec.encodeLength(((Collection)this.signatures).size());
        int transactionLength = signatureCount.length + ((Collection)this.signatures).size() * 64 + signData.length;
        ByteBuffer wireTransaction = ByteBuffer.allocate(transactionLength);
        if (!(((Collection)this.signatures).size() < 256)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        wireTransaction.put(signatureCount);
        Iterable $this$forEach$iv = this.signatures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SignaturePubkeyPair $dstr$signature$_u24__u24 = (SignaturePubkeyPair)element$iv;
            boolean bl = false;
            byte[] signature = $dstr$signature$_u24__u24.component1();
            if (signature != null) {
                if (!(signature.length == 64)) {
                    boolean bl2 = false;
                    String string = "signature has invalid length";
                    throw new IllegalArgumentException(string.toString());
                }
                wireTransaction.put(signature);
                continue;
            }
            wireTransaction.put(new byte[64]);
        }
        wireTransaction.put(signData);
        byte[] out = wireTransaction.array();
        Intrinsics.checkNotNullExpressionValue((Object)out, (String)"out");
        if (!(out.length <= 1232)) {
            boolean bl = false;
            String string = "Transaction too large: " + out.length + " > 1232";
            throw new IllegalArgumentException(string.toString());
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated since v0.84.0.")
    public final void setSigners(PublicKey ... signers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)signers, (String)"signers");
        if (!(!(signers.length == 0))) {
            boolean $i$a$-require-Transaction$setSigners$22 = false;
            String $i$a$-require-Transaction$setSigners$22 = "No signers";
            throw new IllegalArgumentException($i$a$-require-Transaction$setSigners$22.toString());
        }
        Set seen = new LinkedHashSet();
        PublicKey[] $i$a$-require-Transaction$setSigners$22 = signers;
        Transaction transaction = this;
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = 0;
        int n2 = ((void)iterator).length;
        while (n < n2) {
            boolean bl;
            void element$iv$iv = iterator[n];
            ++n;
            void key = element$iv$iv;
            boolean bl2 = false;
            if (seen.contains(key)) {
                bl = false;
            } else {
                seen.add(key);
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void publicKey;
            PublicKey publicKey2 = (PublicKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SignaturePubkeyPair(null, (PublicKey)publicKey));
        }
        transaction.signatures = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/portto/solana/web3/Transaction$Companion;", "", "()V", "from", "Lcom/portto/solana/web3/Transaction;", "buffer", "", "populate", "message", "Lcom/portto/solana/web3/Message;", "signatures", "", "", "web3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Transaction from(@NotNull byte[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            byte[] byteArray = buffer;
            Pair<Integer, byte[]> signatureCount = Shortvec.decodeLength(byteArray);
            byteArray = (byte[])signatureCount.getSecond();
            List signatures = new ArrayList();
            int n = 0;
            int n2 = ((Number)signatureCount.getFirst()).intValue();
            while (n < n2) {
                int i = n++;
                List signature = ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)64));
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)64));
                String string = Base58.encode((byte[])CollectionsKt.toByteArray((Collection)signature));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(signature.toByteArray())");
                signatures.add(string);
            }
            return this.populate(Message.Companion.from(byteArray), signatures);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Transaction populate(@NotNull Message message, @NotNull List<String> signatures) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            Transaction transaction = new Transaction();
            transaction.setRecentBlockhash(message.getRecentBlockhash());
            if (message.getHeader().getNumRequiredSignatures() > 0) {
                transaction.setFeePayer(message.getAccountKeys().get(0));
            }
            Iterable $this$forEachIndexed$iv = signatures;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void signature;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (String)item$iv;
                int index = n;
                boolean bl2 = false;
                transaction.getSignatures().add(new SignaturePubkeyPair(Intrinsics.areEqual((Object)signature, (Object)Base58.encode((byte[])TransactionKt.getDEFAULT_SIGNATURE())) ? (byte[])null : Base58.decode((String)signature), message.getAccountKeys().get(index)));
            }
            Iterable $this$forEach$iv = message.getInstructions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                CompiledInstruction instruction = (CompiledInstruction)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = instruction.getAccounts();
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    boolean bl3;
                    PublicKey publicKey;
                    void account;
                    Collection collection;
                    block8: {
                        void $this$any$iv;
                        int n = ((Number)item$iv$iv).intValue();
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        PublicKey pubkey = message.getAccountKeys().get((int)account);
                        Iterable iterable = transaction.getSignatures();
                        publicKey = pubkey;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                SignaturePubkeyPair keyObj = (SignaturePubkeyPair)element$iv2;
                                boolean bl5 = false;
                                if (!(keyObj.getPublicKey().toString() == pubkey.toString())) continue;
                                bl3 = true;
                                break block8;
                            }
                            bl3 = false;
                        }
                    }
                    boolean bl6 = bl3;
                    boolean bl7 = message.isAccountWritable((int)account);
                    boolean bl8 = bl6 || message.isAccountSigner((int)account);
                    PublicKey publicKey2 = publicKey;
                    collection.add(new AccountMeta(publicKey2, bl8, bl7));
                }
                List keys = (List)destination$iv$iv;
                List<TransactionInstruction> list = transaction.getInstructions();
                object = message.getAccountKeys().get(instruction.getProgramIdIndex());
                byte[] byArray = Base58.decode((String)instruction.getData());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(instruction.data)");
                list.add(new TransactionInstruction((PublicKey)object, keys, byArray));
            }
            return transaction;
        }

        public static /* synthetic */ Transaction populate$default(Companion companion, Message message, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.populate(message, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

