/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3;

import com.portto.solana.web3.util.BorshCodable;
import com.portto.solana.web3.util.ByteUtils;
import com.portto.solana.web3.util.TweetNaclFast;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Sha256Hash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0000J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/portto/solana/web3/PublicKey;", "Lcom/portto/solana/web3/util/BorshCodable;", "pubkeyString", "", "(Ljava/lang/String;)V", "pubkey", "", "([B)V", "getPubkey", "()[B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toBase58", "toByteArray", "toString", "Companion", "ProgramDerivedAddress", "web3"})
public final class PublicKey
implements BorshCodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] pubkey;
    public static final int PUBLIC_KEY_LENGTH = 32;

    public PublicKey(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        this.pubkey = pubkey;
        if (!(this.pubkey.length <= 32)) {
            boolean bl = false;
            String string = "Invalid public key input";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] getPubkey() {
        return this.pubkey;
    }

    public PublicKey(@NotNull String pubkeyString) {
        Intrinsics.checkNotNullParameter((Object)pubkeyString, (String)"pubkeyString");
        byte[] byArray = Base58.decode((String)pubkeyString);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(pubkeyString)");
        this(byArray);
    }

    @NotNull
    public final byte[] toByteArray() {
        return this.pubkey;
    }

    @NotNull
    public final String toBase58() {
        String string = Base58.encode((byte[])this.pubkey);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(pubkey)");
        return string;
    }

    public final boolean equals(@NotNull PublicKey pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        return Arrays.equals(this.pubkey, pubkey.toByteArray());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.pubkey);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        PublicKey person = (PublicKey)other;
        return this.equals(person);
    }

    @NotNull
    public String toString() {
        return this.toBase58();
    }

    @NotNull
    public final byte[] component1() {
        return this.pubkey;
    }

    @NotNull
    public final PublicKey copy(@NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        return new PublicKey(pubkey);
    }

    public static /* synthetic */ PublicKey copy$default(PublicKey publicKey, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = publicKey.pubkey;
        }
        return publicKey.copy(byArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/portto/solana/web3/PublicKey$ProgramDerivedAddress;", "", "address", "Lcom/portto/solana/web3/PublicKey;", "nonce", "", "(Lcom/portto/solana/web3/PublicKey;I)V", "getAddress", "()Lcom/portto/solana/web3/PublicKey;", "getNonce", "()I", "web3"})
    public static final class ProgramDerivedAddress {
        @NotNull
        private final PublicKey address;
        private final int nonce;

        public ProgramDerivedAddress(@NotNull PublicKey address, int nonce) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.nonce = nonce;
        }

        @NotNull
        public final PublicKey getAddress() {
            return this.address;
        }

        public final int getNonce() {
            return this.nonce;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/portto/solana/web3/PublicKey$Companion;", "", "()V", "PUBLIC_KEY_LENGTH", "", "createProgramAddress", "Lcom/portto/solana/web3/PublicKey;", "seeds", "", "", "programId", "findProgramAddress", "Lcom/portto/solana/web3/PublicKey$ProgramDerivedAddress;", "readPubkey", "bytes", "offset", "valueOf", "publicKey", "", "web3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PublicKey readPubkey(@NotNull byte[] bytes, int offset) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            byte[] buf = ByteUtils.readBytes(bytes, offset, 32);
            return new PublicKey(buf);
        }

        @NotNull
        public final PublicKey createProgramAddress(@NotNull List<byte[]> seeds, @NotNull PublicKey programId) {
            Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (byte[] seed : seeds) {
                if (!(seed.length <= 32)) {
                    boolean bl = false;
                    String string = "Max seed length exceeded";
                    throw new IllegalArgumentException(string.toString());
                }
                try {
                    buffer.write(seed);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                buffer.write(programId.toByteArray());
                String string = "ProgramDerivedAddress";
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                buffer.write(byArray);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] hash = Sha256Hash.hash((byte[])buffer.toByteArray());
            if (TweetNaclFast.is_on_curve(hash) != 0) {
                throw new RuntimeException("Invalid seeds, address must fall off the curve");
            }
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
            return new PublicKey(hash);
        }

        @NotNull
        public final ProgramDerivedAddress findProgramAddress(@NotNull List<byte[]> seeds, @NotNull PublicKey programId) throws Exception {
            Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
            Intrinsics.checkNotNullParameter((Object)programId, (String)"programId");
            int nonce = 255;
            Object address = null;
            List seedsWithNonce = new ArrayList();
            seedsWithNonce.addAll((Collection)seeds);
            while (nonce != 0) {
                Object object;
                try {
                    object = new byte[]{(byte)nonce};
                    seedsWithNonce.add(object);
                    object = this.createProgramAddress(seedsWithNonce, programId);
                }
                catch (Exception e) {
                    seedsWithNonce.remove(seedsWithNonce.size() - 1);
                    int n = nonce;
                    nonce = n + -1;
                    continue;
                }
                address = object;
                return new ProgramDerivedAddress((PublicKey)address, nonce);
            }
            throw new Exception("Unable to find a viable program address nonce");
        }

        @NotNull
        public final PublicKey valueOf(@NotNull String publicKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            return new PublicKey(publicKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

