/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3;

import com.portto.solana.web3.FeeCalculator;
import com.portto.solana.web3.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.near.borshj.BorshBuffer;
import org.tinylog.kotlin.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/portto/solana/web3/NonceAccount;", "", "authorizedPubkey", "Lcom/portto/solana/web3/PublicKey;", "nonce", "", "Lcom/portto/solana/web3/Blockhash;", "feeCalculator", "Lcom/portto/solana/web3/FeeCalculator;", "(Lcom/portto/solana/web3/PublicKey;Ljava/lang/String;Lcom/portto/solana/web3/FeeCalculator;)V", "getAuthorizedPubkey", "()Lcom/portto/solana/web3/PublicKey;", "getFeeCalculator", "()Lcom/portto/solana/web3/FeeCalculator;", "getNonce", "()Ljava/lang/String;", "Companion", "web3"})
public final class NonceAccount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKey authorizedPubkey;
    @NotNull
    private final String nonce;
    @NotNull
    private final FeeCalculator feeCalculator;

    public NonceAccount(@NotNull PublicKey authorizedPubkey, @NotNull String nonce, @NotNull FeeCalculator feeCalculator) {
        Intrinsics.checkNotNullParameter((Object)authorizedPubkey, (String)"authorizedPubkey");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)feeCalculator, (String)"feeCalculator");
        this.authorizedPubkey = authorizedPubkey;
        this.nonce = nonce;
        this.feeCalculator = feeCalculator;
    }

    @NotNull
    public final PublicKey getAuthorizedPubkey() {
        return this.authorizedPubkey;
    }

    @NotNull
    public final String getNonce() {
        return this.nonce;
    }

    @NotNull
    public final FeeCalculator getFeeCalculator() {
        return this.feeCalculator;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/portto/solana/web3/NonceAccount$Companion;", "", "()V", "fromAccountData", "Lcom/portto/solana/web3/NonceAccount;", "buffer", "", "web3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NonceAccount fromAccountData(@NotNull byte[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Object object = BorshBuffer.wrap(buffer);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wrap(buffer)");
            BorshBuffer nonceAccount = object;
            Logger.INSTANCE.info(Intrinsics.stringPlus((String)"version:", (Object)nonceAccount.readU32()));
            Logger.INSTANCE.info(Intrinsics.stringPlus((String)"state:", (Object)nonceAccount.readU32()));
            object = nonceAccount.readFixedArray(32);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nonceAccount.readFixedArray(32)");
            PublicKey publicKey = new PublicKey((byte[])object);
            object = nonceAccount.readFixedArray(32);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nonceAccount.readFixedArray(32)");
            return new NonceAccount(publicKey, new PublicKey((byte[])object).toString(), new FeeCalculator(nonceAccount.readU64()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

