/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3;

import com.portto.solana.web3.MessageHeader;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.util.Shortvec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bitcoinj.core.Base58;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.near.borshj.BorshBuffer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002$%B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/portto/solana/web3/Message;", "", "header", "Lcom/portto/solana/web3/MessageHeader;", "accountKeys", "", "Lcom/portto/solana/web3/PublicKey;", "recentBlockhash", "", "Lcom/portto/solana/web3/Blockhash;", "instructions", "Lcom/portto/solana/web3/CompiledInstruction;", "(Lcom/portto/solana/web3/MessageHeader;Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "getAccountKeys", "()Ljava/util/List;", "feePayer", "getHeader", "()Lcom/portto/solana/web3/MessageHeader;", "indexToProgramIds", "", "", "getInstructions", "getRecentBlockhash", "()Ljava/lang/String;", "isAccountSigner", "", "index", "isAccountWritable", "isProgramId", "nonProgramIds", "programIds", "serialize", "", "setFeePayer", "", "publicKey", "Companion", "CompiledInstruction", "web3"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageHeader header;
    @NotNull
    private final List<PublicKey> accountKeys;
    @NotNull
    private final String recentBlockhash;
    @NotNull
    private final List<com.portto.solana.web3.CompiledInstruction> instructions;
    @NotNull
    private Map<Integer, PublicKey> indexToProgramIds;
    @Nullable
    private PublicKey feePayer;
    private static final int RECENT_BLOCK_HASH_LENGTH = 32;

    public Message(@NotNull MessageHeader header, @NotNull List<PublicKey> accountKeys, @NotNull String recentBlockhash2, @NotNull List<com.portto.solana.web3.CompiledInstruction> instructions) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(accountKeys, (String)"accountKeys");
        Intrinsics.checkNotNullParameter((Object)recentBlockhash2, (String)"recentBlockhash");
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        this.header = header;
        this.accountKeys = accountKeys;
        this.recentBlockhash = recentBlockhash2;
        this.instructions = instructions;
        this.indexToProgramIds = new LinkedHashMap();
        Iterable $this$forEach$iv = this.instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.portto.solana.web3.CompiledInstruction ix = (com.portto.solana.web3.CompiledInstruction)element$iv;
            boolean bl = false;
            this.indexToProgramIds.put(ix.getProgramIdIndex(), this.getAccountKeys().get(ix.getProgramIdIndex()));
        }
    }

    @NotNull
    public final MessageHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final List<PublicKey> getAccountKeys() {
        return this.accountKeys;
    }

    @NotNull
    public final String getRecentBlockhash() {
        return this.recentBlockhash;
    }

    @NotNull
    public final List<com.portto.solana.web3.CompiledInstruction> getInstructions() {
        return this.instructions;
    }

    public final boolean isAccountSigner(int index) {
        return index < this.header.getNumRequiredSignatures();
    }

    public final boolean isAccountWritable(int index) {
        return index < this.header.getNumRequiredSignatures() - this.header.getNumReadonlySignedAccounts() || index >= this.header.getNumRequiredSignatures() && index < ((Collection)this.accountKeys).size() - this.header.getNumReadonlyUnsignedAccounts();
    }

    public final boolean isProgramId(int index) {
        return this.indexToProgramIds.containsKey(index);
    }

    @NotNull
    public final List<PublicKey> programIds() {
        return CollectionsKt.toList((Iterable)this.indexToProgramIds.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PublicKey> nonProgramIds() {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = this.accountKeys;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n = index$iv$iv$iv;
            index$iv$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            PublicKey publicKey = (PublicKey)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!(!this.isProgramId(index))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serialize() {
        void $this$mapTo$iv$iv;
        if (!(((CharSequence)this.recentBlockhash).length() > 0)) {
            boolean $i$a$-require-Message$serialize$32 = false;
            String $i$a$-require-Message$serialize$32 = "recentBlockhash required";
            throw new IllegalArgumentException($i$a$-require-Message$serialize$32.toString());
        }
        if (!(!((Collection)this.instructions).isEmpty())) {
            boolean $i$a$-require-Message$serialize$42 = false;
            String $i$a$-require-Message$serialize$42 = "No instructions provided";
            throw new IllegalArgumentException($i$a$-require-Message$serialize$42.toString());
        }
        int numKeys = ((Collection)this.accountKeys).size();
        byte[] keyCount = Shortvec.encodeLength(numKeys);
        int compiledInstructionsLength = 0;
        Iterable $this$map$iv = this.instructions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Byte> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void instruction;
            com.portto.solana.web3.CompiledInstruction compiledInstruction = (com.portto.solana.web3.CompiledInstruction)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            int programIdIndex = instruction.component1();
            List<Integer> accounts = instruction.component2();
            byte[] data = Base58.decode((String)instruction.getData());
            byte[] keyIndicesCount = Shortvec.encodeLength(((Collection)accounts).size());
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            byte[] dataCount = Shortvec.encodeLength(data.length);
            Iterable iterable2 = accounts;
            byte[] byArray = keyIndicesCount;
            byte by = (byte)programIdIndex;
            boolean $i$f$map2 = false;
            void var23_27 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p0;
                int n = ((Number)item$iv$iv2).intValue();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((byte)p0);
            }
            collection = (List)destination$iv$iv2;
            byte[] byArray2 = data;
            byte[] byArray3 = dataCount;
            byte[] byArray4 = CollectionsKt.toByteArray((Collection)collection);
            byte[] byArray5 = byArray;
            byte by2 = by;
            collection2.add(new CompiledInstruction(by2, byArray5, byArray4, byArray3, byArray2));
        }
        List instructions = (List)destination$iv$iv;
        byte[] instructionCount = Shortvec.encodeLength(instructions.size());
        int bufferSize = 35 + keyCount.length + numKeys * 32 + instructionCount.length + compiledInstructionsLength;
        ByteBuffer out = ByteBuffer.allocate(bufferSize);
        ByteBuffer accountKeysBuff = ByteBuffer.allocate(numKeys * 32);
        Object object = BorshBuffer.allocate(2048);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocate(2048)");
        Iterator<PublicKey> buffer = object;
        ((BorshBuffer)((Object)buffer)).write(this.header.getNumRequiredSignatures());
        ((BorshBuffer)((Object)buffer)).write(this.header.getNumReadonlySignedAccounts());
        ((BorshBuffer)((Object)buffer)).write(this.header.getNumReadonlyUnsignedAccounts());
        ((BorshBuffer)((Object)buffer)).write(keyCount);
        for (PublicKey accountKey : this.accountKeys) {
            ((BorshBuffer)((Object)buffer)).write(accountKey.getPubkey());
        }
        ((BorshBuffer)((Object)buffer)).write(Base58.decode((String)this.recentBlockhash));
        ((BorshBuffer)((Object)buffer)).write(instructionCount);
        for (CompiledInstruction instruction : instructions) {
            ((BorshBuffer)((Object)buffer)).write(instruction.getProgramIdIndex());
            ((BorshBuffer)((Object)buffer)).write(instruction.getKeyIndicesCount());
            ((BorshBuffer)((Object)buffer)).write(instruction.getKeyIndices());
            ((BorshBuffer)((Object)buffer)).write(instruction.getDataLength());
            ((BorshBuffer)((Object)buffer)).write(instruction.getData());
        }
        object = ((BorshBuffer)((Object)buffer)).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buffer.toByteArray()");
        return object;
    }

    public final void setFeePayer(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.feePayer = publicKey;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0015H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/portto/solana/web3/Message$CompiledInstruction;", "", "programIdIndex", "", "keyIndicesCount", "", "keyIndices", "dataLength", "data", "(B[B[B[B[B)V", "getData", "()[B", "setData", "([B)V", "getDataLength", "setDataLength", "getKeyIndices", "setKeyIndices", "getKeyIndicesCount", "setKeyIndicesCount", "length", "", "getLength", "()I", "getProgramIdIndex", "()B", "setProgramIdIndex", "(B)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "web3"})
    public static final class CompiledInstruction {
        private byte programIdIndex;
        @NotNull
        private byte[] keyIndicesCount;
        @NotNull
        private byte[] keyIndices;
        @NotNull
        private byte[] dataLength;
        @NotNull
        private byte[] data;

        public CompiledInstruction(byte programIdIndex, @NotNull byte[] keyIndicesCount, @NotNull byte[] keyIndices, @NotNull byte[] dataLength, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)keyIndicesCount, (String)"keyIndicesCount");
            Intrinsics.checkNotNullParameter((Object)keyIndices, (String)"keyIndices");
            Intrinsics.checkNotNullParameter((Object)dataLength, (String)"dataLength");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.programIdIndex = programIdIndex;
            this.keyIndicesCount = keyIndicesCount;
            this.keyIndices = keyIndices;
            this.dataLength = dataLength;
            this.data = data;
        }

        public /* synthetic */ CompiledInstruction(byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                by = 0;
            }
            this(by, byArray, byArray2, byArray3, byArray4);
        }

        public final byte getProgramIdIndex() {
            return this.programIdIndex;
        }

        public final void setProgramIdIndex(byte by) {
            this.programIdIndex = by;
        }

        @NotNull
        public final byte[] getKeyIndicesCount() {
            return this.keyIndicesCount;
        }

        public final void setKeyIndicesCount(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.keyIndicesCount = byArray;
        }

        @NotNull
        public final byte[] getKeyIndices() {
            return this.keyIndices;
        }

        public final void setKeyIndices(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.keyIndices = byArray;
        }

        @NotNull
        public final byte[] getDataLength() {
            return this.dataLength;
        }

        public final void setDataLength(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.dataLength = byArray;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public final void setData(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.data = byArray;
        }

        public final int getLength() {
            return 1 + this.keyIndicesCount.length + this.keyIndices.length + this.dataLength.length + this.data.length;
        }

        public final byte component1() {
            return this.programIdIndex;
        }

        @NotNull
        public final byte[] component2() {
            return this.keyIndicesCount;
        }

        @NotNull
        public final byte[] component3() {
            return this.keyIndices;
        }

        @NotNull
        public final byte[] component4() {
            return this.dataLength;
        }

        @NotNull
        public final byte[] component5() {
            return this.data;
        }

        @NotNull
        public final CompiledInstruction copy(byte programIdIndex, @NotNull byte[] keyIndicesCount, @NotNull byte[] keyIndices, @NotNull byte[] dataLength, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)keyIndicesCount, (String)"keyIndicesCount");
            Intrinsics.checkNotNullParameter((Object)keyIndices, (String)"keyIndices");
            Intrinsics.checkNotNullParameter((Object)dataLength, (String)"dataLength");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new CompiledInstruction(programIdIndex, keyIndicesCount, keyIndices, dataLength, data);
        }

        public static /* synthetic */ CompiledInstruction copy$default(CompiledInstruction compiledInstruction, byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, Object object) {
            if ((n & 1) != 0) {
                by = compiledInstruction.programIdIndex;
            }
            if ((n & 2) != 0) {
                byArray = compiledInstruction.keyIndicesCount;
            }
            if ((n & 4) != 0) {
                byArray2 = compiledInstruction.keyIndices;
            }
            if ((n & 8) != 0) {
                byArray3 = compiledInstruction.dataLength;
            }
            if ((n & 0x10) != 0) {
                byArray4 = compiledInstruction.data;
            }
            return compiledInstruction.copy(by, byArray, byArray2, byArray3, byArray4);
        }

        @NotNull
        public String toString() {
            return "CompiledInstruction(programIdIndex=" + this.programIdIndex + ", keyIndicesCount=" + Arrays.toString(this.keyIndicesCount) + ", keyIndices=" + Arrays.toString(this.keyIndices) + ", dataLength=" + Arrays.toString(this.dataLength) + ", data=" + Arrays.toString(this.data) + ')';
        }

        public int hashCode() {
            int result = Byte.hashCode(this.programIdIndex);
            result = result * 31 + Arrays.hashCode(this.keyIndicesCount);
            result = result * 31 + Arrays.hashCode(this.keyIndices);
            result = result * 31 + Arrays.hashCode(this.dataLength);
            result = result * 31 + Arrays.hashCode(this.data);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompiledInstruction)) {
                return false;
            }
            CompiledInstruction compiledInstruction = (CompiledInstruction)other;
            if (this.programIdIndex != compiledInstruction.programIdIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keyIndicesCount, (Object)compiledInstruction.keyIndicesCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keyIndices, (Object)compiledInstruction.keyIndices)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dataLength, (Object)compiledInstruction.dataLength)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)compiledInstruction.data);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/portto/solana/web3/Message$Companion;", "", "()V", "RECENT_BLOCK_HASH_LENGTH", "", "from", "Lcom/portto/solana/web3/Message;", "buffer", "", "web3"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Message from(@NotNull byte[] buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object dataSlice;
            byte by;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Object byteArray = null;
            byteArray = buffer;
            byte it = by = ArraysKt.first((byte[])byteArray);
            boolean bl = false;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numRequiredSignatures = by;
            byte it2 = it = ArraysKt.first((byte[])byteArray);
            boolean bl2 = false;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numReadonlySignedAccounts = it;
            byte it3 = it2 = ArraysKt.first((byte[])byteArray);
            int n = 0;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numReadonlyUnsignedAccounts = it2;
            Pair<Integer, byte[]> accountCount = Shortvec.decodeLength(byteArray);
            byteArray = accountCount.getSecond();
            List accountKeys = new ArrayList();
            n = 0;
            int n2 = ((Number)accountCount.getFirst()).intValue();
            while (n < n2) {
                int i = n++;
                List account22 = ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)32));
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)32));
                String string = Base58.encode((byte[])CollectionsKt.toByteArray((Collection)account22));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(account.toByteArray())");
                accountKeys.add(string);
            }
            byte[] recentBlockhash2 = CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)32)));
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)32));
            Pair<Integer, byte[]> instructionCount = Shortvec.decodeLength(byteArray);
            byteArray = instructionCount.getSecond();
            List instructions = new ArrayList();
            int account22 = 0;
            int n3 = ((Number)instructionCount.getFirst()).intValue();
            while (account22 < n3) {
                void $this$mapTo$iv$iv2;
                byte by2;
                int i = account22++;
                byte it4 = by2 = ArraysKt.first((byte[])byteArray);
                boolean bl3 = false;
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
                byte programIdIndex = by2;
                Pair<Integer, byte[]> accountCount2 = Shortvec.decodeLength(byteArray);
                byteArray = accountCount2.getSecond();
                Iterable $this$map$iv2 = ArraysKt.toList((byte[])CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)((Number)accountCount2.getFirst()).intValue()))));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    byte by3 = ((Number)item$iv$iv).byteValue();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add((int)p0);
                }
                List accounts = (List)destination$iv$iv;
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)((Number)accountCount2.getFirst()).intValue()));
                Pair<Integer, byte[]> dataLength = Shortvec.decodeLength(byteArray);
                byteArray = dataLength.getSecond();
                dataSlice = CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)((Number)dataLength.getFirst()).intValue())));
                String data = Base58.encode((byte[])dataSlice);
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)((Number)dataLength.getFirst()).intValue()));
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                instructions.add(new com.portto.solana.web3.CompiledInstruction(programIdIndex, accounts, data));
            }
            Object account22 = new MessageHeader();
            MessageHeader $this$from_u24lambda_u2d4 = account22;
            boolean $i$a$-apply-Message$Companion$from$22 = false;
            $this$from_u24lambda_u2d4.setNumRequiredSignatures(numRequiredSignatures);
            $this$from_u24lambda_u2d4.setNumReadonlySignedAccounts(numReadonlySignedAccounts);
            $this$from_u24lambda_u2d4.setNumReadonlyUnsignedAccounts(numReadonlyUnsignedAccounts);
            MessageHeader messageHeader = account22;
            account22 = accountKeys;
            MessageHeader messageHeader2 = messageHeader;
            boolean $i$f$map = false;
            void $i$a$-apply-Message$Companion$from$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                dataSlice = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(new PublicKey((String)it5));
            }
            List list = instructions;
            String string = Intrinsics.stringPlus((String)new String(), (Object)Base58.encode((byte[])recentBlockhash2));
            List list2 = (List)destination$iv$iv;
            MessageHeader messageHeader3 = messageHeader2;
            return new Message(messageHeader3, list2, string, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

