/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3;

import com.portto.solana.web3.DerivationPath;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.util.TweetNaclFast;
import com.portto.solana.web3.wallet.DerivableType;
import com.portto.solana.web3.wallet.SolanaBip44;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bitcoinj.crypto.DeterministicHierarchy;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.HDUtils;
import org.bitcoinj.crypto.MnemonicCode;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="since v1.10.0, please use {@link Keypair} instead.")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/portto/solana/web3/Account;", "", "()V", "secretKey", "", "([B)V", "keyPair", "Lcom/portto/solana/web3/util/TweetNaclFast$Signature$KeyPair;", "(Lcom/portto/solana/web3/util/TweetNaclFast$Signature$KeyPair;)V", "publicKey", "Lcom/portto/solana/web3/PublicKey;", "getPublicKey", "()Lcom/portto/solana/web3/PublicKey;", "getSecretKey", "()[B", "Companion", "web3"})
public final class Account {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TweetNaclFast.Signature.KeyPair keyPair;

    public Account() {
        TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair()");
        this.keyPair = keyPair;
    }

    public Account(@NotNull byte[] secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSecretKey(secretKey);
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair_fromSecretKey(secretKey)");
        this.keyPair = keyPair;
    }

    public Account(@NotNull TweetNaclFast.Signature.KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.keyPair = keyPair;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        byte[] byArray = this.keyPair.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.publicKey");
        return new PublicKey(byArray);
    }

    @NotNull
    public final byte[] getSecretKey() {
        byte[] byArray = this.keyPair.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.secretKey");
        return byArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001e\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001e\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006J&\u0010\u0010\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/portto/solana/web3/Account$Companion;", "", "()V", "convertJsonStringToByteArray", "", "characters", "", "fromBip44Mnemonic", "Lcom/portto/solana/web3/Account;", "words", "", "passphrase", "fromBip44MnemonicWithChange", "fromDeprecatedMnemonic", "fromJson", "json", "fromMnemonic", "derivationPath", "Lcom/portto/solana/web3/DerivationPath;", "web3"})
    public static final class Companion {
        private Companion() {
        }

        private final Account fromBip44Mnemonic(List<String> words, String passphrase) {
            SolanaBip44 solanaBip44 = new SolanaBip44();
            byte[] seed = MnemonicCode.toSeed(words, (String)passphrase);
            Intrinsics.checkNotNullExpressionValue((Object)seed, (String)"seed");
            byte[] privateKey = solanaBip44.getPrivateKeyFromSeed(seed, DerivableType.BIP44);
            TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSeed(privateKey);
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair_fromSeed(privateKey)");
            return new Account(keyPair);
        }

        private final Account fromBip44MnemonicWithChange(List<String> words, String passphrase) {
            SolanaBip44 solanaBip44 = new SolanaBip44();
            byte[] seed = MnemonicCode.toSeed(words, (String)passphrase);
            Intrinsics.checkNotNullExpressionValue((Object)seed, (String)"seed");
            byte[] privateKey = solanaBip44.getPrivateKeyFromSeed(seed, DerivableType.BIP44CHANGE);
            TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSeed(privateKey);
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair_fromSeed(privateKey)");
            return new Account(keyPair);
        }

        private final Account fromDeprecatedMnemonic(List<String> words, String passphrase) {
            byte[] seed = MnemonicCode.toSeed(words, (String)passphrase);
            DeterministicKey masterPrivateKey = HDKeyDerivation.createMasterPrivateKey((byte[])seed);
            DeterministicHierarchy deterministicHierarchy = new DeterministicHierarchy(masterPrivateKey);
            DeterministicKey child = deterministicHierarchy.get((List)HDUtils.parsePath((String)DerivationPath.DEPRECATED_M_501H_0H_0_0.INSTANCE.getPath()), true, true);
            TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSeed(child.getPrivKeyBytes());
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair");
            return new Account(keyPair);
        }

        @NotNull
        public final Account fromMnemonic(@NotNull List<String> words, @NotNull String passphrase, @NotNull DerivationPath derivationPath) {
            Account account;
            Intrinsics.checkNotNullParameter(words, (String)"words");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)derivationPath, (String)"derivationPath");
            DerivationPath derivationPath2 = derivationPath;
            if (derivationPath2 instanceof DerivationPath.DEPRECATED_M_501H_0H_0_0) {
                account = this.fromDeprecatedMnemonic(words, passphrase);
            } else if (derivationPath2 instanceof DerivationPath.BIP44_M_44H_501H_0H) {
                account = this.fromBip44Mnemonic(words, passphrase);
            } else if (derivationPath2 instanceof DerivationPath.BIP44_M_44H_501H_0H_OH) {
                account = this.fromBip44MnemonicWithChange(words, passphrase);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return account;
        }

        public static /* synthetic */ Account fromMnemonic$default(Companion companion, List list, String string, DerivationPath derivationPath, int n, Object object) {
            if ((n & 4) != 0) {
                derivationPath = DerivationPath.BIP44_M_44H_501H_0H_OH.INSTANCE;
            }
            return companion.fromMnemonic(list, string, derivationPath);
        }

        @NotNull
        public final Account fromJson(@NotNull String json2) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            return new Account(this.convertJsonStringToByteArray(json2));
        }

        private final byte[] convertJsonStringToByteArray(String characters) {
            ByteBuffer buffer = ByteBuffer.allocate(64);
            CharSequence charSequence = characters;
            Object[] objectArray = new Regex("\\[");
            String string = "";
            charSequence = objectArray.replace(charSequence, string);
            objectArray = new Regex("]");
            string = "";
            String sanitizedJson = objectArray.replace(charSequence, string);
            objectArray = new String[]{","};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)sanitizedJson, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] chars = stringArray;
            Arrays.stream(chars).forEach(arg_0 -> Companion.convertJsonStringToByteArray$lambda-0(buffer, arg_0));
            objectArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buffer.array()");
            return objectArray;
        }

        private static final void convertJsonStringToByteArray$lambda-0(ByteBuffer $buffer, String character) {
            Intrinsics.checkNotNullParameter((Object)character, (String)"character");
            byte byteValue = (byte)Integer.parseInt(character);
            $buffer.put(byteValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

