/*
 * Decompiled with CFR 0.152.
 */
package com.popokis.popok.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class AsyncJSONParser {
    private final JsonParser parser;
    private final DeserializationContext deserializationContext;
    private final boolean tokenizeArrayElements;
    private final ByteArrayFeeder feeder;
    private TokenBuffer tokenBuffer;
    private int objectDepth;
    private int arrayDepth;

    public AsyncJSONParser(JsonParser parser, ObjectMapper mapper, boolean tokenizeArrayElements) {
        this.parser = parser;
        this.deserializationContext = mapper.getDeserializationContext();
        this.tokenizeArrayElements = tokenizeArrayElements;
        this.feeder = (ByteArrayFeeder)parser.getNonBlockingInputFeeder();
        this.tokenBuffer = new TokenBuffer(parser, mapper.getDeserializationContext());
    }

    public List<TokenBuffer> whole(byte[] data) {
        return this.parse(data, new ArrayList<TokenBuffer>());
    }

    public List<TokenBuffer> chunks(List<byte[]> data) {
        return data.stream().map(this::whole).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void endOfInput() {
        this.feeder.endOfInput();
    }

    private List<TokenBuffer> parse(byte[] data, List<TokenBuffer> result) {
        try {
            JsonToken token;
            if (!this.feeder.needMoreInput()) {
                throw new IOException("Got NOT_AVAILABLE, could not feed more input");
            }
            this.feeder.feedInput(data, 0, data.length);
            while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                this.updateDepth(token);
                if (this.tokenizeArrayElements) {
                    this.processTokenArray(token, result);
                    continue;
                }
                this.processTokenNormal(token, result);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<TokenBuffer>(result);
    }

    private void updateDepth(JsonToken token) {
        switch (token) {
            case START_OBJECT: {
                ++this.objectDepth;
                break;
            }
            case END_OBJECT: {
                --this.objectDepth;
                break;
            }
            case START_ARRAY: {
                ++this.arrayDepth;
                break;
            }
            case END_ARRAY: {
                --this.arrayDepth;
            }
        }
    }

    private void processTokenNormal(JsonToken token, List<TokenBuffer> result) throws IOException {
        this.tokenBuffer.copyCurrentEvent(this.parser);
        if ((token.isStructEnd() || token.isScalarValue()) && this.objectDepth == 0 && this.arrayDepth == 0) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser, this.deserializationContext);
        }
    }

    private void processTokenArray(JsonToken token, List<TokenBuffer> result) throws IOException {
        if (!this.isTopLevelArrayToken(token)) {
            this.tokenBuffer.copyCurrentEvent(this.parser);
        }
        if (!(this.objectDepth != 0 || this.arrayDepth != 0 && this.arrayDepth != 1 || token != JsonToken.END_OBJECT && !token.isScalarValue())) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser, this.deserializationContext);
        }
    }

    private boolean isTopLevelArrayToken(JsonToken token) {
        return this.objectDepth == 0 && (token == JsonToken.START_ARRAY && this.arrayDepth == 1 || token == JsonToken.END_ARRAY && this.arrayDepth == 0);
    }
}

