/*
 * Decompiled with CFR 0.152.
 */
package com.pollux.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.pollux.widget.R;

public class DualProgressView
extends View {
    private static final float INDETERMINANT_MIN_SWEEP = 15.0f;
    public static final int RESETTING_ANGLE = 620;
    private Paint mOuterCirclePaint;
    private Paint mInnerCirclePaint;
    private float mThickness;
    private float mInnerPadding;
    private int mAnimDuration;
    private RectF mOuterCircleRect;
    private RectF mInnerCircleRect;
    @ColorInt
    private int mOuterCircleColor;
    @ColorInt
    private int mInnerCircleColor;
    private int mSteps;
    private int mSize;
    private float mStartAngle;
    private float mIndeterminateSweep;
    private float mIndeterminateRotateOffset;
    private AnimatorSet mIndeterminateAnimator;

    public DualProgressView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public DualProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public DualProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    protected void init(AttributeSet attrs, int defStyle) {
        this.mOuterCirclePaint = new Paint(1);
        this.mInnerCirclePaint = new Paint(1);
        this.mOuterCircleRect = new RectF();
        this.mInnerCircleRect = new RectF();
        Resources resources = this.getResources();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DualProgressView, defStyle, 0);
        this.mThickness = a.getDimensionPixelSize(R.styleable.DualProgressView_dpv_thickness, resources.getDimensionPixelSize(R.dimen.default_thickness));
        this.mInnerPadding = a.getDimensionPixelSize(R.styleable.DualProgressView_dpv_inner_padding, resources.getDimensionPixelSize(R.dimen.default_inner_padding));
        this.mOuterCircleColor = a.getColor(R.styleable.DualProgressView_dpv_inner_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.progress_outer_color));
        this.mInnerCircleColor = a.getColor(R.styleable.DualProgressView_dpv_outer_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.progress_inner_color));
        this.mAnimDuration = a.getInteger(R.styleable.DualProgressView_dpv_anim_duration, resources.getInteger(R.integer.default_anim_duration));
        this.mSteps = resources.getInteger(R.integer.default_anim_step);
        this.mStartAngle = resources.getInteger(R.integer.default_start_angle);
        a.recycle();
        this.setPaint();
    }

    private void setPaint() {
        this.mOuterCirclePaint.setColor(this.mOuterCircleColor);
        this.mOuterCirclePaint.setStyle(Paint.Style.STROKE);
        this.mOuterCirclePaint.setStrokeWidth(this.mThickness);
        this.mOuterCirclePaint.setStrokeCap(Paint.Cap.BUTT);
        this.mInnerCirclePaint.setColor(this.mInnerCircleColor);
        this.mInnerCirclePaint.setStyle(Paint.Style.STROKE);
        this.mInnerCirclePaint.setStrokeWidth(this.mThickness);
        this.mInnerCirclePaint.setStrokeCap(Paint.Cap.BUTT);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.mOuterCircleRect, this.mStartAngle + this.mIndeterminateRotateOffset, this.mIndeterminateSweep, false, this.mOuterCirclePaint);
        canvas.drawArc(this.mInnerCircleRect, this.mStartAngle + this.mIndeterminateRotateOffset + 180.0f, this.mIndeterminateSweep, false, this.mInnerCirclePaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int xPad = this.getPaddingLeft() + this.getPaddingRight();
        int yPad = this.getPaddingTop() + this.getPaddingBottom();
        int width = this.getMeasuredWidth() - xPad;
        int height = this.getMeasuredHeight() - yPad;
        this.mSize = width < height ? width : height;
        this.setMeasuredDimension(this.mSize + xPad, this.mSize + yPad);
        this.updateRectAngleBounds();
    }

    private void updateRectAngleBounds() {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        this.mOuterCircleRect.set((float)paddingLeft + this.mThickness, (float)paddingTop + this.mThickness, (float)(this.mSize - paddingLeft) - this.mThickness, (float)(this.mSize - paddingTop) - this.mThickness);
        this.mInnerCircleRect.set((float)paddingLeft + this.mThickness + this.mInnerPadding, (float)paddingTop + this.mThickness + this.mInnerPadding, (float)(this.mSize - paddingLeft) - this.mThickness - this.mInnerPadding, (float)(this.mSize - paddingTop) - this.mThickness - this.mInnerPadding);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mSize = w < h ? w : h;
        this.updateRectAngleBounds();
    }

    private AnimatorSet createIndeterminateAnimator(float step) {
        final float maxSweep = 360.0f * (float)(this.mSteps - 1) / (float)this.mSteps + 15.0f;
        final float start = -90.0f + step * (maxSweep - 15.0f);
        final ValueAnimator frontEndExtend = ValueAnimator.ofFloat((float[])new float[]{15.0f, maxSweep});
        frontEndExtend.setDuration((long)(this.mAnimDuration / this.mSteps / 2));
        frontEndExtend.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        frontEndExtend.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DualProgressView.this.mIndeterminateSweep = ((Float)animation.getAnimatedValue()).floatValue();
                DualProgressView.this.invalidate();
            }
        });
        frontEndExtend.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                frontEndExtend.removeAllListeners();
                frontEndExtend.cancel();
            }
        });
        final ValueAnimator rotateAnimator1 = ValueAnimator.ofFloat((float[])new float[]{step * 720.0f / (float)this.mSteps, (step + 0.5f) * 720.0f / (float)this.mSteps});
        rotateAnimator1.setDuration((long)(this.mAnimDuration / this.mSteps / 2));
        rotateAnimator1.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DualProgressView.this.mIndeterminateRotateOffset = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        rotateAnimator1.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                rotateAnimator1.removeAllListeners();
                rotateAnimator1.cancel();
            }
        });
        final ValueAnimator backEndRetract = ValueAnimator.ofFloat((float[])new float[]{start, start + maxSweep - 15.0f});
        backEndRetract.setDuration((long)(this.mAnimDuration / this.mSteps / 2));
        backEndRetract.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        backEndRetract.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DualProgressView.this.mStartAngle = ((Float)animation.getAnimatedValue()).floatValue();
                DualProgressView.this.mIndeterminateSweep = maxSweep - DualProgressView.this.mStartAngle + start;
                DualProgressView.this.invalidate();
                if (DualProgressView.this.mStartAngle > 620.0f) {
                    DualProgressView.this.resetAnimation();
                }
            }
        });
        backEndRetract.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                backEndRetract.cancel();
                backEndRetract.removeAllListeners();
            }
        });
        final ValueAnimator rotateAnimator2 = ValueAnimator.ofFloat((float[])new float[]{(step + 0.5f) * 720.0f / (float)this.mSteps, (step + 1.0f) * 720.0f / (float)this.mSteps});
        rotateAnimator2.setDuration((long)(this.mAnimDuration / this.mSteps / 2));
        rotateAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DualProgressView.this.mIndeterminateRotateOffset = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        rotateAnimator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                rotateAnimator2.removeAllListeners();
                rotateAnimator2.cancel();
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)frontEndExtend).with((Animator)rotateAnimator1);
        set.play((Animator)backEndRetract).with((Animator)rotateAnimator2).after((Animator)rotateAnimator1);
        return set;
    }

    public void resetAnimation() {
        this.mStartAngle = this.getResources().getInteger(R.integer.default_start_angle);
        if (this.mIndeterminateAnimator != null && this.mIndeterminateAnimator.isRunning()) {
            this.mIndeterminateAnimator.cancel();
        }
        this.mIndeterminateSweep = 15.0f;
        this.mIndeterminateAnimator = new AnimatorSet();
        AnimatorSet prevSet = null;
        for (int k = 0; k < this.mSteps; ++k) {
            AnimatorSet nextSet = this.createIndeterminateAnimator(k);
            AnimatorSet.Builder builder = this.mIndeterminateAnimator.play((Animator)nextSet);
            if (prevSet != null) {
                builder.after((Animator)prevSet);
            }
            prevSet = nextSet;
        }
        this.mIndeterminateAnimator.start();
    }

    public void startAnimation() {
        this.resetAnimation();
    }

    public void stopAnimation() {
        if (this.mIndeterminateAnimator != null) {
            this.mIndeterminateAnimator.cancel();
            this.mIndeterminateAnimator.removeAllListeners();
            this.mIndeterminateAnimator = null;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int visibility) {
        int currentVisibility = this.getVisibility();
        super.setVisibility(visibility);
        if (visibility != currentVisibility) {
            if (visibility == 0) {
                this.resetAnimation();
            } else if (visibility == 8 || visibility == 4) {
                this.stopAnimation();
            }
        }
    }
}

