/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.internal.util.CheckerLocationProvider;
import com.polidea.rxandroidble2.internal.util.CheckerScanPermission;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;

public class LocationServicesStatusApi23
implements LocationServicesStatus {
    private final CheckerLocationProvider checkerLocationProvider;
    private final CheckerScanPermission checkerScanPermission;
    private final boolean isAndroidWear;
    private final int targetSdk;
    private final int deviceSdk;

    @Inject
    LocationServicesStatusApi23(CheckerLocationProvider checkerLocationProvider, CheckerScanPermission checkerScanPermission, @Named(value="target-sdk") int targetSdk, @Named(value="device-sdk") int deviceSdk, @Named(value="android-wear") boolean isAndroidWear) {
        this.checkerLocationProvider = checkerLocationProvider;
        this.checkerScanPermission = checkerScanPermission;
        this.targetSdk = targetSdk;
        this.deviceSdk = deviceSdk;
        this.isAndroidWear = isAndroidWear;
    }

    @Override
    public boolean isLocationPermissionOk() {
        return this.checkerScanPermission.isScanRuntimePermissionGranted();
    }

    @Override
    public boolean isLocationProviderOk() {
        return !this.isLocationProviderEnabledRequired() || this.checkerLocationProvider.isLocationProviderEnabled();
    }

    private boolean isLocationProviderEnabledRequired() {
        return !this.isAndroidWear && (this.deviceSdk >= 29 || this.targetSdk >= 23);
    }
}

