/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import android.content.Context;
import android.os.Process;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.ClientScope;
import java.util.HashSet;
import java.util.Set;

@ClientScope
public class CheckerPermission {
    private final Context context;
    private final Set<String> grantedPermissions = new HashSet<String>();

    @Inject
    CheckerPermission(Context context) {
        this.context = context;
    }

    boolean isAnyPermissionGranted(String[] acceptablePermissions) {
        for (String acceptablePermission : acceptablePermissions) {
            if (!this.isPermissionGranted(acceptablePermission)) continue;
            return true;
        }
        return false;
    }

    private boolean isPermissionGranted(String permission2) {
        boolean isGranted;
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (this.grantedPermissions.contains(permission2)) {
            return true;
        }
        boolean bl = isGranted = this.context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
        if (isGranted) {
            this.grantedPermissions.add(permission2);
        }
        return isGranted;
    }
}

