/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import androidx.annotation.IntRange;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import com.polidea.rxandroidble2.scan.ScanCallbackType;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.observables.GroupedObservable;
import java.util.concurrent.TimeUnit;

public class ScanSettingsEmulator {
    final Scheduler scheduler;
    final ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> emulateFirstMatch;
    final ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> emulateMatchLost = new ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>(){

        public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> observable) {
            return observable.debounce(10L, TimeUnit.SECONDS, ScanSettingsEmulator.this.scheduler).map(ScanSettingsEmulator.toMatchLost());
        }
    };
    private final ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> emulateFirstMatchAndMatchLost = new ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>(){

        public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> observable) {
            return observable.publish((Function)new Function<Observable<RxBleInternalScanResult>, Observable<RxBleInternalScanResult>>(){

                public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> observable) {
                    return Observable.merge((ObservableSource)observable.compose(ScanSettingsEmulator.this.emulateFirstMatch), (ObservableSource)observable.compose(ScanSettingsEmulator.this.emulateMatchLost));
                }
            });
        }
    };

    @Inject
    public ScanSettingsEmulator(final @Named(value="computation") Scheduler scheduler) {
        this.scheduler = scheduler;
        this.emulateFirstMatch = new ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>(){
            final Function<RxBleInternalScanResult, RxBleInternalScanResult> toFirstMatchFunc = ScanSettingsEmulator.toFirstMatch();
            final Observable<Long> timerObservable = Observable.timer((long)10L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)scheduler);
            final Function<RxBleInternalScanResult, Observable<?>> emitAfterTimerFunc = new Function<RxBleInternalScanResult, Observable<?>>(){

                public Observable<?> apply(RxBleInternalScanResult internalScanResult) {
                    return timerObservable;
                }
            };
            final Function<Observable<RxBleInternalScanResult>, Observable<RxBleInternalScanResult>> takeFirstFromEachWindowFunc = new Function<Observable<RxBleInternalScanResult>, Observable<RxBleInternalScanResult>>(){

                public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> rxBleInternalScanResultObservable) {
                    return rxBleInternalScanResultObservable.take(1L);
                }
            };

            public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> observable) {
                return observable.publish((Function)new Function<Observable<RxBleInternalScanResult>, ObservableSource<RxBleInternalScanResult>>(){

                    public ObservableSource<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> publishedObservable) {
                        Observable closeTenSecondsAfterMostRecentEmissionFunc = publishedObservable.switchMap(emitAfterTimerFunc);
                        return publishedObservable.window((ObservableSource)closeTenSecondsAfterMostRecentEmissionFunc).flatMap(takeFirstFromEachWindowFunc).map(toFirstMatchFunc);
                    }
                });
            }
        };
    }

    ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> emulateScanMode(int scanMode) {
        switch (scanMode) {
            case 1: {
                return this.scanModeBalancedTransformer();
            }
            case -1: {
                RxBleLog.w("Cannot emulate opportunistic scan mode since it is OS dependent - fallthrough to low power", new Object[0]);
            }
            case 0: {
                return this.scanModeLowPowerTransformer();
            }
        }
        return ObservableUtil.identityTransformer();
    }

    private ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> scanModeBalancedTransformer() {
        return this.repeatedWindowTransformer(2500);
    }

    private ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> scanModeLowPowerTransformer() {
        return this.repeatedWindowTransformer(500);
    }

    private ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> repeatedWindowTransformer(final @IntRange(from=0L, to=4999L) int windowInMillis) {
        long repeatCycleTimeInMillis = TimeUnit.SECONDS.toMillis(5L);
        final long delayToNextWindow = Math.max(repeatCycleTimeInMillis - (long)windowInMillis, 0L);
        return new ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>(){

            public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> rxBleInternalScanResultObservable) {
                return rxBleInternalScanResultObservable.take((long)windowInMillis, TimeUnit.MILLISECONDS, ScanSettingsEmulator.this.scheduler).repeatWhen(new Function<Observable<Object>, ObservableSource<?>>(){

                    public ObservableSource<?> apply(Observable<Object> observable) {
                        return observable.delay(delayToNextWindow, TimeUnit.MILLISECONDS, ScanSettingsEmulator.this.scheduler);
                    }
                });
            }
        };
    }

    ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> emulateCallbackType(int callbackType) {
        switch (callbackType) {
            case 2: {
                return ScanSettingsEmulator.splitByAddressAndForEach(this.emulateFirstMatch);
            }
            case 4: {
                return ScanSettingsEmulator.splitByAddressAndForEach(this.emulateMatchLost);
            }
            case 6: {
                return ScanSettingsEmulator.splitByAddressAndForEach(this.emulateFirstMatchAndMatchLost);
            }
        }
        return ObservableUtil.identityTransformer();
    }

    private static ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> splitByAddressAndForEach(final ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult> compose) {
        return new ObservableTransformer<RxBleInternalScanResult, RxBleInternalScanResult>(){

            public Observable<RxBleInternalScanResult> apply(Observable<RxBleInternalScanResult> observable) {
                return observable.groupBy((Function)new Function<RxBleInternalScanResult, String>(){

                    public String apply(RxBleInternalScanResult rxBleInternalScanResult) {
                        return rxBleInternalScanResult.getBluetoothDevice().getAddress();
                    }
                }).flatMap((Function)new Function<GroupedObservable<String, RxBleInternalScanResult>, Observable<RxBleInternalScanResult>>(){

                    public Observable<RxBleInternalScanResult> apply(GroupedObservable<String, RxBleInternalScanResult> groupedObservable) {
                        return groupedObservable.compose(compose);
                    }
                });
            }
        };
    }

    static Function<RxBleInternalScanResult, RxBleInternalScanResult> toFirstMatch() {
        return new Function<RxBleInternalScanResult, RxBleInternalScanResult>(){

            public RxBleInternalScanResult apply(RxBleInternalScanResult rxBleInternalScanResult) {
                return new RxBleInternalScanResult(rxBleInternalScanResult.getBluetoothDevice(), rxBleInternalScanResult.getRssi(), rxBleInternalScanResult.getTimestampNanos(), rxBleInternalScanResult.getScanRecord(), ScanCallbackType.CALLBACK_TYPE_FIRST_MATCH, rxBleInternalScanResult.isConnectable());
            }
        };
    }

    static Function<RxBleInternalScanResult, RxBleInternalScanResult> toMatchLost() {
        return new Function<RxBleInternalScanResult, RxBleInternalScanResult>(){

            public RxBleInternalScanResult apply(RxBleInternalScanResult rxBleInternalScanResult) {
                return new RxBleInternalScanResult(rxBleInternalScanResult.getBluetoothDevice(), rxBleInternalScanResult.getRssi(), rxBleInternalScanResult.getTimestampNanos(), rxBleInternalScanResult.getScanRecord(), ScanCallbackType.CALLBACK_TYPE_MATCH_LOST, rxBleInternalScanResult.isConnectable());
            }
        };
    }
}

