/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifier;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifierApi18;
import io.reactivex.Scheduler;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ScanPreconditionsVerifierApi24
implements ScanPreconditionsVerifier {
    private static final int SCANS_LENGTH = 5;
    private static final long EXCESSIVE_SCANNING_PERIOD = TimeUnit.SECONDS.toMillis(30L);
    private final long[] previousChecks = new long[5];
    private final ScanPreconditionsVerifierApi18 scanPreconditionVerifierApi18;
    private final Scheduler timeScheduler;

    @Inject
    public ScanPreconditionsVerifierApi24(ScanPreconditionsVerifierApi18 scanPreconditionVerifierApi18, @Named(value="computation") Scheduler timeScheduler) {
        this.scanPreconditionVerifierApi18 = scanPreconditionVerifierApi18;
        this.timeScheduler = timeScheduler;
    }

    @Override
    public void verify(boolean checkLocationProviderState) {
        this.scanPreconditionVerifierApi18.verify(checkLocationProviderState);
        int oldestCheckTimestampIndex = this.getOldestCheckTimestampIndex();
        long oldestCheckTimestamp = this.previousChecks[oldestCheckTimestampIndex];
        long currentCheckTimestamp = this.timeScheduler.now(TimeUnit.MILLISECONDS);
        if (currentCheckTimestamp - oldestCheckTimestamp < EXCESSIVE_SCANNING_PERIOD) {
            throw new BleScanException(0x7FFFFFFE, new Date(oldestCheckTimestamp + EXCESSIVE_SCANNING_PERIOD));
        }
        this.previousChecks[oldestCheckTimestampIndex] = currentCheckTimestamp;
    }

    private int getOldestCheckTimestampIndex() {
        long oldestTimestamp = Long.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < 5; ++i) {
            long previousCheckTimestamp = this.previousChecks[i];
            if (previousCheckTimestamp >= oldestTimestamp) continue;
            index = i;
            oldestTimestamp = previousCheckTimestamp;
        }
        return index;
    }
}

