/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import android.annotation.SuppressLint;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AndroidScanObjectsConverter {
    private final int deviceSdk;

    @Inject
    public AndroidScanObjectsConverter(@Named(value="device-sdk") int deviceSdk) {
        this.deviceSdk = deviceSdk;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=21)
    public ScanSettings toNativeSettings(com.polidea.rxandroidble2.scan.ScanSettings scanSettings) {
        ScanSettings.Builder builder = new ScanSettings.Builder();
        if (this.deviceSdk >= 23) {
            AndroidScanObjectsConverter.setMarshmallowSettings(scanSettings, builder);
            if (this.deviceSdk >= 26) {
                builder.setLegacy(scanSettings.getLegacy());
            }
        }
        return builder.setReportDelay(scanSettings.getReportDelayMillis()).setScanMode(scanSettings.getScanMode()).build();
    }

    @RequiresApi(value=23)
    private static void setMarshmallowSettings(com.polidea.rxandroidble2.scan.ScanSettings scanSettings, ScanSettings.Builder builder) {
        builder.setCallbackType(scanSettings.getCallbackType()).setMatchMode(scanSettings.getMatchMode()).setNumOfMatches(scanSettings.getNumOfMatches());
    }

    @Nullable
    @RequiresApi(value=21)
    public List<ScanFilter> toNativeFilters(com.polidea.rxandroidble2.scan.ScanFilter ... scanFilters) {
        ArrayList<ScanFilter> returnList;
        boolean isFilteringDefined;
        boolean bl = isFilteringDefined = scanFilters != null && scanFilters.length > 0;
        if (isFilteringDefined) {
            returnList = new ArrayList<ScanFilter>(scanFilters.length);
            for (com.polidea.rxandroidble2.scan.ScanFilter scanFilter : scanFilters) {
                returnList.add(AndroidScanObjectsConverter.toNative(scanFilter));
            }
        } else {
            returnList = null;
        }
        return returnList;
    }

    @RequiresApi(value=21)
    private static ScanFilter toNative(com.polidea.rxandroidble2.scan.ScanFilter scanFilter) {
        ScanFilter.Builder builder = new ScanFilter.Builder();
        if (scanFilter.getServiceDataUuid() != null) {
            builder.setServiceData(scanFilter.getServiceDataUuid(), scanFilter.getServiceData(), scanFilter.getServiceDataMask());
        }
        if (scanFilter.getDeviceAddress() != null) {
            builder.setDeviceAddress(scanFilter.getDeviceAddress());
        }
        return builder.setDeviceName(scanFilter.getDeviceName()).setManufacturerData(scanFilter.getManufacturerId(), scanFilter.getManufacturerData(), scanFilter.getManufacturerDataMask()).setServiceUuid(scanFilter.getServiceUuid(), scanFilter.getServiceUuidMask()).build();
    }
}

