/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.os.DeadObjectException;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.exceptions.BleGattCallbackTimeoutException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.QueueOperation;
import com.polidea.rxandroidble2.internal.connection.BluetoothGattProvider;
import com.polidea.rxandroidble2.internal.connection.ConnectionStateChangeListener;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import com.polidea.rxandroidble2.internal.util.BleConnectionCompat;
import com.polidea.rxandroidble2.internal.util.DisposableUtil;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Predicate;
import io.reactivex.observers.DisposableSingleObserver;
import java.util.concurrent.Callable;

public class ConnectOperation
extends QueueOperation<BluetoothGatt> {
    final BluetoothDevice bluetoothDevice;
    final BleConnectionCompat connectionCompat;
    final RxBleGattCallback rxBleGattCallback;
    final BluetoothGattProvider bluetoothGattProvider;
    final TimeoutConfiguration connectTimeout;
    final boolean autoConnect;
    final ConnectionStateChangeListener connectionStateChangedAction;

    @Inject
    ConnectOperation(BluetoothDevice bluetoothDevice, BleConnectionCompat connectionCompat, RxBleGattCallback rxBleGattCallback, BluetoothGattProvider bluetoothGattProvider, @Named(value="connect-timeout") TimeoutConfiguration connectTimeout, @Named(value="autoConnect") boolean autoConnect, ConnectionStateChangeListener connectionStateChangedAction) {
        this.bluetoothDevice = bluetoothDevice;
        this.connectionCompat = connectionCompat;
        this.rxBleGattCallback = rxBleGattCallback;
        this.bluetoothGattProvider = bluetoothGattProvider;
        this.connectTimeout = connectTimeout;
        this.autoConnect = autoConnect;
        this.connectionStateChangedAction = connectionStateChangedAction;
    }

    @Override
    protected void protectedRun(ObservableEmitter<BluetoothGatt> emitter, final QueueReleaseInterface queueReleaseInterface) {
        Action queueReleaseAction = new Action(){

            public void run() {
                queueReleaseInterface.release();
            }
        };
        DisposableSingleObserver disposableGattObserver = (DisposableSingleObserver)this.getConnectedBluetoothGatt().compose(this.wrapWithTimeoutWhenNotAutoconnecting()).doFinally(queueReleaseAction).subscribeWith(DisposableUtil.disposableSingleObserverFromEmitter(emitter));
        emitter.setDisposable((Disposable)disposableGattObserver);
        if (this.autoConnect) {
            queueReleaseInterface.release();
        }
    }

    private SingleTransformer<BluetoothGatt, BluetoothGatt> wrapWithTimeoutWhenNotAutoconnecting() {
        return new SingleTransformer<BluetoothGatt, BluetoothGatt>(){

            public Single<BluetoothGatt> apply(Single<BluetoothGatt> bluetoothGattSingle) {
                return ConnectOperation.this.autoConnect ? bluetoothGattSingle : bluetoothGattSingle.timeout(ConnectOperation.this.connectTimeout.timeout, ConnectOperation.this.connectTimeout.timeoutTimeUnit, ConnectOperation.this.connectTimeout.timeoutScheduler, ConnectOperation.this.prepareConnectionTimeoutError());
            }
        };
    }

    @NonNull
    Single<BluetoothGatt> prepareConnectionTimeoutError() {
        return Single.fromCallable((Callable)new Callable<BluetoothGatt>(){

            @Override
            public BluetoothGatt call() {
                throw new BleGattCallbackTimeoutException(ConnectOperation.this.bluetoothGattProvider.getBluetoothGatt(), BleGattOperationType.CONNECTION_STATE);
            }
        });
    }

    @NonNull
    private Single<BluetoothGatt> getConnectedBluetoothGatt() {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<BluetoothGatt>(){

            public void subscribe(SingleEmitter<BluetoothGatt> emitter) {
                DisposableSingleObserver disposableGattObserver = (DisposableSingleObserver)ConnectOperation.this.getBluetoothGattAndChangeStatusToConnected().delaySubscription((ObservableSource)ConnectOperation.this.rxBleGattCallback.getOnConnectionStateChange().filter((Predicate)new Predicate<RxBleConnection.RxBleConnectionState>(){

                    public boolean test(RxBleConnection.RxBleConnectionState rxBleConnectionState) {
                        return rxBleConnectionState == RxBleConnection.RxBleConnectionState.CONNECTED;
                    }
                })).mergeWith((SingleSource)ConnectOperation.this.rxBleGattCallback.observeDisconnect().firstOrError()).firstOrError().subscribeWith(DisposableUtil.disposableSingleObserverFromEmitter(emitter));
                emitter.setDisposable((Disposable)disposableGattObserver);
                ConnectOperation.this.connectionStateChangedAction.onConnectionStateChange(RxBleConnection.RxBleConnectionState.CONNECTING);
                BluetoothGatt bluetoothGatt = ConnectOperation.this.connectionCompat.connectGatt(ConnectOperation.this.bluetoothDevice, ConnectOperation.this.autoConnect, ConnectOperation.this.rxBleGattCallback.getBluetoothGattCallback());
                ConnectOperation.this.bluetoothGattProvider.updateBluetoothGatt(bluetoothGatt);
            }
        });
    }

    Single<BluetoothGatt> getBluetoothGattAndChangeStatusToConnected() {
        return Single.fromCallable((Callable)new Callable<BluetoothGatt>(){

            @Override
            public BluetoothGatt call() {
                ConnectOperation.this.connectionStateChangedAction.onConnectionStateChange(RxBleConnection.RxBleConnectionState.CONNECTED);
                return ConnectOperation.this.bluetoothGattProvider.getBluetoothGatt();
            }
        });
    }

    @Override
    protected BleException provideException(DeadObjectException deadObjectException) {
        return new BleDisconnectedException(deadObjectException, this.bluetoothDevice.getAddress(), -1);
    }

    public String toString() {
        return "ConnectOperation{" + LoggerUtil.commonMacMessage(this.bluetoothDevice.getAddress()) + ", autoConnect=" + this.autoConnect + '}';
    }
}

