/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.DeadObjectException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import bleshadow.javax.inject.Provider;
import com.polidea.rxandroidble2.ConnectionParameters;
import com.polidea.rxandroidble2.NotificationSetupMode;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.RxBleCustomOperation;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.internal.Priority;
import com.polidea.rxandroidble2.internal.QueueOperation;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.DescriptorWriter;
import com.polidea.rxandroidble2.internal.connection.IllegalOperationChecker;
import com.polidea.rxandroidble2.internal.connection.MtuProvider;
import com.polidea.rxandroidble2.internal.connection.NotificationAndIndicationManager;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.connection.ServiceDiscoveryManager;
import com.polidea.rxandroidble2.internal.operations.OperationsProvider;
import com.polidea.rxandroidble2.internal.serialization.ConnectionOperationQueue;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import com.polidea.rxandroidble2.internal.util.ByteAssociation;
import com.polidea.rxandroidble2.internal.util.QueueReleasingEmitterWrapper;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@ConnectionScope
public class RxBleConnectionImpl
implements RxBleConnection {
    private final ConnectionOperationQueue operationQueue;
    final RxBleGattCallback gattCallback;
    final BluetoothGatt bluetoothGatt;
    private final OperationsProvider operationsProvider;
    private final Provider<RxBleConnection.LongWriteOperationBuilder> longWriteOperationBuilderProvider;
    final Scheduler callbackScheduler;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final NotificationAndIndicationManager notificationIndicationManager;
    private final MtuProvider mtuProvider;
    private final DescriptorWriter descriptorWriter;
    private final IllegalOperationChecker illegalOperationChecker;

    @Inject
    public RxBleConnectionImpl(ConnectionOperationQueue operationQueue, RxBleGattCallback gattCallback, BluetoothGatt bluetoothGatt, ServiceDiscoveryManager serviceDiscoveryManager, NotificationAndIndicationManager notificationIndicationManager, MtuProvider mtuProvider, DescriptorWriter descriptorWriter, OperationsProvider operationProvider, Provider<RxBleConnection.LongWriteOperationBuilder> longWriteOperationBuilderProvider, @Named(value="bluetooth_interaction") Scheduler callbackScheduler, IllegalOperationChecker illegalOperationChecker) {
        this.operationQueue = operationQueue;
        this.gattCallback = gattCallback;
        this.bluetoothGatt = bluetoothGatt;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.notificationIndicationManager = notificationIndicationManager;
        this.mtuProvider = mtuProvider;
        this.descriptorWriter = descriptorWriter;
        this.operationsProvider = operationProvider;
        this.longWriteOperationBuilderProvider = longWriteOperationBuilderProvider;
        this.callbackScheduler = callbackScheduler;
        this.illegalOperationChecker = illegalOperationChecker;
    }

    @Override
    public RxBleConnection.LongWriteOperationBuilder createNewLongWriteBuilder() {
        return (RxBleConnection.LongWriteOperationBuilder)this.longWriteOperationBuilderProvider.get();
    }

    @Override
    @RequiresApi(value=21)
    public Completable requestConnectionPriority(int connectionPriority, long delay, @NonNull TimeUnit timeUnit) {
        if (connectionPriority != 2 && connectionPriority != 0 && connectionPriority != 1) {
            return Completable.error((Throwable)new IllegalArgumentException("Connection priority must have valid value from BluetoothGatt (received " + connectionPriority + ")"));
        }
        if (delay <= 0L) {
            return Completable.error((Throwable)new IllegalArgumentException("Delay must be bigger than 0"));
        }
        return this.operationQueue.queue(this.operationsProvider.provideConnectionPriorityChangeOperation(connectionPriority, delay, timeUnit)).ignoreElements();
    }

    @Override
    @RequiresApi(value=21)
    public Single<Integer> requestMtu(int mtu) {
        return this.operationQueue.queue(this.operationsProvider.provideMtuChangeOperation(mtu)).firstOrError();
    }

    @Override
    public int getMtu() {
        return this.mtuProvider.getMtu();
    }

    @Override
    public Single<RxBleDeviceServices> discoverServices() {
        return this.serviceDiscoveryManager.getDiscoverServicesSingle(20L, TimeUnit.SECONDS);
    }

    @Override
    public Single<RxBleDeviceServices> discoverServices(long timeout, @NonNull TimeUnit timeUnit) {
        return this.serviceDiscoveryManager.getDiscoverServicesSingle(timeout, timeUnit);
    }

    @Override
    @Deprecated
    public Single<BluetoothGattCharacteristic> getCharacteristic(final @NonNull UUID characteristicUuid) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, Single<? extends BluetoothGattCharacteristic>>(){

            public Single<? extends BluetoothGattCharacteristic> apply(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getCharacteristic(characteristicUuid);
            }
        });
    }

    @Override
    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID characteristicUuid) {
        return this.setupNotification(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    @Override
    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupNotification(characteristic, NotificationSetupMode.DEFAULT);
    }

    @Override
    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        return this.getCharacteristic(characteristicUuid).flatMapObservable((Function)new Function<BluetoothGattCharacteristic, ObservableSource<? extends Observable<byte[]>>>(){

            public Observable<? extends Observable<byte[]>> apply(BluetoothGattCharacteristic characteristic) {
                return RxBleConnectionImpl.this.setupNotification(characteristic, setupMode);
            }
        });
    }

    @Override
    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.illegalOperationChecker.checkAnyPropertyMatches(characteristic, 16).andThen(this.notificationIndicationManager.setupServerInitiatedCharacteristicRead(characteristic, setupMode, false));
    }

    @Override
    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID characteristicUuid) {
        return this.setupIndication(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    @Override
    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupIndication(characteristic, NotificationSetupMode.DEFAULT);
    }

    @Override
    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        return this.getCharacteristic(characteristicUuid).flatMapObservable((Function)new Function<BluetoothGattCharacteristic, ObservableSource<? extends Observable<byte[]>>>(){

            public Observable<? extends Observable<byte[]>> apply(BluetoothGattCharacteristic characteristic) {
                return RxBleConnectionImpl.this.setupIndication(characteristic, setupMode);
            }
        });
    }

    @Override
    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.illegalOperationChecker.checkAnyPropertyMatches(characteristic, 32).andThen(this.notificationIndicationManager.setupServerInitiatedCharacteristicRead(characteristic, setupMode, true));
    }

    @Override
    public Single<byte[]> readCharacteristic(@NonNull UUID characteristicUuid) {
        return this.getCharacteristic(characteristicUuid).flatMap((Function)new Function<BluetoothGattCharacteristic, SingleSource<? extends byte[]>>(){

            public SingleSource<? extends byte[]> apply(BluetoothGattCharacteristic characteristic) {
                return RxBleConnectionImpl.this.readCharacteristic(characteristic);
            }
        });
    }

    @Override
    public Single<byte[]> readCharacteristic(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.illegalOperationChecker.checkAnyPropertyMatches(characteristic, 2).andThen(this.operationQueue.queue(this.operationsProvider.provideReadCharacteristic(characteristic))).firstOrError();
    }

    @Override
    public Single<byte[]> writeCharacteristic(@NonNull UUID characteristicUuid, final @NonNull byte[] data) {
        return this.getCharacteristic(characteristicUuid).flatMap((Function)new Function<BluetoothGattCharacteristic, SingleSource<? extends byte[]>>(){

            public SingleSource<? extends byte[]> apply(BluetoothGattCharacteristic characteristic) {
                return RxBleConnectionImpl.this.writeCharacteristic(characteristic, data);
            }
        });
    }

    @Override
    public Single<byte[]> writeCharacteristic(@NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] data) {
        return this.illegalOperationChecker.checkAnyPropertyMatches(characteristic, 76).andThen(this.operationQueue.queue(this.operationsProvider.provideWriteCharacteristic(characteristic, data))).firstOrError();
    }

    @Override
    public Single<byte[]> readDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<BluetoothGattDescriptor>>(){

            public SingleSource<BluetoothGattDescriptor> apply(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).flatMap((Function)new Function<BluetoothGattDescriptor, SingleSource<byte[]>>(){

            public SingleSource<byte[]> apply(BluetoothGattDescriptor descriptor) {
                return RxBleConnectionImpl.this.readDescriptor(descriptor);
            }
        });
    }

    @Override
    public Single<byte[]> readDescriptor(@NonNull BluetoothGattDescriptor descriptor) {
        return this.operationQueue.queue(this.operationsProvider.provideReadDescriptor(descriptor)).firstOrError().map((Function)new Function<ByteAssociation<BluetoothGattDescriptor>, byte[]>(){

            public byte[] apply(ByteAssociation<BluetoothGattDescriptor> bluetoothGattDescriptorPair) {
                return bluetoothGattDescriptorPair.second;
            }
        });
    }

    @Override
    public Completable writeDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid, final @NonNull byte[] data) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<BluetoothGattDescriptor>>(){

            public SingleSource<BluetoothGattDescriptor> apply(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).flatMapCompletable((Function)new Function<BluetoothGattDescriptor, CompletableSource>(){

            public CompletableSource apply(BluetoothGattDescriptor bluetoothGattDescriptor) {
                return RxBleConnectionImpl.this.writeDescriptor(bluetoothGattDescriptor, data);
            }
        });
    }

    @Override
    public Completable writeDescriptor(@NonNull BluetoothGattDescriptor bluetoothGattDescriptor, @NonNull byte[] data) {
        return this.descriptorWriter.writeDescriptor(bluetoothGattDescriptor, data);
    }

    @Override
    public Single<Integer> readRssi() {
        return this.operationQueue.queue(this.operationsProvider.provideRssiReadOperation()).firstOrError();
    }

    @Override
    public Observable<ConnectionParameters> observeConnectionParametersUpdates() {
        return this.gattCallback.getConnectionParametersUpdates();
    }

    @Override
    public <T> Observable<T> queue(@NonNull RxBleCustomOperation<T> operation) {
        return this.queue(operation, Priority.NORMAL);
    }

    @Override
    public <T> Observable<T> queue(final @NonNull RxBleCustomOperation<T> operation, final @NonNull Priority priority) {
        return this.operationQueue.queue(new QueueOperation<T>(){

            @Override
            protected void protectedRun(ObservableEmitter<T> emitter, QueueReleaseInterface queueReleaseInterface) throws Throwable {
                Observable operationObservable;
                try {
                    operationObservable = operation.asObservable(RxBleConnectionImpl.this.bluetoothGatt, RxBleConnectionImpl.this.gattCallback, RxBleConnectionImpl.this.callbackScheduler);
                }
                catch (Throwable throwable) {
                    queueReleaseInterface.release();
                    throw throwable;
                }
                if (operationObservable == null) {
                    queueReleaseInterface.release();
                    throw new IllegalArgumentException("The custom operation asObservable method must return a non-null observable");
                }
                QueueReleasingEmitterWrapper emitterWrapper = new QueueReleasingEmitterWrapper(emitter, queueReleaseInterface);
                operationObservable.doOnTerminate(this.clearNativeCallbackReferenceAction()).subscribe(emitterWrapper);
            }

            private Action clearNativeCallbackReferenceAction() {
                return new Action(){

                    public void run() {
                        RxBleConnectionImpl.this.gattCallback.setNativeCallback(null);
                        RxBleConnectionImpl.this.gattCallback.setHiddenNativeCallback(null);
                    }
                };
            }

            @Override
            protected BleException provideException(DeadObjectException deadObjectException) {
                return new BleDisconnectedException(deadObjectException, RxBleConnectionImpl.this.bluetoothGatt.getDevice().getAddress(), -1);
            }

            @Override
            public Priority definedPriority() {
                return priority;
            }
        });
    }
}

