/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.internal.DeviceComponent;
import com.polidea.rxandroidble2.internal.cache.CacheEntry;
import com.polidea.rxandroidble2.internal.cache.DeviceComponentWeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@ClientScope
public class DeviceComponentCache
implements Map<String, DeviceComponent> {
    private final HashMap<String, DeviceComponentWeakReference> cache = new HashMap();
    private final DeviceComponentWeakReference.Provider deviceComponentReferenceProvider;

    @Inject
    public DeviceComponentCache() {
        this(new DeviceComponentWeakReference.Provider(){

            @Override
            public DeviceComponentWeakReference provide(DeviceComponent device) {
                return new DeviceComponentWeakReference(device);
            }
        });
    }

    DeviceComponentCache(DeviceComponentWeakReference.Provider provider) {
        this.deviceComponentReferenceProvider = provider;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key) && this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Collection<DeviceComponentWeakReference> values = this.cache.values();
        for (DeviceComponentWeakReference weakReference : values) {
            if (!weakReference.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, DeviceComponent>> entrySet() {
        HashSet<Map.Entry<String, DeviceComponent>> components = new HashSet<Map.Entry<String, DeviceComponent>>();
        for (Map.Entry<String, DeviceComponentWeakReference> entry : this.cache.entrySet()) {
            DeviceComponentWeakReference entryValue = entry.getValue();
            if (entryValue.isEmpty()) continue;
            components.add(new CacheEntry(entry.getKey(), this.deviceComponentReferenceProvider.provide((DeviceComponent)entryValue.get())));
        }
        return components;
    }

    @Override
    @Nullable
    public DeviceComponent get(Object key) {
        DeviceComponentWeakReference deviceComponentWeakReference = this.cache.get(key);
        return deviceComponentWeakReference != null ? (DeviceComponent)deviceComponentWeakReference.get() : null;
    }

    @Override
    public boolean isEmpty() {
        this.evictEmptyReferences();
        return this.cache.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.cache.keySet();
    }

    @Override
    public DeviceComponent put(String key, DeviceComponent value) {
        this.cache.put(key, this.deviceComponentReferenceProvider.provide(value));
        this.evictEmptyReferences();
        return value;
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends DeviceComponent> map) {
        for (Map.Entry<? extends String, ? extends DeviceComponent> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public DeviceComponent remove(Object key) {
        DeviceComponentWeakReference deviceComponentWeakReference = this.cache.remove(key);
        this.evictEmptyReferences();
        return deviceComponentWeakReference != null ? (DeviceComponent)deviceComponentWeakReference.get() : null;
    }

    @Override
    public int size() {
        this.evictEmptyReferences();
        return this.cache.size();
    }

    @Override
    @NonNull
    public Collection<DeviceComponent> values() {
        ArrayList<DeviceComponent> components = new ArrayList<DeviceComponent>();
        for (DeviceComponentWeakReference deviceComponentWeakReference : this.cache.values()) {
            if (deviceComponentWeakReference.isEmpty()) continue;
            components.add((DeviceComponent)deviceComponentWeakReference.get());
        }
        return components;
    }

    private void evictEmptyReferences() {
        Iterator<Map.Entry<String, DeviceComponentWeakReference>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DeviceComponentWeakReference> next = iterator.next();
            if (!next.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }
}

