/*
 * Decompiled with CFR 0.152.
 */
package org.monte.movieconverter;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.monte.media.DefaultMovie;
import org.monte.media.Movie;
import org.monte.media.MovieReader;
import org.monte.media.Registry;
import org.monte.media.gui.Worker;
import org.monte.media.gui.datatransfer.DropFileTransferHandler;
import org.monte.movieconverter.MovieConverterPanel;

public class MovieConverterXMain
extends JFrame {
    private Handler handler = new Handler();
    private MovieConverterPanel movieConverterPanel;

    public MovieConverterXMain() {
        this.initComponents();
        DropFileTransferHandler dfth = new DropFileTransferHandler(0);
        dfth.setActionListener(this.handler);
        this.setTransferHandler(dfth);
        this.movieConverterPanel.setTransferHandler(dfth);
    }

    public void setMovieFile(final File newFile) {
        this.setEnabled(false);
        this.setTitle(null);
        this.getRootPane().putClientProperty("Window.documentFile", null);
        new Worker<Movie>(){

            @Override
            protected Movie construct() throws Exception {
                MovieReader r = Registry.getInstance().getReader(newFile);
                if (r == null) {
                    throw new IOException("no reader");
                }
                DefaultMovie m = new DefaultMovie();
                m.setReader(r);
                return m;
            }

            @Override
            protected void done(Movie movie) {
                MovieConverterXMain.this.getRootPane().putClientProperty("Window.documentFile", newFile);
                MovieConverterXMain.this.setTitle(newFile.getName());
                MovieConverterXMain.this.movieConverterPanel.setMovie(movie);
            }

            @Override
            protected void finished() {
                MovieConverterXMain.this.setEnabled(true);
            }
        }.start();
    }

    private void initComponents() {
        this.movieConverterPanel = new MovieConverterPanel();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.movieConverterPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MovieConverterXMain().setVisible(true);
            }
        });
    }

    private class Handler
    implements ActionListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = new File(e.getActionCommand());
            if (MovieConverterXMain.this.isEnabled()) {
                MovieConverterXMain.this.setMovieFile(f);
            }
        }
    }
}

