/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.pbm;

import java.awt.Component;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.monte.media.AbstractPlayer;
import org.monte.media.ColorCyclePlayer;
import org.monte.media.MovieControl;
import org.monte.media.gui.ImagePanel;
import org.monte.media.gui.JMovieControlAqua;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.io.BoundedRangeInputStream;
import org.monte.media.pbm.PBMDecoder;

public class PBMPlayer
extends AbstractPlayer
implements ColorCyclePlayer {
    private ColorCyclingMemoryImageSource memoryImage;
    private BoundedRangeModel timeModel;
    private BoundedRangeInputStream cachingControlModel;
    private InputStream in;
    private int inputFileSize = -1;
    private ImagePanel visualComponent;
    private MovieControl controlComponent;
    private volatile boolean isCached = false;

    public PBMPlayer(InputStream in) {
        this(in, -1);
    }

    public PBMPlayer(InputStream in, int inputFileSize) {
        this.in = in;
        this.inputFileSize = inputFileSize;
        this.timeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    }

    @Override
    protected void doClosed() {
    }

    @Override
    protected void doUnrealized() {
    }

    @Override
    protected void doRealizing() {
        this.cachingControlModel = new BoundedRangeInputStream(this.in);
        if (this.inputFileSize != -1) {
            this.cachingControlModel.setMaximum(this.inputFileSize);
        }
        try {
            PBMDecoder decoder = new PBMDecoder(this.cachingControlModel);
            ArrayList<ColorCyclingMemoryImageSource> track = decoder.produce();
            this.isCached = true;
            this.cachingControlModel.setValue(this.cachingControlModel.getMaximum());
            this.propertyChangeSupport.firePropertyChange("cached", Boolean.FALSE, Boolean.TRUE);
            if (track.size() == 0) {
                this.setTargetState(-1);
            } else {
                this.memoryImage = track.get(0);
                this.memoryImage.setAnimated(true);
                if (this.memoryImage.isColorCyclingAvailable()) {
                    this.propertyChangeSupport.firePropertyChange("colorCyclingAvailable", false, true);
                }
            }
            this.timeModel.setRangeProperties(0, 1, 0, 1, false);
        }
        catch (Throwable e) {
            if (this.visualComponent != null) {
                this.visualComponent.setMessage(e.toString());
            }
            this.setTargetState(-1);
            e.printStackTrace();
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException decoder) {}
        }
    }

    @Override
    protected void doRealized() {
        this.getVisualComponent();
        if (this.getImageProducer() != null) {
            this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
        }
    }

    @Override
    protected void doPrefetching() {
    }

    @Override
    protected void doPrefetched() {
    }

    @Override
    protected void doStarted() {
    }

    @Override
    public void setAudioEnabled(boolean b) {
    }

    @Override
    public boolean isAudioEnabled() {
        return false;
    }

    @Override
    public boolean isAudioAvailable() {
        return false;
    }

    @Override
    public BoundedRangeModel getTimeModel() {
        return this.timeModel;
    }

    @Override
    public BoundedRangeModel getCachingModel() {
        return this.cachingControlModel;
    }

    @Override
    public synchronized Component getVisualComponent() {
        if (this.visualComponent == null) {
            this.visualComponent = new ImagePanel();
            if (this.getImageProducer() != null) {
                this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
            }
        }
        return this.visualComponent;
    }

    @Override
    public Component getControlPanelComponent() {
        if (this.controlComponent == null) {
            this.controlComponent = new JMovieControlAqua();
            this.controlComponent.setPlayer(this);
        }
        return this.controlComponent.getComponent();
    }

    @Override
    public long getTotalDuration() {
        return 0L;
    }

    protected ImageProducer getImageProducer() {
        return this.memoryImage;
    }

    @Override
    public void setColorCyclingStarted(boolean newValue) {
        if (this.memoryImage != null) {
            boolean oldValue = this.memoryImage.isColorCyclingStarted();
            this.memoryImage.setColorCyclingStarted(newValue);
            this.propertyChangeSupport.firePropertyChange("colorCyclingStarted", oldValue, newValue);
        }
    }

    @Override
    public boolean isColorCyclingAvailable() {
        return this.memoryImage == null ? false : this.memoryImage.isColorCyclingAvailable();
    }

    @Override
    public boolean isColorCyclingStarted() {
        return this.memoryImage == null ? false : this.memoryImage.isColorCyclingStarted();
    }

    @Override
    public boolean isCached() {
        return this.isCached;
    }

    @Override
    public void setBlendedColorCycling(boolean newValue) {
        if (this.memoryImage != null) {
            boolean oldValue = this.memoryImage.isBlendedColorCycling();
            this.memoryImage.setBlendedColorCycling(newValue);
            this.propertyChangeSupport.firePropertyChange("blendedColorCycling", oldValue, newValue);
        }
    }

    @Override
    public boolean isBlendedColorCycling() {
        return this.memoryImage == null ? false : this.memoryImage.isBlendedColorCycling();
    }
}

