/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class StreamPosTokenizer {
    private Reader reader = null;
    private int readpos = 0;
    private int startpos = -1;
    private int endpos = -1;
    private Vector<Integer> unread = new Vector();
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private boolean pushedBack;
    private boolean forceLower;
    private int lineno = 1;
    private boolean eolIsSignificantP = false;
    private boolean slashSlashCommentsP = false;
    private boolean slashStarCommentsP = false;
    private char[] slashSlash = new char[]{'/', '/'};
    private char[] slashStar = new char[]{'/', '*'};
    private char[] starSlash = new char[]{'*', '/'};
    private byte[] ctype = new byte[256];
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    private boolean isParseHexNumbers = false;
    private boolean isParseExponents = false;
    public int ttype = -4;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_NOTHING = -4;
    public String sval;
    public double nval;

    public StreamPosTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    public StreamPosTokenizer(Reader r) {
        this();
        if (r == null) {
            throw new NullPointerException();
        }
        this.reader = r;
    }

    public void setReader(Reader r) {
        this.reader = r;
        this.readpos = 0;
        this.unread.clear();
        this.peekc = Integer.MAX_VALUE;
        this.pushedBack = false;
        this.forceLower = false;
        this.lineno = 0;
        this.endpos = -1;
        this.startpos = -1;
        this.ttype = -4;
    }

    public void resetSyntax() {
        int i = this.ctype.length;
        while (--i >= 0) {
            this.ctype[i] = 0;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | 4);
        }
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 0;
        }
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 16;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    public void parsePlusAsNumber() {
        this.ctype[43] = (byte)(this.ctype[43] | 2);
    }

    public void parseHexNumbers() {
        this.parseNumbers();
        this.isParseHexNumbers = true;
    }

    public void parseExponents() {
        this.parseNumbers();
        this.isParseExponents = true;
    }

    public void eolIsSignificant(boolean flag) {
        this.eolIsSignificantP = flag;
    }

    public void slashStarComments(boolean flag) {
        this.slashStarCommentsP = flag;
    }

    public void slashSlashComments(boolean flag) {
        this.slashSlashCommentsP = flag;
    }

    public void lowerCaseMode(boolean fl) {
        this.forceLower = fl;
    }

    private int read() throws IOException {
        int data;
        if (this.unread.size() > 0) {
            data = this.unread.lastElement();
            this.unread.removeElementAt(this.unread.size() - 1);
        } else {
            data = this.reader.read();
        }
        if (data != -1) {
            ++this.readpos;
        }
        return data;
    }

    private void unread(int c) {
        this.unread.addElement(c);
        --this.readpos;
    }

    public int nextToken() throws IOException {
        int i;
        int ctype;
        int c;
        byte[] ct;
        block82: {
            boolean neg;
            int digits;
            block85: {
                block83: {
                    block84: {
                        if (this.pushedBack) {
                            this.pushedBack = false;
                            return this.ttype;
                        }
                        ct = this.ctype;
                        this.sval = null;
                        c = this.peekc;
                        if (c < 0) {
                            c = Integer.MAX_VALUE;
                        }
                        if (c == 0x7FFFFFFE) {
                            c = this.read();
                            if (c < 0) {
                                this.startpos = this.endpos = this.readpos - 1;
                                this.ttype = -1;
                                return -1;
                            }
                            if (c == 10) {
                                c = Integer.MAX_VALUE;
                            }
                        }
                        if (c == Integer.MAX_VALUE && (c = this.read()) < 0) {
                            this.startpos = this.endpos = this.readpos - 1;
                            this.ttype = -1;
                            return -1;
                        }
                        this.ttype = c;
                        this.peekc = Integer.MAX_VALUE;
                        int n = ctype = c < 256 ? ct[c] : 4;
                        while ((ctype & 1) != 0) {
                            if (c == 13) {
                                ++this.lineno;
                                if (this.eolIsSignificantP) {
                                    this.peekc = 0x7FFFFFFE;
                                    this.startpos = this.endpos = this.readpos - 1;
                                    this.ttype = 10;
                                    return 10;
                                }
                                c = this.read();
                                if (c == 10) {
                                    c = this.read();
                                }
                            } else {
                                if (c == 10) {
                                    ++this.lineno;
                                    if (this.eolIsSignificantP) {
                                        this.startpos = this.endpos = this.readpos - 1;
                                        this.ttype = 10;
                                        return 10;
                                    }
                                }
                                c = this.read();
                            }
                            if (c < 0) {
                                this.startpos = this.endpos = this.readpos;
                                this.ttype = -1;
                                return -1;
                            }
                            ctype = c < 256 ? ct[c] : 4;
                        }
                        this.startpos = this.readpos - 1;
                        if ((ctype & 2) != 0 && c == 48 && this.isParseHexNumbers) {
                            c = this.read();
                            if (c == 120) {
                                long hval = 0L;
                                for (int digits2 = 0; digits2 < 16; ++digits2) {
                                    c = this.read();
                                    if (c >= 48 && c <= 57) {
                                        hval = hval << 4 | (long)(c - 48);
                                        continue;
                                    }
                                    if (c >= 65 && c <= 70) {
                                        hval = hval << 4 | (long)(c - 65 + 10);
                                        continue;
                                    }
                                    if (c >= 97 && c <= 102) {
                                        hval = hval << 4 | (long)(c - 97 + 10);
                                        continue;
                                    }
                                    this.unread(c);
                                    if (digits2 == 0) {
                                        this.sval = "0x";
                                        this.endpos = this.readpos - 1;
                                        this.ttype = -3;
                                        return -3;
                                    }
                                    this.nval = hval;
                                    this.endpos = this.readpos - 1;
                                    this.ttype = -2;
                                    return -2;
                                }
                                this.nval = hval;
                                this.endpos = this.readpos - 1;
                                this.ttype = -2;
                                return -2;
                            }
                            this.unread(c);
                            c = 48;
                        }
                        if ((ctype & 2) == 0) break block82;
                        digits = 0;
                        neg = false;
                        if (c != 45) break block83;
                        c = this.read();
                        if (c == 46 || c >= 48 && c <= 57) break block84;
                        this.peekc = c;
                        this.unread(c);
                        c = 45;
                        break block82;
                    }
                    neg = true;
                    break block85;
                }
                if (c == 43) {
                    c = this.read();
                    if (c != 46 && (c < 48 || c > 57)) {
                        this.peekc = c;
                        this.endpos = this.readpos - 1;
                        this.ttype = 45;
                        return 45;
                    }
                    neg = false;
                }
            }
            double v = 0.0;
            int decexp = 0;
            int seendot = 0;
            while (true) {
                if (c == 46 && seendot == 0) {
                    seendot = 1;
                } else {
                    if (48 > c || c > 57) break;
                    ++digits;
                    v = v * 10.0 + (double)(c - 48);
                    decexp += seendot;
                }
                c = this.read();
            }
            this.peekc = c;
            if (decexp != 0) {
                double denom = 10.0;
                --decexp;
                while (decexp > 0) {
                    denom *= 10.0;
                    --decexp;
                }
                v /= denom;
            }
            this.nval = neg ? -v : v;
            int n = this.endpos = c == -1 ? this.readpos - 1 : this.readpos - 2;
            if (digits == 0) {
                this.unread(c);
                if (neg) {
                    this.unread(46);
                    c = 45;
                } else {
                    this.read();
                    c = 46;
                }
            } else {
                if (this.isParseExponents && (c == 69 || c == 101)) {
                    c = this.read();
                    digits = 0;
                    neg = false;
                    if (c == 45) {
                        c = this.read();
                        if (c < 48 || c > 57) {
                            this.unread(c);
                            this.unread(69);
                            this.ttype = -2;
                            return -2;
                        }
                        neg = true;
                    }
                    v = 0.0;
                    decexp = 0;
                    while (48 <= c && c <= 57) {
                        ++digits;
                        v = v * 10.0 + (double)(c - 48);
                        c = this.read();
                    }
                    this.peekc = c;
                    this.nval *= Math.pow(10.0, neg ? -v : v);
                }
                this.ttype = -2;
                return -2;
            }
        }
        if ((ctype & 4) != 0) {
            i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            } while (((ctype = (c = this.read()) < 0 ? 1 : (c < 256 ? ct[c] : 4)) & 6) != 0);
            this.peekc = c;
            this.sval = String.copyValueOf(this.buf, 0, i);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.endpos = c == -1 ? this.readpos - 1 : this.readpos - 2;
            this.ttype = -3;
            return -3;
        }
        if ((ctype & 8) != 0) {
            this.ttype = c;
            i = 0;
            int d = this.read();
            while (d >= 0 && d != this.ttype && d != 10 && d != 13) {
                if (d == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                d = this.read();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                            }
                        }
                        d = this.read();
                    }
                } else {
                    c = d;
                    d = this.read();
                }
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            }
            this.peekc = d == this.ttype ? Integer.MAX_VALUE : d;
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.endpos = this.readpos - 2;
            return this.ttype;
        }
        if (this.slashSlashCommentsP && c == this.slashSlash[0] || this.slashStarCommentsP && c == this.slashStar[0]) {
            if (c == this.slashStar[0] && this.slashStar.length == 1) {
                while ((c = this.read()) != this.starSlash[0]) {
                    if (c == 13) {
                        ++this.lineno;
                        c = this.read();
                        if (c == 10) {
                            c = this.read();
                        }
                    } else if (c == 10) {
                        ++this.lineno;
                        c = this.read();
                    }
                    if (c >= 0) continue;
                    this.endpos = this.readpos;
                    this.ttype = -1;
                    return -1;
                }
                return this.nextToken();
            }
            if (c == this.slashSlash[0] && this.slashSlash.length == 1) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            c = this.read();
            if (c == this.slashStar[1] && this.slashStarCommentsP) {
                int prevc = 0;
                while ((c = this.read()) != this.starSlash[1] || prevc != this.starSlash[0]) {
                    if (c == 13) {
                        ++this.lineno;
                        c = this.read();
                        if (c == 10) {
                            c = this.read();
                        }
                    } else if (c == 10) {
                        ++this.lineno;
                        c = this.read();
                    }
                    if (c < 0) {
                        this.endpos = this.readpos;
                        this.ttype = -1;
                        return -1;
                    }
                    prevc = c;
                }
                return this.nextToken();
            }
            if (c == this.slashSlash[1] && this.slashSlashCommentsP) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            if ((ct[this.slashSlash[0]] & 0x10) != 0) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            this.peekc = c;
            this.endpos = this.readpos - 2;
            this.ttype = this.slashSlash[0];
            return this.ttype;
        }
        if ((ctype & 0x10) != 0) {
            while ((c = this.read()) != 10 && c != 13 && c >= 0) {
            }
            this.peekc = c;
            return this.nextToken();
        }
        this.endpos = this.readpos - 1;
        this.ttype = c;
        return this.ttype;
    }

    public int nextChar() throws IOException {
        if (this.pushedBack) {
            throw new IllegalStateException("can't read char when a token has been pushed back");
        }
        if (this.peekc == Integer.MAX_VALUE) {
            return this.read();
        }
        int ch = this.peekc;
        this.peekc = Integer.MAX_VALUE;
        return ch;
    }

    public void pushCharBack(int ch) throws IOException {
        if (this.pushedBack) {
            throw new IllegalStateException("can't push back char when a token has been pushed back");
        }
        if (this.peekc == Integer.MAX_VALUE) {
            this.unread(ch);
        } else {
            this.unread(this.peekc);
            this.peekc = Integer.MAX_VALUE;
            this.unread(ch);
        }
    }

    public void setSlashStarTokens(String slashStar, String starSlash) {
        if (slashStar.length() != starSlash.length()) {
            throw new IllegalArgumentException("SlashStar and StarSlash tokens must be of same length: '" + slashStar + "' '" + starSlash + "'");
        }
        if (slashStar.length() < 1 || slashStar.length() > 2) {
            throw new IllegalArgumentException("SlashStar and StarSlash tokens must be of length 1 or 2: '" + slashStar + "' '" + starSlash + "'");
        }
        this.slashStar = slashStar.toCharArray();
        this.starSlash = starSlash.toCharArray();
        this.commentChar(this.slashStar[0]);
    }

    public void setSlashSlashToken(String slashSlash) {
        if (slashSlash.length() < 1 || slashSlash.length() > 2) {
            throw new IllegalArgumentException("SlashSlash token must be of length 1 or 2: '" + slashSlash + "'");
        }
        this.slashSlash = slashSlash.toCharArray();
        this.commentChar(this.slashSlash[0]);
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.lineno;
    }

    public int getStartPosition() {
        return this.startpos;
    }

    public void setStartPosition(int p) {
        this.startpos = p;
    }

    public int getEndPosition() {
        return this.endpos;
    }

    public void consumeGreedy(String greedyToken) {
        if (greedyToken.length() < this.sval.length()) {
            this.pushBack();
            this.setStartPosition(this.getStartPosition() + greedyToken.length());
            this.sval = this.sval.substring(greedyToken.length());
        }
    }

    public String toString() {
        String ret;
        switch (this.ttype) {
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -3: {
                ret = this.sval;
                break;
            }
            case -2: {
                ret = "n=" + this.nval;
                break;
            }
            case -4: {
                ret = "NOTHING";
                break;
            }
            default: {
                char[] s = new char[3];
                s[2] = 39;
                s[0] = 39;
                s[1] = (char)this.ttype;
                ret = new String(s);
                break;
            }
        }
        return "Token[" + ret + "], line " + this.lineno;
    }
}

