/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageOutputStream;
import org.monte.media.iff.IFFOutputStream;
import org.monte.media.image.BitmapImage;

public class ILBMEncoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f, BitmapImage img, int camg) throws IOException {
        try (IFFOutputStream out = null;){
            out = new IFFOutputStream(new FileImageOutputStream(f));
            out.pushCompositeChunk("FORM", "ILBM");
            this.writeBMHD(out, img);
            this.writeCMAP(out, img);
            this.writeCAMG(out, camg);
            this.writeBODY(out, img);
            out.popChunk();
        }
    }

    private void writeBMHD(IFFOutputStream out, BitmapImage img) throws IOException {
        out.pushDataChunk("BMHD");
        out.writeUWORD(img.getWidth());
        out.writeUWORD(img.getHeight());
        out.writeWORD(0);
        out.writeWORD(0);
        out.writeUBYTE(img.getDepth());
        out.writeUBYTE(0);
        out.writeUBYTE(1);
        out.writeUBYTE(0);
        out.writeUWORD(0);
        out.writeUBYTE(44);
        out.writeUBYTE(52);
        out.writeUWORD(img.getWidth());
        out.writeUWORD(img.getHeight());
        out.popChunk();
    }

    private void writeCMAP(IFFOutputStream out, BitmapImage img) throws IOException {
        out.pushDataChunk("CMAP");
        IndexColorModel cm = (IndexColorModel)img.getPlanarColorModel();
        int n = cm.getMapSize();
        for (int i = 0; i < n; ++i) {
            out.writeUBYTE(cm.getRed(i));
            out.writeUBYTE(cm.getGreen(i));
            out.writeUBYTE(cm.getBlue(i));
        }
        out.popChunk();
    }

    private void writeCAMG(IFFOutputStream out, int camg) throws IOException {
        out.pushDataChunk("CAMG");
        out.writeLONG(camg);
        out.popChunk();
    }

    private void writeBODY(IFFOutputStream out, BitmapImage img) throws IOException {
        out.pushDataChunk("BODY");
        int w = img.getWidth() / 8;
        int ss = img.getScanlineStride();
        int bs = img.getBitplaneStride();
        int offset = 0;
        byte[] data = img.getBitmap();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            int d = img.getDepth();
            for (int p = 0; p < d; ++p) {
                out.writeByteRun1(data, offset + bs * p, w);
            }
            offset += ss;
        }
        out.popChunk();
    }
}

