/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.monte.media.iff.MC68000InputStream;
import org.monte.media.iff.MC68000OutputStream;

public class MutableIFFChunk
extends DefaultMutableTreeNode {
    public static final int ID_FORM = 1179603533;
    public static final int ID_CAT = 1128354848;
    public static final int ID_LIST = 1279873876;
    public static final int ID_PROP = 1347571536;
    public static final int ID_FILLER = 0x20202020;
    private int type;
    private int id;
    private byte[] data;

    public MutableIFFChunk() {
    }

    public MutableIFFChunk(int id, int type) {
        this.id = id;
        this.type = type;
    }

    public MutableIFFChunk(int id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    public MutableIFFChunk(String id, String type) {
        this.id = MutableIFFChunk.stringToId(id);
        this.type = MutableIFFChunk.stringToId(type);
    }

    public MutableIFFChunk(String id, byte[] data) {
        this.id = MutableIFFChunk.stringToId(id);
        this.data = data;
    }

    public void setType(int newValue) {
        int oldValue = this.type;
        this.type = newValue;
    }

    public void setId(int newValue) {
        int oldValue = this.id;
        this.id = newValue;
    }

    public void setData(byte[] newValue) {
        byte[] oldValue = this.data;
        this.data = newValue;
    }

    public int getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        if (this.data != null) {
            return this.data.length;
        }
        int length = 4;
        for (MutableIFFChunk child : this.childChunks()) {
            int childLength = child.getLength();
            length += 8 + childLength + childLength % 2;
        }
        return length;
    }

    public Vector<MutableIFFChunk> childChunks() {
        return this.children == null ? new Vector<MutableIFFChunk>(0) : new Vector(this.children);
    }

    public String dump() {
        return this.dump(0);
    }

    public String dump(int depth) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append('.');
        }
        buf.append(MutableIFFChunk.idToString(this.getId()));
        buf.append(' ');
        buf.append(this.getLength());
        if (this.getChildCount() > 0) {
            buf.append(' ');
            buf.append(MutableIFFChunk.idToString(this.getType()));
            for (MutableIFFChunk child : this.childChunks()) {
                buf.append('\n');
                buf.append(child.dump(depth + 1));
            }
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(MutableIFFChunk.idToString(this.getId()));
        buf.append(' ');
        buf.append(this.getLength());
        if (this.data == null) {
            buf.append(' ');
            buf.append(MutableIFFChunk.idToString(this.getType()));
        }
        return buf.toString();
    }

    public static String idToString(int anID) {
        byte[] bytes = new byte[]{(byte)(anID >>> 24), (byte)(anID >>> 16), (byte)(anID >>> 8), (byte)(anID >>> 0)};
        return new String(bytes);
    }

    public static int stringToId(String aString) {
        byte[] bytes = aString.getBytes();
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] << 0;
    }

    public void read(File f) throws IOException {
        try (MC68000InputStream in = new MC68000InputStream(new BufferedInputStream(new FileInputStream(f)));){
            this.read(in);
        }
    }

    public void read(MC68000InputStream in) throws IOException {
        this.id = in.readLONG();
        long length = in.readULONG();
        switch (this.id) {
            case 1128354848: 
            case 1179603533: 
            case 1279873876: 
            case 1347571536: {
                this.type = in.readLONG();
                length -= 4L;
                while (length > 1L) {
                    MutableIFFChunk child = new MutableIFFChunk();
                    child.read(in);
                    this.add(child);
                    int childLength = child.getLength();
                    length -= (long)(childLength + childLength % 2 + 8);
                }
                break;
            }
            default: {
                this.data = new byte[(int)length];
                in.readFully(this.data, 0, (int)length);
            }
        }
        if (length % 2L == 1L) {
            in.read();
        }
    }

    public void Write(File f) throws IOException {
        try (MC68000OutputStream out = new MC68000OutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
            this.write(out);
        }
    }

    public void write(MC68000OutputStream out) throws IOException {
        out.writeULONG(this.id);
        long length = this.getLength();
        out.writeULONG(length);
        if (this.data == null) {
            out.writeULONG(this.type);
            for (MutableIFFChunk child : this.childChunks()) {
                child.write(out);
            }
        } else {
            out.write(this.data);
        }
        if (length % 2L == 1L) {
            out.write(0);
        }
    }
}

