/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.exif;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.AbortException;
import org.monte.media.ParseException;
import org.monte.media.exif.EXIFTagSet;
import org.monte.media.exif.FujifilmMakerNoteTagSet;
import org.monte.media.exif.GPSTagSet;
import org.monte.media.exif.ImageTagSet;
import org.monte.media.exif.InteroperabilityTagSet;
import org.monte.media.exif.MPEntryTagSet;
import org.monte.media.exif.MPFTagSet;
import org.monte.media.exif.SonyMakerNoteTagSet;
import org.monte.media.exif.TrackTagSet;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.jpeg.JFIFInputStream;
import org.monte.media.math.Rational;
import org.monte.media.riff.RIFFChunk;
import org.monte.media.riff.RIFFParser;
import org.monte.media.riff.RIFFVisitor;
import org.monte.media.tiff.BaselineTagSet;
import org.monte.media.tiff.FileSegment;
import org.monte.media.tiff.IFD;
import org.monte.media.tiff.IFDDataType;
import org.monte.media.tiff.IFDEntry;
import org.monte.media.tiff.TIFFDirectory;
import org.monte.media.tiff.TIFFField;
import org.monte.media.tiff.TIFFInputStream;
import org.monte.media.tiff.TIFFNode;
import org.monte.media.tiff.TIFFTag;
import org.monte.media.tiff.TagSet;

public class EXIFReader {
    private File file;
    private ImageInputStream iin;
    private boolean firstImageOnly;
    private boolean includeContainerMetadata = true;
    private TIFFNode root;
    private TreeSet<Long> imageOffsets = new TreeSet();

    public EXIFReader(File f) {
        this.file = f;
    }

    public EXIFReader(ImageInputStream iin) {
        this.iin = iin;
    }

    public void setFirstImageOnly(boolean b) {
        this.firstImageOnly = b;
    }

    public boolean isFirstImageOnly() {
        return this.firstImageOnly;
    }

    public void setIncludeContainerMetadata(boolean b) {
        this.includeContainerMetadata = b;
    }

    public boolean isIncludeContainerMetadata() {
        return this.includeContainerMetadata;
    }

    public void read() throws IOException {
        if (this.file != null) {
            this.iin = new FileImageInputStream(this.file);
        }
        try {
            this.iin.seek(0L);
            int magic = this.iin.readInt();
            this.iin.seek(0L);
            if (magic == 1229531648) {
            } else if (magic == 1296891946) {
            } else if (magic == 1380533830) {
                this.readRIFF(this.iin);
            } else {
                this.readJFIF(this.iin);
            }
        }
        finally {
            if (this.file != null) {
                this.iin.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readJFIF(ImageInputStream iin) throws IOException {
        this.root = new TIFFDirectory(null, null, -1);
        ByteArrayOutputStream exifStream = null;
        ArrayList<FileSegment> exifSeg = null;
        ByteArrayOutputStream mpStream = null;
        ArrayList<FileSegment> mpSeg = null;
        byte[] buf = new byte[512];
        JFIFInputStream in = new JFIFInputStream(new BufferedInputStream(new ImageInputStreamAdapter(iin)));
        int imageCount = 0;
        TIFFDirectory imageNode = null;
        JFIFInputStream.Segment seg = in.getNextSegment();
        while (seg != null) {
            switch (seg.marker) {
                case 65472: 
                case 65473: 
                case 65474: 
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: 
                case 65481: 
                case 65482: 
                case 65483: 
                case 65485: 
                case 65486: 
                case 65487: {
                    if (!this.includeContainerMetadata || imageNode == null) break;
                    int samplePrecision = in.read() & 0xFF;
                    int numberOfLines = (in.read() & 0xFF) << 8 | in.read();
                    int samplesPerLine = (in.read() & 0xFF) << 8 | in.read();
                    int numberOfComponents = in.read() & 0xFF;
                    TIFFDirectory dir = new TIFFDirectory(BaselineTagSet.getInstance(), null, 0);
                    imageNode.add(dir);
                    dir.add(new TIFFField(BaselineTagSet.BitsPerSample, samplePrecision));
                    dir.add(new TIFFField(BaselineTagSet.ImageWidth, samplesPerLine));
                    dir.add(new TIFFField(BaselineTagSet.ImageHeight, numberOfLines));
                    break;
                }
                case 65496: {
                    imageNode = new TIFFDirectory((TagSet)ImageTagSet.getInstance(), null, imageCount++, 0L, in.getStreamPosition(), new FileSegment(seg.offset, seg.length));
                    this.root.add(imageNode);
                    exifStream = new ByteArrayOutputStream();
                    exifSeg = new ArrayList<FileSegment>();
                    mpStream = new ByteArrayOutputStream();
                    mpSeg = new ArrayList<FileSegment>();
                    break;
                }
                case 65505: {
                    try {
                        in.read(buf, 0, 6);
                        if (!new String(buf, 0, 6, "ASCII").equals("Exif\u0000\u0000")) {
                        }
                    }
                    catch (IOException e) {}
                    break;
                    exifSeg.add(new FileSegment(seg.offset + 6L, seg.length - 6));
                    int count = in.read(buf);
                    while (count != -1) {
                        exifStream.write(buf, 0, count);
                        count = in.read(buf);
                    }
                    break;
                }
                case 65506: {
                    try {
                        in.read(buf, 0, 4);
                        if (!new String(buf, 0, 4, "ASCII").equals("MPF\u0000")) {
                        }
                    }
                    catch (IOException e) {}
                    break;
                    mpSeg.add(new FileSegment(seg.offset + 4L, seg.length - 4));
                    int count = in.read(buf);
                    while (count != -1) {
                        mpStream.write(buf, 0, count);
                        count = in.read(buf);
                    }
                    break;
                }
                case 65497: {
                    break;
                }
                case 65498: {
                    if (exifStream.size() > 0) {
                        TIFFInputStream tin = new TIFFInputStream(new ByteArrayImageInputStream(exifStream.toByteArray()));
                        this.readTIFFIFD(tin, imageNode, exifSeg);
                        exifStream.reset();
                    }
                    if (mpStream.size() > 0) {
                        TIFFInputStream tin = new TIFFInputStream(new ByteArrayImageInputStream(mpStream.toByteArray()));
                        this.readMPFIFD(tin, imageNode, null, mpSeg);
                        mpStream.reset();
                    }
                    if (this.firstImageOnly) {
                        return;
                    }
                    long streamPosition = in.getStreamPosition();
                    Long nextImage = this.imageOffsets.ceiling(streamPosition);
                    if (nextImage == null) {
                        return;
                    }
                    in.skipFully(nextImage - streamPosition);
                }
            }
            seg = in.getNextSegment();
        }
    }

    private void readRIFF(ImageInputStream iin) throws IOException {
        this.root = new TIFFDirectory(null, null, -1);
        RIFFParser parser = new RIFFParser();
        final int hdrl_ID = RIFFParser.stringToID("hdrl");
        int strl_ID = RIFFParser.stringToID("strl");
        final int strh_ID = RIFFParser.stringToID("strh");
        final int strd_ID = RIFFParser.stringToID("strd");
        final int AVI_ID = RIFFParser.stringToID("AVI ");
        int AVIF_ID = RIFFParser.stringToID("AVIF");
        int RIFF_ID = RIFFParser.stringToID("RIFF");
        int LIST_ID = RIFFParser.stringToID("LIST");
        parser.declareDataChunk(strl_ID, strh_ID);
        parser.declareDataChunk(strl_ID, strd_ID);
        parser.declareGroupChunk(AVI_ID, RIFF_ID);
        parser.declareGroupChunk(hdrl_ID, LIST_ID);
        parser.declareGroupChunk(strl_ID, LIST_ID);
        try {
            parser.parse(new ImageInputStreamAdapter(iin), new RIFFVisitor(){
                private boolean isAVI;
                private int trackCount = 0;
                private TIFFDirectory trackNode;

                @Override
                public void enterGroup(RIFFChunk group) throws ParseException, AbortException {
                    if (group.getType() == AVI_ID) {
                        this.isAVI = true;
                    }
                }

                @Override
                public void leaveGroup(RIFFChunk group) throws ParseException, AbortException {
                    if (group.getType() == AVI_ID) {
                        this.isAVI = false;
                    }
                    if (this.isAVI && group.getType() == hdrl_ID) {
                        throw new AbortException();
                    }
                }

                @Override
                public void visitChunk(RIFFChunk group, RIFFChunk chunk) throws ParseException, AbortException {
                    if (chunk.getID() == strh_ID) {
                        ++this.trackCount;
                    } else if (chunk.getID() == strd_ID) {
                        this.trackNode = new TIFFDirectory((TagSet)TrackTagSet.getInstance(), null, this.trackCount - 1, null, null, new FileSegment(chunk.getScan(), chunk.getSize()));
                        EXIFReader.this.root.add(this.trackNode);
                        try (ByteArrayImageInputStream in = new ByteArrayImageInputStream(chunk.getData(), 8, (int)chunk.getSize() - 8, ByteOrder.LITTLE_ENDIAN);){
                            TIFFInputStream tin = new TIFFInputStream(in, ByteOrder.LITTLE_ENDIAN, 0L);
                            ArrayList<FileSegment> tiffSeg = new ArrayList<FileSegment>();
                            tiffSeg.add(new FileSegment(chunk.getScan() + 8L, chunk.getSize() - 8L));
                            EXIFReader.this.readTIFFIFD(tin, this.trackNode, tiffSeg);
                        }
                        if (EXIFReader.this.isFirstImageOnly()) {
                            throw new AbortException();
                        }
                    }
                }

                @Override
                public boolean enteringGroup(RIFFChunk group) {
                    return true;
                }
            });
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (AbortException abortException) {
            // empty catch block
        }
    }

    public void readAVIstrdChunk(byte[] data) throws IOException {
        int track = 0;
        int scan = 0;
        this.root = new TIFFDirectory(null, null, -1);
        TIFFDirectory trackNode = new TIFFDirectory((TagSet)TrackTagSet.getInstance(), null, track, null, null, new FileSegment(0L, data.length));
        this.root.add(trackNode);
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, 8, data.length - 8, ByteOrder.LITTLE_ENDIAN);
        TIFFInputStream tin = new TIFFInputStream(in, ByteOrder.LITTLE_ENDIAN, 0L);
        ArrayList<FileSegment> tiffSeg = new ArrayList<FileSegment>();
        tiffSeg.add(new FileSegment(scan + 8, data.length - 8));
        this.readTIFFIFD(tin, trackNode, tiffSeg);
    }

    private void readTIFFIFD(TIFFInputStream tin, TIFFDirectory parent, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        BaselineTagSet tagSet = BaselineTagSet.getInstance();
        IFD ifd = tin.readIFD(tin.getFirstIFDOffset(), true, true);
        while (ifd != null) {
            TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, null, count++, ifd, null, tiffSeg);
            parent.add(ifdNode);
            long thumbnailOffset = 0L;
            long thumbnailLength = 0L;
            int entryCount = 0;
            for (IFDEntry entry : ifd.getEntries()) {
                switch (entry.getTagNumber()) {
                    case 34665: {
                        this.readExifIFD(tin, entry.getValueOffset(), ifdNode, entry, tiffSeg);
                        break;
                    }
                    case 34853: {
                        this.readGPSIFD(tin, entry.getValueOffset(), ifdNode, entry, tiffSeg);
                        break;
                    }
                    case 40965: {
                        this.readInteropIFD(tin, entry.getValueOffset(), ifdNode, entry, tiffSeg);
                        break;
                    }
                    case 513: {
                        thumbnailOffset = entry.getValueOffset();
                        ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                        break;
                    }
                    case 514: {
                        thumbnailLength = entry.getValueOffset();
                        ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                        break;
                    }
                    default: {
                        ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                    }
                }
                ++entryCount;
            }
            if (thumbnailOffset > 0L && thumbnailLength > 0L) {
                IFDEntry entry;
                byte[] buf = new byte[(int)thumbnailLength];
                tin.read(thumbnailOffset, buf, 0, (int)thumbnailLength);
                entry = new IFDEntry(-1, IFDDataType.UNDEFINED.getTypeNumber(), thumbnailLength, thumbnailOffset, -1L);
                ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
            }
            ifd = tin.readIFD(ifd.getNextOffset());
        }
    }

    private void readExifIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        EXIFTagSet tagSet = EXIFTagSet.getInstance();
        IFD ifd = tin.readIFD(offset);
        while (ifd != null) {
            TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, BaselineTagSet.getInstance().getTag(34665), count++, ifd, parentEntry, tiffSeg);
            parent.add(ifdNode);
            int entryCount = 0;
            for (IFDEntry entry : ifd.getEntries()) {
                if (entry.getTagNumber() == EXIFTagSet.Interoperability.getNumber()) {
                    this.readInteropIFD(tin, entry.getValueOffset(), ifdNode, entry, tiffSeg);
                } else if (entry.getTagNumber() == EXIFTagSet.MakerNote.getNumber()) {
                    if (this.readMakerNoteIFD(tin, entry.getValueOffset(), ifdNode, entry, tiffSeg)) {
                        break;
                    }
                } else {
                    ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                }
                ++entryCount;
            }
            ifd = tin.readIFD(ifd.getNextOffset());
        }
    }

    private void readGPSIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        GPSTagSet tagSet = GPSTagSet.getInstance();
        IFD ifd = tin.readIFD(offset);
        while (ifd != null) {
            TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, BaselineTagSet.getInstance().getTag(34853), count++, ifd, parentEntry, tiffSeg);
            parent.add(ifdNode);
            int entryCount = 0;
            for (IFDEntry entry : ifd.getEntries()) {
                ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                ++entryCount;
            }
            ifd = tin.readIFD(ifd.getNextOffset());
        }
    }

    private void readInteropIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        InteroperabilityTagSet tagSet = InteroperabilityTagSet.getInstance();
        IFD ifd = tin.readIFD(offset);
        while (ifd != null) {
            TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, BaselineTagSet.getInstance().getTag(40965), count++, ifd, parentEntry, tiffSeg);
            parent.add(ifdNode);
            int entryCount = 0;
            for (IFDEntry entry : ifd.getEntries()) {
                ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                ++entryCount;
            }
            ifd = tin.readIFD(ifd.getNextOffset());
        }
    }

    private void readMPFIFD(TIFFInputStream tin, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        MPFTagSet tagSet = MPFTagSet.getInstance();
        IFD ifd = tin.readIFD(tin.getFirstIFDOffset());
        while (ifd != null) {
            TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, null, count++, ifd, parentEntry, tiffSeg);
            parent.add(ifdNode);
            int entryCount = 0;
            block4: for (IFDEntry entry : ifd.getEntries()) {
                switch (entry.getTagNumber()) {
                    case 45058: {
                        this.readMPEntries(tin, entry, ifdNode, tiffSeg);
                        continue block4;
                    }
                }
                ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                ++entryCount;
            }
            ifd = tin.readIFD(ifd.getNextOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMPEntries(TIFFInputStream tin, IFDEntry mpEntryInformation, TIFFDirectory parent, ArrayList<FileSegment> tiffSeg) throws IOException {
        byte[] buf = (byte[])mpEntryInformation.readData(tin);
        MPEntryTagSet tagSet = MPEntryTagSet.getInstance();
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(buf);
        ByteOrder bo = tin.getByteOrder();
        in.setByteOrder(bo);
        int numImages = (int)mpEntryInformation.getLength() / 16;
        try {
            for (int imageCount = 0; imageCount < numImages; ++imageCount) {
                TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, tagSet.getTag(45058), imageCount, mpEntryInformation.getValueOffset(), (long)(16 * imageCount), tiffSeg);
                parent.add(ifdNode);
                int imageAttr = in.readInt();
                short dpif = (short)(imageAttr >>> 31);
                ifdNode.add(new TIFFField(tagSet.getTag(-1), dpif));
                short dcif = (short)(imageAttr >>> 30 & 1);
                ifdNode.add(new TIFFField(tagSet.getTag(-2), dcif));
                short rif = (short)(imageAttr >>> 29 & 1);
                ifdNode.add(new TIFFField(tagSet.getTag(-3), rif));
                short idf = (short)(imageAttr >>> 24 & 7);
                ifdNode.add(new TIFFField(tagSet.getTag(-4), idf));
                long mptc = (long)imageAttr & 0xFFFFFFL;
                ifdNode.add(new TIFFField(tagSet.getTag(-5), mptc));
                long imageSize = (long)in.readInt() & 0xFFFFFFFFL;
                ifdNode.add(new TIFFField(tagSet.getTag(-6), imageSize));
                long imageOffset = (long)in.readInt() & 0xFFFFFFFFL;
                ifdNode.add(new TIFFField(tagSet.getTag(-7), imageOffset));
                this.imageOffsets.add(imageOffset);
                int dependentImageEntryNumber = in.readUnsignedShort();
                ifdNode.add(new TIFFField(tagSet.getTag(-8), dependentImageEntryNumber));
                dependentImageEntryNumber = in.readUnsignedShort();
                ifdNode.add(new TIFFField(tagSet.getTag(-9), dependentImageEntryNumber));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            in.close();
        }
    }

    private boolean readMakerNoteIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        try {
            String magic = tin.readASCII(offset, 10L);
            if (magic.equals("FUJIFILM\f")) {
                return this.readFujifilmMakerNoteIFD(tin, offset, parent, parentEntry, tiffSeg);
            }
            if (magic.equals("SONY DSC ")) {
                return this.readSonyMakerNoteIFD(tin, offset, parent, parentEntry, tiffSeg);
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private boolean readFujifilmMakerNoteIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        FujifilmMakerNoteTagSet tagSet = FujifilmMakerNoteTagSet.getInstance();
        try {
            IFD ifd = tin.readIFD(offset + 12L);
            while (ifd != null) {
                TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, EXIFTagSet.MakerNote, count++, ifd, parentEntry, tiffSeg);
                parent.add(ifdNode);
                int entryCount = 0;
                for (IFDEntry entry : ifd.getEntries()) {
                    entry.setIFDOffset(offset);
                    ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                    ++entryCount;
                }
                ifd = tin.readIFD(ifd.getNextOffset());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean readSonyMakerNoteIFD(TIFFInputStream tin, long offset, TIFFDirectory parent, IFDEntry parentEntry, ArrayList<FileSegment> tiffSeg) throws IOException {
        int count = 0;
        SonyMakerNoteTagSet tagSet = SonyMakerNoteTagSet.getInstance();
        try {
            IFD ifd = tin.readIFD(offset + 12L);
            while (ifd != null) {
                TIFFDirectory ifdNode = new TIFFDirectory((TagSet)tagSet, EXIFTagSet.MakerNote, count++, ifd, parentEntry, tiffSeg);
                parent.add(ifdNode);
                int entryCount = 0;
                for (IFDEntry entry : ifd.getEntries()) {
                    ifdNode.add(new TIFFField(tagSet.getTag(entry.getTagNumber()), entry.readData(tin), entry));
                    ++entryCount;
                }
                ifd = tin.readIFD(ifd.getNextOffset());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public TIFFNode getMetaDataTree() {
        return this.root;
    }

    public int getImageCount() {
        return this.root == null ? -1 : this.root.getChildCount();
    }

    public ArrayList<TIFFDirectory> getDirectories(int image, TagSet tagSet) {
        ArrayList<TIFFDirectory> dirs = new ArrayList<TIFFDirectory>();
        Stack<TIFFDirectory> stack = new Stack<TIFFDirectory>();
        stack.push((TIFFDirectory)this.getMetaDataTree().getChildAt(image));
        while (!stack.isEmpty()) {
            TIFFDirectory dir = (TIFFDirectory)stack.pop();
            for (TIFFNode node : dir.getChildren()) {
                if (!(node instanceof TIFFDirectory)) continue;
                TIFFDirectory dirNode = (TIFFDirectory)node;
                if (dirNode.getTagSet() == tagSet) {
                    dirs.add(0, dirNode);
                    continue;
                }
                stack.push(dirNode);
            }
        }
        return dirs;
    }

    public ArrayList<BufferedImage> getThumbnails(boolean suppressException) throws IOException {
        ArrayList<BufferedImage> thumbnails = new ArrayList<BufferedImage>();
        Stack<TIFFDirectory> stack = new Stack<TIFFDirectory>();
        stack.push((TIFFDirectory)this.getMetaDataTree());
        if (stack.peek() == null) {
            return thumbnails;
        }
        while (!stack.isEmpty()) {
            TIFFDirectory dir = (TIFFDirectory)stack.pop();
            for (TIFFNode node : dir.getChildren()) {
                TIFFField field;
                if (node instanceof TIFFDirectory) {
                    stack.push((TIFFDirectory)node);
                    continue;
                }
                if (!(node instanceof TIFFField) || (field = (TIFFField)node).getTag() != BaselineTagSet.JPEGThumbnailImage) continue;
                try {
                    thumbnails.add(0, ImageIO.read(new ByteArrayImageInputStream((byte[])field.getData())));
                }
                catch (IOException e) {
                    if (suppressException) continue;
                    throw e;
                }
            }
        }
        return thumbnails;
    }

    public HashMap<TIFFTag, TIFFField> getMetaDataMap() {
        HashMap<TIFFTag, TIFFField> m = new HashMap<TIFFTag, TIFFField>();
        Iterator<TIFFNode> i = this.root.preorderIterator();
        while (i.hasNext()) {
            TIFFNode node = i.next();
            if (!(node instanceof TIFFField)) continue;
            m.put(node.getTag(), (TIFFField)node);
        }
        return m;
    }

    public IIOMetadataNode getIIOMetadataTree(String formatName, int imageIndex) {
        if (formatName != null && !formatName.equals("com_sun_media_imageio_plugins_tiff_image_1.0")) {
            throw new IllegalArgumentException("Unsupported formatName:" + formatName);
        }
        IIOMetadataNode iioRoot = new IIOMetadataNode("com_sun_media_imageio_plugins_tiff_image_1.0");
        TIFFNode imageRoot = this.root.getChildAt(imageIndex);
        for (TIFFNode node : imageRoot.getChildren()) {
            this.addIIOMetadataNode(iioRoot, node);
        }
        return iioRoot;
    }

    private void addIIOMetadataNode(IIOMetadataNode iioParent, TIFFNode node) {
        if (node instanceof TIFFDirectory) {
            TIFFDirectory dir = (TIFFDirectory)node;
            IIOMetadataNode iioNode = new IIOMetadataNode("TIFFIFD");
            TagSet tagSet = dir.getTagSet();
            iioNode.setAttribute("tagSets", dir == null ? "" : tagSet.getName());
            if (dir.getTag() != null) {
                iioNode.setAttribute("parentTagNumber", Integer.toString(dir.getTagNumber()));
                iioNode.setAttribute("parentTagName", dir.getTag().getName());
            }
            iioParent.appendChild(iioNode);
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.addIIOMetadataNode(iioNode, node.getChildAt(i));
            }
        } else if (node instanceof TIFFField) {
            TIFFField field = (TIFFField)node;
            IIOMetadataNode iioNode = new IIOMetadataNode("TIFFField");
            iioNode.setAttribute("number", Integer.toString(field.getTagNumber()));
            if (field.getTagName() != null && !field.getTagName().equals("unknown")) {
                iioNode.setAttribute("name", field.getTagName());
            }
            IIOMetadataNode iioSequence = null;
            String description = field.getDescription();
            switch (field.getType()) {
                case ASCII: {
                    iioSequence = new IIOMetadataNode("TIFFAsciis");
                    IIOMetadataNode iioValue = new IIOMetadataNode("TIFFAscii");
                    iioValue.setAttribute("value", (String)field.getData());
                    iioSequence.appendChild(iioValue);
                    break;
                }
                case BYTE: {
                    short[] sArray;
                    iioSequence = new IIOMetadataNode("TIFFBytes");
                    if (field.getData() instanceof Short) {
                        short[] sArray2 = new short[1];
                        sArray = sArray2;
                        sArray2[0] = (Short)field.getData();
                    } else {
                        sArray = (short[])field.getData();
                    }
                    short[] value = sArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFByte");
                        iioValue.setAttribute("value", Short.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case SBYTE: {
                    byte[] byArray;
                    iioSequence = new IIOMetadataNode("TIFFSBytes");
                    if (field.getData() instanceof Byte) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = (Byte)field.getData();
                    } else {
                        byArray = (byte[])field.getData();
                    }
                    byte[] value = byArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFSByte");
                        iioValue.setAttribute("value", Byte.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] dArray;
                    iioSequence = new IIOMetadataNode("TIFFDoubles");
                    if (field.getData() instanceof Double) {
                        double[] dArray2 = new double[1];
                        dArray = dArray2;
                        dArray2[0] = (Double)field.getData();
                    } else {
                        dArray = (double[])field.getData();
                    }
                    double[] value = dArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFDouble");
                        iioValue.setAttribute("value", Double.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                    }
                    break;
                }
                case FLOAT: {
                    float[] fArray;
                    iioSequence = new IIOMetadataNode("TIFFFloats");
                    if (field.getData() instanceof Float) {
                        float[] fArray2 = new float[1];
                        fArray = fArray2;
                        fArray2[0] = ((Float)field.getData()).floatValue();
                    } else {
                        fArray = (float[])field.getData();
                    }
                    float[] value = fArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFFloat");
                        iioValue.setAttribute("value", Double.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case LONG: {
                    long[] lArray;
                    iioSequence = new IIOMetadataNode("TIFFLongs");
                    if (field.getData() instanceof Long) {
                        long[] lArray2 = new long[1];
                        lArray = lArray2;
                        lArray2[0] = (Long)field.getData();
                    } else {
                        lArray = (long[])field.getData();
                    }
                    long[] value = lArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFLong");
                        iioValue.setAttribute("value", Long.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case SLONG: {
                    int[] nArray;
                    iioSequence = new IIOMetadataNode("TIFFSLongs");
                    if (field.getData() instanceof Integer) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = (Integer)field.getData();
                    } else {
                        nArray = (int[])field.getData();
                    }
                    int[] value = nArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFSLong");
                        iioValue.setAttribute("value", Integer.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case RATIONAL: {
                    Rational[] rationalArray;
                    iioSequence = new IIOMetadataNode("TIFFRationals");
                    if (field.getData() instanceof Rational) {
                        Rational[] rationalArray2 = new Rational[1];
                        rationalArray = rationalArray2;
                        rationalArray2[0] = (Rational)field.getData();
                    } else {
                        rationalArray = (Rational[])field.getData();
                    }
                    Rational[] value = rationalArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFRational");
                        iioValue.setAttribute("value", Long.toString(value[i].getNumerator()) + "/" + Long.toString(value[i].getDenominator()));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case SRATIONAL: {
                    Rational[] rationalArray;
                    iioSequence = new IIOMetadataNode("TIFFSRationals");
                    if (field.getData() instanceof Rational) {
                        Rational[] rationalArray3 = new Rational[1];
                        rationalArray = rationalArray3;
                        rationalArray3[0] = (Rational)field.getData();
                    } else {
                        rationalArray = (Rational[])field.getData();
                    }
                    Rational[] value = rationalArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFSRational");
                        iioValue.setAttribute("value", Long.toString(value[i].getNumerator()) + "/" + Long.toString(value[i].getDenominator()));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case SHORT: {
                    int[] nArray;
                    iioSequence = new IIOMetadataNode("TIFFShorts");
                    if (field.getData() instanceof Integer) {
                        int[] nArray3 = new int[1];
                        nArray = nArray3;
                        nArray3[0] = (Integer)field.getData();
                    } else {
                        nArray = (int[])field.getData();
                    }
                    int[] value = nArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFShort");
                        iioValue.setAttribute("value", Integer.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case SSHORT: {
                    short[] sArray;
                    iioSequence = new IIOMetadataNode("TIFFSShorts");
                    if (field.getData() instanceof Short) {
                        short[] sArray3 = new short[1];
                        sArray = sArray3;
                        sArray3[0] = (Short)field.getData();
                    } else {
                        sArray = (short[])field.getData();
                    }
                    short[] value = sArray;
                    for (int i = 0; i < value.length; ++i) {
                        IIOMetadataNode iioValue = new IIOMetadataNode("TIFFSShort");
                        iioValue.setAttribute("value", Short.toString(value[i]));
                        iioSequence.appendChild(iioValue);
                        if (i != 0 || description == null) continue;
                        iioValue.setAttribute("description", description);
                    }
                    break;
                }
                case UNDEFINED: {
                    byte[] byArray;
                    iioSequence = new IIOMetadataNode("TIFFUndefined");
                    if (field.getData() instanceof Byte) {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = (Byte)field.getData();
                    } else {
                        byArray = (byte[])field.getData();
                    }
                    byte[] value = byArray;
                    StringBuilder iioValue = new StringBuilder();
                    for (int i = 0; i < value.length; ++i) {
                        if (i != 0) {
                            iioValue.append(',');
                        }
                        iioValue.append(Integer.toString(value[i] & 0xFF));
                    }
                    iioSequence.setAttribute("value", iioValue.toString());
                    if (description == null) break;
                    iioSequence.setAttribute("description", description);
                    break;
                }
            }
            if (iioSequence != null) {
                iioNode.appendChild(iioSequence);
            }
            iioParent.appendChild(iioNode);
        }
    }

    public IIOMetadata getIIOMetadata(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

