/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.monte.media.eightsvx.LoopableAudioClip;

public class JDK13AppletAudioClip
implements LoopableAudioClip,
Runnable {
    private byte[] samples;
    private static Mixer mixer;
    private static Vector lines;
    private volatile Thread workerThread;
    private int loopCount;
    private int volume;
    private int sampleRate;
    private float pan;
    private int loopStart;
    private int loopEnd;

    public JDK13AppletAudioClip(byte[] samples, int sampleRate, int volume, float pan) throws IOException {
        this.samples = samples;
        this.volume = volume;
        this.pan = pan;
        this.loopStart = 0;
        this.loopEnd = samples.length;
        this.sampleRate = sampleRate;
        try {
            JDK13AppletAudioClip.getMixer();
        }
        catch (LineUnavailableException e) {
            throw new IOException(e.toString());
        }
    }

    private static Mixer getMixer() throws LineUnavailableException {
        if (mixer == null) {
            int i;
            mixer = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
            SourceDataLine[] l = new SourceDataLine[16];
            for (i = 0; i < 16; ++i) {
                l[i] = JDK13AppletAudioClip.aquireLine();
            }
            for (i = 0; i < 16; ++i) {
                JDK13AppletAudioClip.poolLine(l[i]);
            }
        }
        return mixer;
    }

    private static synchronized SourceDataLine aquireLine() throws LineUnavailableException {
        SourceDataLine line;
        if (lines.size() > 0) {
            line = (SourceDataLine)lines.elementAt(0);
            lines.removeElementAt(0);
        } else {
            AudioFormat audioFormat = new AudioFormat(8000.0f, 8, 1, true, true);
            DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
            line = (SourceDataLine)JDK13AppletAudioClip.getMixer().getLine(lineInfo);
            line.open();
            line.start();
        }
        return line;
    }

    private static synchronized void poolLine(SourceDataLine line) {
        if (lines.size() < 16) {
            lines.addElement(line);
        } else {
            line.close();
        }
    }

    public void setLoopPoints(int start, int end) {
        if (start < 0 || start >= this.samples.length || end < start && end != -1 || end >= this.samples.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end);
        }
        this.loopStart = start;
        this.loopEnd = end == -1 ? this.samples.length : end + 1;
    }

    @Override
    public void loop() {
        this.loop(-1);
    }

    @Override
    public synchronized void loop(int count) {
        this.stop();
        this.loopCount = count;
        this.workerThread = new Thread((Runnable)this, this.toString());
        this.workerThread.setPriority(6);
        this.workerThread.start();
    }

    @Override
    public void play() {
        this.loop(0);
    }

    @Override
    public synchronized void stop() {
        if (this.workerThread != null) {
            Thread t = this.workerThread;
            this.workerThread = null;
        }
    }

    private void configureDataLine(DataLine clip) {
        FloatControl control;
        if (clip.isControlSupported(FloatControl.Type.PAN)) {
            control = (FloatControl)clip.getControl(FloatControl.Type.PAN);
            control.setValue(this.pan);
            System.out.println("setPan:" + this.pan);
        } else {
            System.out.println("panning not supported " + this.pan);
        }
        if (clip.isControlSupported(FloatControl.Type.VOLUME)) {
            control = (FloatControl)clip.getControl(FloatControl.Type.VOLUME);
            control.setValue((float)this.volume / 64.0f);
        }
        if (clip.isControlSupported(FloatControl.Type.SAMPLE_RATE)) {
            control = (FloatControl)clip.getControl(FloatControl.Type.SAMPLE_RATE);
            control.setValue(this.sampleRate);
        }
    }

    @Override
    public void run() {
        int framePosition;
        long start = System.currentTimeMillis();
        long mediaDuration = this.samples.length * Math.max(this.loopCount, 1) / 8;
        SourceDataLine out = null;
        try {
            out = JDK13AppletAudioClip.aquireLine();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("configureDataLine");
        this.configureDataLine(out);
        byte[] buf = new byte[100];
        if (this.loopCount > 0 && framePosition < this.loopEnd) {
            while (this.workerThread == Thread.currentThread() && (this.loopCount > 0 || this.loopCount == -1)) {
                while (this.workerThread == Thread.currentThread() && framePosition < this.loopEnd) {
                    System.arraycopy(this.samples, framePosition, buf, 0, Math.min(buf.length, this.loopEnd - framePosition));
                    framePosition += out.write(buf, 0, Math.min(buf.length, this.loopEnd - framePosition));
                }
                if (this.workerThread != Thread.currentThread() || this.loopCount <= 0 && this.loopCount != -1 || this.loopCount == -1) continue;
                --this.loopCount;
                if (this.loopCount == 0) continue;
                framePosition = this.loopStart;
            }
            while (this.workerThread == Thread.currentThread() && framePosition < this.samples.length) {
                System.arraycopy(this.samples, framePosition, buf, 0, Math.min(buf.length, this.samples.length - framePosition));
                framePosition += out.write(buf, 0, Math.min(buf.length, this.samples.length - framePosition));
            }
        } else {
            for (framePosition = 0; this.workerThread == Thread.currentThread() && framePosition < this.samples.length; framePosition += out.write(buf, 0, Math.min(buf.length, this.samples.length - framePosition))) {
                System.arraycopy(this.samples, framePosition, buf, 0, Math.min(buf.length, this.samples.length - framePosition));
            }
        }
        long end = System.currentTimeMillis();
        long elapsed = end - start;
        while (this.workerThread == Thread.currentThread() && mediaDuration > elapsed) {
            try {
                Thread.sleep(Math.max(1L, Math.min(mediaDuration - elapsed, 100L)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            elapsed = System.currentTimeMillis() - start;
        }
        if (this.workerThread != Thread.currentThread()) {
            out.flush();
        }
        JDK13AppletAudioClip.poolLine(out);
    }

    static {
        lines = new Vector();
    }
}

