/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.monte.media.binary.BinaryModel;

public class ByteArrayBinaryModel
implements BinaryModel {
    private Vector elemTable = new Vector();
    private long length;
    private int elemSize = 1024;

    public ByteArrayBinaryModel() {
        this.length = 0L;
    }

    public ByteArrayBinaryModel(byte[] data) {
        if (data == null || data.length == 0) {
            this.length = 0L;
        } else {
            this.elemTable.addElement(data);
            this.elemSize = data.length;
            this.length = this.elemSize;
        }
    }

    public ByteArrayBinaryModel(InputStream in) throws IOException {
        this();
        byte[] elem = new byte[this.elemSize];
        int elemLen = 0;
        while (true) {
            int readLen;
            if ((readLen = in.read(elem, elemLen, this.elemSize - elemLen)) == -1) {
                this.elemTable.addElement(elem);
                this.length += (long)elemLen;
                break;
            }
            if ((elemLen += readLen) != this.elemSize) continue;
            this.elemTable.addElement(elem);
            this.length += (long)this.elemSize;
            elem = new byte[this.elemSize];
            elemLen = 0;
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public int getBytes(long offset, int len, byte[] target) {
        int off = (int)offset;
        if ((long)len + offset > this.length) {
            len = (int)(this.length - offset);
        }
        int index = off / this.elemSize;
        byte[] elem = (byte[])this.elemTable.elementAt(index);
        int count = 0;
        int i = off % this.elemSize;
        while (count < len) {
            if (i == elem.length) {
                elem = (byte[])this.elemTable.elementAt(++index);
                i = 0;
            }
            target[count++] = elem[i++];
        }
        return count;
    }

    @Override
    public void close() {
        this.elemTable = null;
        this.length = 0L;
    }
}

