/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;
import org.monte.media.jpeg.JFIFInputStream;

public class CMYKJPEGImageReader
extends ImageReader {
    private boolean isIgnoreICCProfile = false;
    private boolean isYCCKInversed = true;
    private static DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private BufferedImage image;
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab = new int[256];
    private static final int[] Cb_b_tab = new int[256];
    private static final int[] Cr_g_tab = new int[256];
    private static final int[] Cb_g_tab = new int[256];

    public CMYKJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageInputStream iis = null;
            Object in = this.getInput();
            if (in instanceof byte[]) {
                iis = new ByteArrayImageInputStream((byte[])in);
            } else if (in instanceof ImageInputStream) {
                iis = (ImageInputStream)in;
            } else if (in instanceof InputStream) {
                iis = new MemoryCacheImageInputStream((InputStream)in);
            } else {
                throw new IOException("Can't handle input of type " + in);
            }
            this.image = CMYKJPEGImageReader.read(iis, this.isYCCKInversed, this.isIgnoreICCProfile);
        }
    }

    public boolean isYCCKInversed() {
        return this.isYCCKInversed;
    }

    public void setYCCKInversed(boolean newValue) {
        this.isYCCKInversed = newValue;
    }

    public boolean isIgnoreICCProfile() {
        return this.isIgnoreICCProfile;
    }

    public void setIgnoreICCProfile(boolean newValue) {
        this.isIgnoreICCProfile = newValue;
    }

    public static BufferedImage read(ImageInputStream in, boolean inverseYCCKColors, boolean isIgnoreColorProfile) throws IOException {
        in.seek(0L);
        int samplePrecision = 0;
        int numberOfLines = 0;
        int numberOfSamplesPerLine = 0;
        int numberOfComponentsInFrame = 0;
        int app14AdobeColorTransform = 0;
        ByteArrayOutputStream app2ICCProfile = new ByteArrayOutputStream();
        JFIFInputStream fifi = new JFIFInputStream(new ImageInputStreamAdapter(in));
        JFIFInputStream.Segment seg = fifi.getNextSegment();
        while (seg != null) {
            DataInputStream dis;
            if (65472 <= seg.marker && seg.marker <= 65475 || 65477 <= seg.marker && seg.marker <= 65479 || 65481 <= seg.marker && seg.marker <= 65483 || 65485 <= seg.marker && seg.marker <= 65487) {
                dis = new DataInputStream(fifi);
                samplePrecision = dis.readUnsignedByte();
                numberOfLines = dis.readUnsignedShort();
                numberOfSamplesPerLine = dis.readUnsignedShort();
                numberOfComponentsInFrame = dis.readUnsignedByte();
                break;
            }
            if (seg.marker == 65506) {
                if (seg.length >= 26 && (dis = new DataInputStream(fifi)).readLong() == 5279137264856878918L && dis.readInt() == 1229735168) {
                    dis.skipBytes(2);
                    byte[] b = new byte[512];
                    int count = dis.read(b);
                    while (count != -1) {
                        app2ICCProfile.write(b, 0, count);
                        count = dis.read(b);
                    }
                }
            } else if (seg.marker == 65518 && seg.length == 12 && (long)(dis = new DataInputStream(fifi)).readInt() == 1097101154L && dis.readUnsignedShort() == 25856) {
                int version = dis.readUnsignedByte();
                int app14Flags0 = dis.readUnsignedShort();
                int app14Flags1 = dis.readUnsignedShort();
                app14AdobeColorTransform = dis.readUnsignedByte();
            }
            seg = fifi.getNextSegment();
        }
        BufferedImage img = null;
        if (numberOfComponentsInFrame != 4) {
            in.seek(0L);
            img = CMYKJPEGImageReader.readRGBImageFromYCC(new ImageInputStreamAdapter(in), null);
        } else if (numberOfComponentsInFrame == 4) {
            ICC_Profile profile = null;
            if (!isIgnoreColorProfile && app2ICCProfile.size() > 0) {
                try {
                    profile = ICC_Profile.getInstance(new ByteArrayInputStream(app2ICCProfile.toByteArray()));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            switch (app14AdobeColorTransform) {
                default: {
                    in.seek(0L);
                    img = CMYKJPEGImageReader.readRGBAImageFromRGBA(new ImageInputStreamAdapter(in), profile);
                    break;
                }
                case 1: {
                    throw new IOException("YCbCr not supported");
                }
                case 2: {
                    if (profile == null) {
                        profile = ICC_Profile.getInstance(CMYKJPEGImageReader.class.getResourceAsStream("Generic CMYK Profile.icc"));
                    }
                    in.seek(0L);
                    img = inverseYCCKColors ? CMYKJPEGImageReader.readRGBImageFromInvertedYCCK(new ImageInputStreamAdapter(in), profile) : CMYKJPEGImageReader.readRGBImageFromYCCK(new ImageInputStreamAdapter(in), profile);
                }
            }
        }
        return img;
    }

    private static ImageReader createNativeJPEGReader() {
        return new JPEGImageReader(new CMYKJPEGImageReaderSpi());
    }

    public static BufferedImage readRGBImageFromCMYK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, cmykProfile);
        return image;
    }

    public static BufferedImage readRGBAImageFromRGBA(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = CMYKJPEGImageReader.createRGBAImageFromRGBA(raster, rgbaProfile);
        return image;
    }

    public static BufferedImage readRGBImageFromRGB(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = CMYKJPEGImageReader.createRGBImageFromRGB(raster, rgbaProfile);
        return image;
    }

    public static BufferedImage readRGBImageFromYCC(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = CMYKJPEGImageReader.createRGBImageFromYCC(raster, rgbaProfile);
        return image;
    }

    public static BufferedImage readRGBImageFromYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = CMYKJPEGImageReader.createRGBImageFromYCCK(raster, cmykProfile);
        return image;
    }

    public static BufferedImage readRGBImageFromInvertedYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream);
        Raster raster = reader.readRaster(0, null);
        raster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(raster);
        BufferedImage image = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, cmykProfile);
        return image;
    }

    public static BufferedImage createRGBImageFromYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        if (cmykProfile != null) {
            ycckRaster = CMYKJPEGImageReader.convertYCCKtoCMYK(ycckRaster);
            image = CMYKJPEGImageReader.createRGBImageFromCMYK(ycckRaster, cmykProfile);
        } else {
            int w = ycckRaster.getWidth();
            int h = ycckRaster.getHeight();
            int[] rgb = new int[w * h];
            int[] Y = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] Cb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Cr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = Y.length;
            for (int i = 0; i < imax; ++i) {
                float k = K[i];
                float y = Y[i];
                float cb = Cb[i];
                float cr = Cr[i];
                float vr = y + 1.402f * (cr - 128.0f) - k;
                float vg = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f) - k;
                float vb = y + 1.772f * (cb - 128.0f) - k;
                rgb[i] = (0xFF & (vr < 0.0f ? 0 : (vr > 255.0f ? 255 : (int)(vr + 0.5f)))) << 16 | (0xFF & (vg < 0.0f ? 0 : (vg > 255.0f ? 255 : (int)(vg + 0.5f)))) << 8 | 0xFF & (vb < 0.0f ? 0 : (vb > 255.0f ? 255 : (int)(vb + 0.5f)));
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = RGB;
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBImageFromInvertedYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        if (cmykProfile != null) {
            ycckRaster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(ycckRaster);
            image = CMYKJPEGImageReader.createRGBImageFromCMYK(ycckRaster, cmykProfile);
        } else {
            int w = ycckRaster.getWidth();
            int h = ycckRaster.getHeight();
            int[] rgb = new int[w * h];
            int[] Y = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] Cb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Cr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = Y.length;
            for (int i = 0; i < imax; ++i) {
                float k = 255 - K[i];
                float y = 255 - Y[i];
                float cb = 255 - Cb[i];
                float cr = 255 - Cr[i];
                float vr = y + 1.402f * (cr - 128.0f) - k;
                float vg = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f) - k;
                float vb = y + 1.772f * (cb - 128.0f) - k;
                rgb[i] = (0xFF & (vr < 0.0f ? 0 : (vr > 255.0f ? 255 : (int)(vr + 0.5f)))) << 16 | (0xFF & (vg < 0.0f ? 0 : (vg > 255.0f ? 255 : (int)(vg + 0.5f)))) << 8 | 0xFF & (vb < 0.0f ? 0 : (vb > 255.0f ? 255 : (int)(vb + 0.5f)));
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = RGB;
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBImageFromCMYK(Raster cmykRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        int w = cmykRaster.getWidth();
        int h = cmykRaster.getHeight();
        if (cmykProfile != null) {
            ICC_ColorSpace cmykCS = new ICC_ColorSpace(cmykProfile);
            image = new BufferedImage(w, h, 1);
            WritableRaster rgbRaster = image.getRaster();
            ColorSpace rgbCS = image.getColorModel().getColorSpace();
            ColorConvertOp cmykToRgb = new ColorConvertOp(cmykCS, rgbCS, null);
            cmykToRgb.filter(cmykRaster, rgbRaster);
        } else {
            int[] rgb = new int[w * h];
            int[] C = cmykRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] M = cmykRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Y = cmykRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = cmykRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = C.length;
            for (int i = 0; i < imax; ++i) {
                int k = K[i];
                rgb[i] = 255 - Math.min(255, C[i] + k) << 16 | 255 - Math.min(255, M[i] + k) << 8 | 255 - Math.min(255, Y[i] + k);
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = RGB;
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBAImageFromRGBA(Raster rgbaRaster, ICC_Profile rgbaProfile) {
        BufferedImage image;
        int w = rgbaRaster.getWidth();
        int h = rgbaRaster.getHeight();
        if (rgbaProfile != null) {
            ICC_ColorSpace rgbaCS = new ICC_ColorSpace(rgbaProfile);
            image = new BufferedImage(w, h, 1);
            WritableRaster rgbRaster = image.getRaster();
            ColorSpace rgbCS = image.getColorModel().getColorSpace();
            ColorConvertOp cmykToRgb = new ColorConvertOp(rgbaCS, rgbCS, null);
            cmykToRgb.filter(rgbaRaster, rgbRaster);
        } else {
            int[] rgb = new int[w * h];
            int[] R = rgbaRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] G = rgbaRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] B = rgbaRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] A = rgbaRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = R.length;
            for (int i = 0; i < imax; ++i) {
                rgb[i] = A[i] << 24 | R[i] << 16 | G[i] << 8 | B[i];
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBImageFromRGB(Raster rgbaRaster, ICC_Profile rgbaProfile) {
        BufferedImage image;
        int w = rgbaRaster.getWidth();
        int h = rgbaRaster.getHeight();
        rgbaProfile = null;
        if (rgbaProfile != null) {
            ICC_ColorSpace rgbaCS = new ICC_ColorSpace(rgbaProfile);
            image = new BufferedImage(w, h, 1);
            WritableRaster rgbRaster = image.getRaster();
            ColorSpace rgbCS = image.getColorModel().getColorSpace();
            ColorConvertOp cmykToRgb = new ColorConvertOp(rgbaCS, rgbCS, null);
            cmykToRgb.filter(rgbaRaster, rgbRaster);
        } else {
            int[] rgb = new int[w * h];
            int[] R = rgbaRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] G = rgbaRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] B = rgbaRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int imax = R.length;
            for (int i = 0; i < imax; ++i) {
                rgb[i] = 0xFF000000 | R[i] << 16 | G[i] << 8 | B[i];
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBImageFromYCC(Raster rgbaRaster, ICC_Profile rgbaProfile) {
        BufferedImage image;
        int w = rgbaRaster.getWidth();
        int h = rgbaRaster.getHeight();
        rgbaProfile = null;
        if (rgbaProfile != null) {
            ICC_ColorSpace rgbaCS = new ICC_ColorSpace(rgbaProfile);
            image = new BufferedImage(w, h, 1);
            WritableRaster rgbRaster = image.getRaster();
            ColorSpace rgbCS = image.getColorModel().getColorSpace();
            ColorConvertOp cmykToRgb = new ColorConvertOp(rgbaCS, rgbCS, null);
            cmykToRgb.filter(rgbaRaster, rgbRaster);
        } else {
            int[] rgb = new int[w * h];
            int[] Y = rgbaRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] Cb = rgbaRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Cr = rgbaRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int imax = Y.length;
            for (int i = 0; i < imax; ++i) {
                int Yi = Y[i];
                int Cbi = Cb[i];
                int Cri = Cr[i];
                int R = (1000 * Yi + 1402 * (Cri - 128)) / 1000;
                int G = (100000 * Yi - 34414 * (Cbi - 128) - 71414 * (Cri - 128)) / 100000;
                int B = (1000 * Yi + 1772 * (Cbi - 128)) / 1000;
                R = Math.min(255, Math.max(0, R));
                G = Math.min(255, Math.max(0, G));
                B = Math.min(255, Math.max(0, B));
                rgb[i] = 0xFF000000 | R << 16 | G << 8 | B;
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int i = 0;
            int x = -128;
            while (i <= 255) {
                CMYKJPEGImageReader.Cr_r_tab[i] = (int)(91881.972 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cb_b_tab[i] = (int)(116130.292 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cr_g_tab[i] = -46802 * x;
                CMYKJPEGImageReader.Cb_g_tab[i] = -22554 * x + 32768;
                ++i;
                ++x;
            }
        }
    }

    private static Raster convertInvertedYCCKToCMYK(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycckY = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] ycckCb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] ycckCr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] ycckK = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int[] cmyk = new int[ycckY.length];
        for (int i = 0; i < ycckY.length; ++i) {
            int y = 255 - ycckY[i];
            int cb = 255 - ycckCb[i];
            int cr = 255 - ycckCr[i];
            int cmykC = 255 - (y + Cr_r_tab[cr]);
            int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
            int cmykY = 255 - (y + Cb_b_tab[cb]);
            cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | 255 - ycckK[i];
        }
        WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return cmykRaster;
    }

    private static Raster convertYCCKtoCMYK(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycckY = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] ycckCb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] ycckCr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] ycckK = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int[] cmyk = new int[ycckY.length];
        for (int i = 0; i < ycckY.length; ++i) {
            int y = ycckY[i];
            int cb = ycckCb[i];
            int cr = ycckCr[i];
            int cmykC = 255 - (y + Cr_r_tab[cr]);
            int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
            int cmykY = 255 - (y + Cb_b_tab[cb]);
            cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | ycckK[i];
        }
        return Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
    }

    public static BufferedImage readImageFromYCCorGray(ImageInputStream in) throws IOException {
        ImageReader r = CMYKJPEGImageReader.createNativeJPEGReader();
        r.setInput(in);
        BufferedImage img = r.read(0);
        return img;
    }
}

