/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MC68000OutputStream
extends FilterOutputStream {
    protected long written;

    public MC68000OutputStream(OutputStream out) {
        super(out);
    }

    public void writeLONG(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(4);
    }

    public void writeULONG(long v) throws IOException {
        this.out.write((int)(v >>> 24 & 0xFFL));
        this.out.write((int)(v >>> 16 & 0xFFL));
        this.out.write((int)(v >>> 8 & 0xFFL));
        this.out.write((int)(v >>> 0 & 0xFFL));
        this.incCount(4);
    }

    public void writeWORD(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    public void writeUWORD(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    public void writeUBYTE(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(1);
    }

    public void writeByteRun1(byte[] data) throws IOException {
        this.writeByteRun1(data, 0, data.length);
    }

    public void writeByteRun1(byte[] data, int offset, int length) throws IOException {
        int i;
        int end = offset + length;
        int literalOffset = offset;
        for (i = offset; i < end; ++i) {
            int repeatCount;
            byte b = data[i];
            for (repeatCount = i + 1; repeatCount < end && data[repeatCount] == b; ++repeatCount) {
            }
            if ((repeatCount -= i) == 1) {
                if (i - literalOffset <= 127) continue;
                this.write(i - literalOffset - 1);
                this.write(data, literalOffset, i - literalOffset);
                literalOffset = i;
                continue;
            }
            if (repeatCount == 2 && literalOffset < i && i - literalOffset < 127) {
                ++i;
                continue;
            }
            if (literalOffset < i) {
                this.write(i - literalOffset - 1);
                this.write(data, literalOffset, i - literalOffset);
            }
            literalOffset = (i += repeatCount - 1) + 1;
            while (repeatCount > 128) {
                this.write(-127);
                this.write(b);
                repeatCount -= 128;
            }
            this.write(-repeatCount + 1);
            this.write(b);
        }
        if (literalOffset < end) {
            this.write(i - literalOffset - 1);
            this.write(data, literalOffset, i - literalOffset);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public void writeType(String s) throws IOException {
        if (s.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(s.getBytes("ASCII"), 0, 4);
            this.incCount(4);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public final long size() {
        return this.written;
    }

    public void clearCount() {
        this.written = 0L;
    }

    protected void incCount(int value) {
        long temp = this.written + (long)value;
        if (temp < 0L) {
            temp = Long.MAX_VALUE;
        }
        this.written = temp;
    }
}

