/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import javax.imageio.stream.ImageOutputStream;

public class IFFOutputStream
extends OutputStream {
    private byte[] writeBuffer = new byte[4];
    private Stack<Chunk> stack = new Stack();
    private ImageOutputStream out;
    private long streamOffset;

    public IFFOutputStream(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
    }

    public void pushCompositeChunk(String compositeType, String chunkType) throws IOException {
        this.stack.push(new CompositeChunk(compositeType, chunkType));
    }

    public void pushDataChunk(String chunkType) throws IOException {
        this.stack.push(new DataChunk(chunkType));
    }

    public void popChunk() throws IOException {
        Chunk chunk = this.stack.pop();
        chunk.finish();
    }

    public void finish() throws IOException {
        while (!this.stack.empty()) {
            this.popChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public long getStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    public void seek(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    public void writeLONG(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 24);
        this.writeBuffer[1] = (byte)(v >>> 16);
        this.writeBuffer[2] = (byte)(v >>> 8);
        this.writeBuffer[3] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 4);
    }

    public void writeULONG(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 24);
        this.writeBuffer[1] = (byte)(v >>> 16);
        this.writeBuffer[2] = (byte)(v >>> 8);
        this.writeBuffer[3] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 4);
    }

    public void writeWORD(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 8);
        this.writeBuffer[1] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 2);
    }

    public void writeUWORD(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 8);
        this.writeBuffer[1] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 2);
    }

    public void writeUBYTE(int v) throws IOException {
        this.out.write(v);
    }

    public void writeTYPE(String s) throws IOException {
        if (s.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(s.getBytes("ASCII"), 0, 4);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeByteRun1(byte[] data) throws IOException {
        this.writeByteRun1(data, 0, data.length);
    }

    public void writeByteRun1(byte[] data, int offset, int length) throws IOException {
        int i;
        int end = offset + length;
        int literalOffset = offset;
        for (i = offset; i < end; ++i) {
            int repeatCount;
            byte b = data[i];
            for (repeatCount = i + 1; repeatCount < end && data[repeatCount] == b; ++repeatCount) {
            }
            if ((repeatCount -= i) == 1) {
                if (i - literalOffset <= 127) continue;
                this.write(i - literalOffset - 1);
                this.write(data, literalOffset, i - literalOffset);
                literalOffset = i;
                continue;
            }
            if (repeatCount == 2 && literalOffset < i && i - literalOffset < 127) {
                ++i;
                continue;
            }
            if (literalOffset < i) {
                this.write(i - literalOffset - 1);
                this.write(data, literalOffset, i - literalOffset);
            }
            literalOffset = (i += repeatCount - 1) + 1;
            while (repeatCount > 128) {
                this.write(-127);
                this.write(b);
                repeatCount -= 128;
            }
            this.write(-repeatCount + 1);
            this.write(b);
        }
        if (literalOffset < end) {
            this.write(i - literalOffset - 1);
            this.write(data, literalOffset, i - literalOffset);
        }
    }

    private class DataChunk
    extends Chunk {
        public DataChunk(String name) throws IOException {
            super(name);
            IFFOutputStream.this.out.writeLong(0L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long size = IFFOutputStream.this.getStreamPosition() - this.offset;
                if (size > 0xFFFFFFFFL) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + size);
                }
                long pointer = IFFOutputStream.this.getStreamPosition();
                IFFOutputStream.this.seek(this.offset);
                IFFOutputStream.this.writeTYPE(this.chunkType);
                IFFOutputStream.this.writeULONG(size - 8L);
                IFFOutputStream.this.seek(pointer);
                if (size % 2L == 1L) {
                    IFFOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public boolean isComposite() {
            return false;
        }
    }

    private class CompositeChunk
    extends Chunk {
        protected String compositeType;

        public CompositeChunk(String compositeType, String chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            IFFOutputStream.this.out.writeLong(0L);
            IFFOutputStream.this.out.writeInt(0);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long size = IFFOutputStream.this.getStreamPosition() - this.offset;
                if (size > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + size);
                }
                long pointer = IFFOutputStream.this.getStreamPosition();
                IFFOutputStream.this.seek(this.offset);
                IFFOutputStream.this.writeTYPE(this.compositeType);
                IFFOutputStream.this.writeULONG(size - 8L);
                IFFOutputStream.this.writeTYPE(this.chunkType);
                IFFOutputStream.this.seek(pointer);
                if (size % 2L == 1L) {
                    IFFOutputStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public boolean isComposite() {
            return true;
        }
    }

    private abstract class Chunk {
        protected String chunkType;
        protected long offset;
        protected boolean finished;

        public Chunk(String chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = IFFOutputStream.this.getStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract boolean isComposite();
    }
}

