/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.monte.media.AbstractPlayer;
import org.monte.media.ColorCyclePlayer;
import org.monte.media.MovieControl;
import org.monte.media.anim.ANIMAudioCommand;
import org.monte.media.anim.ANIMDecoder;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieTrack;
import org.monte.media.gui.ImagePanel;
import org.monte.media.gui.JMovieControlAqua;
import org.monte.media.ilbm.ColorCycle;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.image.BitmapImage;
import org.monte.media.io.BoundedRangeInputStream;

public class ANIMPlayer
extends AbstractPlayer
implements ColorCyclePlayer {
    private ColorCyclingMemoryImageSource memoryImage;
    private BoundedRangeModel timeModel;
    private BoundedRangeInputStream cachingControlModel;
    private InputStream in;
    private int inputFileSize = -1;
    private ANIMMovieTrack track;
    private BitmapImage bitmapEven;
    private BitmapImage bitmapOdd;
    private int preparedEven;
    private int preparedOdd;
    private int fetchedEven;
    private int fetchedOdd;
    private int displayFrame = -1;
    private boolean isPlayEveryFrame = false;
    private volatile boolean isLoop = true;
    private float jiffieMillis = 16.666666f;
    private int globalFrameDuration = -1;
    private ImagePanel visualComponent;
    private MovieControl controlComponent;
    private Object decoderLock = new Object();
    private ColorModel preferredColorModel = null;
    private volatile boolean isCached = false;
    private ANIMAudioCommand[] audioChannels = new ANIMAudioCommand[4];
    private boolean isAudioEnabled = true;
    private boolean isLoadAudio;
    private boolean debug = false;
    private Hashtable properties;
    private boolean isAudioAvailable;
    private boolean isColorCyclingAvailable;
    private boolean isColorCyclingStarted;
    private boolean isPingPong = true;
    private int playDirection = 1;
    private Handler handler = new Handler();

    public ANIMPlayer(InputStream in) {
        this(in, -1, true);
    }

    public ANIMPlayer(InputStream in, int inputFileSize, boolean loadAudio) {
        this.in = in;
        this.inputFileSize = inputFileSize;
        this.isLoadAudio = loadAudio;
    }

    public void setPreferredColorModel(ColorModel cm) {
        if (this.bitmapEven == null) {
            this.preferredColorModel = cm;
        }
    }

    @Override
    public BoundedRangeModel getTimeModel() {
        return this.timeModel;
    }

    @Override
    public void setAudioEnabled(boolean newValue) {
        boolean oldValue = this.isAudioEnabled;
        this.isAudioEnabled = newValue;
        this.propertyChangeSupport.firePropertyChange("audioEnabled", oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean isAudioEnabled() {
        return this.isAudioEnabled;
    }

    public void setSwapSpeakers(boolean newValue) {
        boolean oldValue = this.track.isSwapSpeakers();
        this.track.setSwapSpeakers(newValue);
        this.propertyChangeSupport.firePropertyChange("swapSpeakers", oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSwapSpeakers() {
        return this.track.isSwapSpeakers();
    }

    @Override
    public BoundedRangeModel getCachingModel() {
        return this.cachingControlModel;
    }

    protected ImageProducer getImageProducer() {
        return this.memoryImage;
    }

    public ANIMMovieTrack getMovieTrack() {
        return this.track;
    }

    @Override
    public synchronized Component getVisualComponent() {
        if (this.visualComponent == null) {
            this.visualComponent = new ImagePanel();
            if (this.getImageProducer() != null) {
                this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
            }
            this.visualComponent.addMouseListener(this.handler);
        }
        return this.visualComponent;
    }

    @Override
    public synchronized Component getControlPanelComponent() {
        if (this.controlComponent == null) {
            this.controlComponent = new JMovieControlAqua();
            this.controlComponent.setPlayer(this);
        }
        return this.controlComponent.getComponent();
    }

    @Override
    protected void doUnrealized() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRealizing() {
        String s;
        ColorModel cm;
        this.timeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
        this.timeModel.addChangeListener(this.handler);
        this.cachingControlModel = new BoundedRangeInputStream(this.in);
        if (this.inputFileSize != -1) {
            this.cachingControlModel.setMaximum(this.inputFileSize);
        }
        this.track = new ANIMMovieTrack();
        this.track.addPropertyChangeListener(this.handler);
        ANIMPlayer aNIMPlayer = this;
        synchronized (aNIMPlayer) {
            if (this.controlComponent != null) {
                this.controlComponent.setPlayer(this);
            }
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    try {
                        ANIMDecoder decoder = new ANIMDecoder(ANIMPlayer.this.cachingControlModel);
                        decoder.produce(ANIMPlayer.this.track, 0, ANIMPlayer.this.isLoadAudio);
                        ANIMPlayer.this.isCached = true;
                        ANIMPlayer.this.cachingControlModel.setValue(ANIMPlayer.this.cachingControlModel.getMaximum());
                        ANIMPlayer.this.propertyChangeSupport.firePropertyChange("cached", Boolean.FALSE, Boolean.TRUE);
                        if (ANIMPlayer.this.track.getFrameCount() != 0) break block18;
                        Object object = ANIMPlayer.this.decoderLock;
                        synchronized (object) {
                            ANIMPlayer.this.setTargetState(-1);
                            ANIMPlayer.this.decoderLock.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        Object object = ANIMPlayer.this.decoderLock;
                        synchronized (object) {
                            if (ANIMPlayer.this.visualComponent != null) {
                                ANIMPlayer.this.visualComponent.setMessage(e.toString());
                            }
                            ANIMPlayer.this.setTargetState(-1);
                            ANIMPlayer.this.decoderLock.notifyAll();
                            e.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            ANIMPlayer.this.in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        t.start();
        Object object = this.decoderLock;
        synchronized (object) {
            while (this.track.getFrameCount() < 1 && this.getTargetState() != -1) {
                try {
                    this.decoderLock.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        int width = this.track.getWidth();
        int height = this.track.getHeight();
        int nbPlanes = this.track.getNbPlanes();
        int masking = this.track.getMasking();
        if (this.track.getFrameCount() > 0) {
            ANIMFrame frame = this.track.getFrame(0);
            cm = frame.getColorModel();
        } else {
            cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        this.bitmapEven = new BitmapImage(width, height, nbPlanes + (masking == 1 ? 1 : 0), cm);
        this.bitmapOdd = new BitmapImage(width, height, nbPlanes + (masking == 1 ? 1 : 0), cm);
        this.jiffieMillis = 1000.0f / (float)this.track.getJiffies();
        if (this.track.getColorCycles().isEmpty()) {
            this.bitmapEven.setPreferredChunkyColorModel(this.preferredColorModel);
            this.bitmapOdd.setPreferredChunkyColorModel(this.preferredColorModel);
        }
        this.properties = new Hashtable();
        this.properties.put("aspect", new Double((double)this.track.getXAspect() / (double)this.track.getYAspect()));
        Object comment = this.track.getProperty("comment");
        if (comment != null) {
            this.properties.put("comment", comment);
        }
        switch (this.track.getScreenMode()) {
            case 0: {
                s = "Indexed Colors";
                break;
            }
            case 1: {
                s = "Direct Colors";
                break;
            }
            case 2: {
                s = "EHB";
                break;
            }
            case 3: {
                s = "HAM 6";
                break;
            }
            case 4: {
                s = "HAM 8";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        this.properties.put("screenMode", s);
        this.properties.put("nbPlanes", "" + this.track.getNbPlanes());
        this.properties.put("jiffies", "" + this.track.getJiffies());
        this.properties.put("colorCycling", "" + this.track.getColorCycles().size());
        if (this.bitmapEven.isEnforceDirectColors()) {
            cm = this.preferredColorModel instanceof DirectColorModel ? this.preferredColorModel : new DirectColorModel(24, 0xFF0000, 65280, 255);
            this.memoryImage = new ColorCyclingMemoryImageSource(width, height, cm, new int[width * height], 0, width, this.properties);
        } else if (cm instanceof DirectColorModel) {
            this.memoryImage = new ColorCyclingMemoryImageSource(width, height, cm, new int[width * height], 0, width, this.properties);
        } else {
            this.memoryImage = new ColorCyclingMemoryImageSource(width, height, cm, new byte[width * height], 0, width, this.properties);
            if (this.track.getColorCycles().size() > 0) {
                for (ColorCycle cc : this.track.getColorCycles()) {
                    this.memoryImage.addColorCycle(cc);
                }
                if (this.isColorCyclingStarted()) {
                    this.memoryImage.start();
                }
            }
        }
        this.memoryImage.setAnimated(true);
        this.preparedOdd = Integer.MAX_VALUE;
        this.preparedEven = Integer.MAX_VALUE;
        this.fetchedOdd = Integer.MAX_VALUE;
        this.fetchedEven = Integer.MAX_VALUE;
        if (this.track.getFrameCount() > 0) {
            this.renderVideo(0);
            this.properties.put("renderMode", this.bitmapEven.getChunkyColorModel());
        }
        ANIMPlayer aNIMPlayer2 = this;
        synchronized (aNIMPlayer2) {
            if (this.visualComponent != null) {
                this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
            }
        }
    }

    @Override
    protected void doRealized() {
    }

    @Override
    protected void doPrefetching() {
        this.renderVideo(this.timeModel.getValue());
    }

    @Override
    protected void doPrefetched() {
    }

    public void setPlayEveryFrame(boolean newValue) {
        this.isPlayEveryFrame = newValue;
    }

    public void setPlayWrapupFrames(boolean newValue) {
        this.track.setPlayWrapupFrames(newValue);
        int count = this.track.getFrameCount();
        this.timeModel.setMaximum(count > 0 ? count - 1 : 0);
    }

    public void setDebug(boolean newValue) {
        this.debug = newValue;
        if (!newValue && this.visualComponent != null) {
            this.visualComponent.setMessage(null);
        }
    }

    public boolean isPlayWrapupFrames() {
        return this.track.isPlayWrapupFrames();
    }

    public void setFramesPerSecond(float framesPerSecond) {
        if (framesPerSecond <= 0.0f) {
            this.setGlobalFrameDuration(-1);
        } else {
            this.setGlobalFrameDuration((int)(1000.0f / framesPerSecond));
        }
    }

    public void setGlobalFrameDuration(int frameDuration) {
        this.globalFrameDuration = frameDuration;
    }

    public boolean isPlayEveryFrame() {
        return this.isPlayEveryFrame;
    }

    public void setLoop(boolean newValue) {
        boolean oldValue = this.isLoop;
        this.isLoop = newValue;
        this.propertyChangeSupport.firePropertyChange("isLoop", oldValue, newValue);
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public String getDeltaOperationDescription() {
        String s;
        int op = this.track.getDeltaOperation();
        switch (op) {
            case 0: {
                s = "OP Direct";
                break;
            }
            case 1: {
                s = "XOR";
                break;
            }
            case 2: {
                s = "Long Delta";
                break;
            }
            case 3: {
                s = "Short Delta";
                break;
            }
            case 4: {
                s = "General Delta";
                break;
            }
            case 5: {
                s = "Byte Vertical";
                break;
            }
            case 6: {
                s = "Stereo Delta";
                break;
            }
            case 7: {
                s = "Vertical";
                break;
            }
            case 8: {
                s = "Vertical";
                break;
            }
            case 74: {
                s = "Eric Graham's compression";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return s + " OP(" + op + ")";
    }

    @Override
    protected void doStarted() {
        long mediaTime = System.currentTimeMillis() + (long)this.jiffieMillis;
        if (this.timeModel.getValue() == this.timeModel.getMaximum()) {
            this.timeModel.setValue(this.timeModel.getMinimum());
        }
        while (this.getTargetState() == 5) {
            long sleepTime;
            int index = this.timeModel.getValue();
            if (this.isPlayEveryFrame) {
                if (this.isAudioEnabled) {
                    this.prepareAudio(index);
                }
                this.prepareVideo(index);
                if (mediaTime > System.currentTimeMillis() && (sleepTime = mediaTime - System.currentTimeMillis()) > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                mediaTime = this.globalFrameDuration == -1 ? System.currentTimeMillis() + (long)((float)Math.max(this.track.getFrameDuration(index), 1L) * this.jiffieMillis) : System.currentTimeMillis() + (long)this.globalFrameDuration;
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(index);
                } else {
                    this.muteAudio();
                }
                this.renderVideo(index);
            } else if (mediaTime > System.currentTimeMillis()) {
                if (this.isAudioEnabled) {
                    this.prepareAudio(index);
                }
                this.prepareVideo(index);
                sleepTime = mediaTime - System.currentTimeMillis();
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                mediaTime = this.globalFrameDuration == -1 ? (mediaTime += (long)((float)Math.max(this.track.getFrameDuration(index), 1L) * this.jiffieMillis)) : (mediaTime += (long)this.globalFrameDuration);
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(index);
                } else {
                    this.muteAudio();
                }
                this.renderVideo(index);
            } else {
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(index);
                } else {
                    this.muteAudio();
                }
                mediaTime = this.globalFrameDuration == -1 ? (mediaTime += (long)((float)Math.max(this.track.getFrameDuration(index), 1L) * this.jiffieMillis)) : (mediaTime += (long)this.globalFrameDuration);
            }
            if (this.timeModel.getValueIsAdjusting()) continue;
            if (this.timeModel.getValue() == this.timeModel.getMaximum()) {
                if (this.isCached && this.isLoop && !this.isPingPong) {
                    this.timeModel.setValue(this.timeModel.getMinimum());
                    continue;
                }
                if (!this.isCached || !this.isPingPong || this.playDirection != 1) break;
                this.playDirection = -1;
                this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
                continue;
            }
            if (this.timeModel.getValue() == this.timeModel.getMinimum() && this.isPingPong && this.playDirection == -1) {
                this.playDirection = 1;
                this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
                continue;
            }
            this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
        }
        this.renderVideo(this.timeModel.getValue());
        this.muteAudio();
    }

    private void muteAudio() {
        for (int i = 0; i < this.audioChannels.length; ++i) {
            if (this.audioChannels[i] == null) continue;
            this.audioChannels[i].stop(this.track);
            this.audioChannels[i] = null;
        }
    }

    @Override
    protected void doClosed() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fetchFrame(int index) {
        BitmapImage bitmap;
        int fetched;
        ANIMFrame frame = null;
        int interleave = this.track.getInterleave();
        if (interleave == 1 || (index & 1) == 0) {
            if (this.fetchedEven == index) {
                return;
            }
            fetched = this.fetchedEven;
            bitmap = this.bitmapEven;
            this.fetchedEven = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                fetched = 0;
            }
        } else {
            if (this.fetchedOdd == index) {
                return;
            }
            fetched = this.fetchedOdd;
            bitmap = this.bitmapOdd;
            this.fetchedOdd = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                frame = this.track.getFrame(1);
                frame.decode(bitmap, this.track);
                fetched = 1;
            }
        }
        for (int i = fetched + interleave; i <= index; i += interleave) {
            frame = this.track.getFrame(i);
            frame.decode(bitmap, this.track);
        }
    }

    private void prepareVideo(int index) {
        BitmapImage bitmap;
        int prepared;
        int interleave = this.track.getInterleave();
        if (interleave == 1 || (index & 1) == 0) {
            if (this.preparedEven == index) {
                return;
            }
            prepared = this.preparedEven;
            this.preparedEven = index;
            bitmap = this.bitmapEven;
        } else {
            if (this.preparedOdd == index) {
                return;
            }
            prepared = this.preparedOdd;
            this.preparedOdd = index;
            bitmap = this.bitmapOdd;
        }
        this.fetchFrame(index);
        ANIMFrame frame = this.track.getFrame(index);
        ColorModel cm = frame.getColorModel();
        bitmap.setPlanarColorModel(cm);
        if (prepared == index - interleave && (bitmap.getPixelType() == 1 || cm == this.track.getFrame(prepared).getColorModel())) {
            bitmap.convertToChunky(frame.getTopBound(this.track), frame.getLeftBound(this.track), frame.getBottomBound(this.track), frame.getRightBound(this.track));
        } else if (this.isPingPong && prepared == index + interleave && (bitmap.getPixelType() == 1 || cm == this.track.getFrame(prepared).getColorModel())) {
            frame = this.track.getFrame(index + interleave);
            bitmap.convertToChunky(frame.getTopBound(this.track), frame.getLeftBound(this.track), frame.getBottomBound(this.track), frame.getRightBound(this.track));
        } else {
            bitmap.convertToChunky();
        }
    }

    private void prepareAudio(int index) {
        ANIMFrame frame = this.track.getFrame(index);
        ANIMAudioCommand[] audioCommands = frame.getAudioCommands();
        if (audioCommands != null) {
            for (int i = 0; i < audioCommands.length; ++i) {
                audioCommands[i].prepare(this.track);
            }
        }
    }

    private void renderVideo(int index) {
        if (this.displayFrame == index) {
            return;
        }
        int interleave = this.track.getInterleave();
        BitmapImage bitmap = interleave == 1 || (index & 1) == 0 ? this.bitmapEven : this.bitmapOdd;
        this.prepareVideo(index);
        ColorModel cm = bitmap.getChunkyColorModel();
        if (bitmap.getPixelType() == 2) {
            this.memoryImage.newPixels(bitmap.getIntPixels(), cm, 0, this.track.getWidth());
        } else {
            this.memoryImage.newPixels(bitmap.getBytePixels(), cm, 0, this.track.getWidth());
        }
        this.displayFrame = index;
        if (this.debug && this.visualComponent != null) {
            ANIMFrame frame = this.track.getFrame(index);
            StringBuilder buf = new StringBuilder();
            buf.append("frame:");
            buf.append(index);
            buf.append(" duration:");
            buf.append(frame.getRelTime());
            buf.append(", anim op:");
            buf.append(frame.getOperation());
            ANIMAudioCommand[] audioCommands = frame.getAudioCommands();
            if (audioCommands != null) {
                for (int i = 0; i < audioCommands.length; ++i) {
                    switch (audioCommands[i].getCommand()) {
                        case 1: {
                            buf.append("\nplay");
                            break;
                        }
                        case 2: {
                            buf.append("\nstop");
                            break;
                        }
                        case 3: {
                            buf.append("\nfreqvol");
                            break;
                        }
                        default: {
                            buf.append("ILLEGAL COMMAND:");
                            buf.append(audioCommands[i].getCommand());
                        }
                    }
                    buf.append(" sound:");
                    buf.append(audioCommands[i].getSound());
                    buf.append(" freq:");
                    buf.append(audioCommands[i].getFrequency());
                    buf.append(" vol:");
                    buf.append(audioCommands[i].getVolume());
                    buf.append(" channels:");
                    int channelMask = audioCommands[i].getChannelMask();
                    boolean first = true;
                    for (int j = 0; j < 4; ++j) {
                        if ((1 << j & channelMask) == 0) continue;
                        if (!first) {
                            buf.append(", ");
                        }
                        buf.append(j);
                        buf.append(j % 2 == 0 ? "(l)" : "(r)");
                        first = false;
                    }
                }
            }
            this.visualComponent.setMessage(buf.toString());
        }
    }

    private synchronized void renderAudio(int index) {
        ANIMFrame frame;
        ANIMAudioCommand[] audioCommands;
        this.prepareAudio(index);
        if (this.isActive() && (audioCommands = (frame = this.track.getFrame(index)).getAudioCommands()) != null) {
            for (int i = 0; i < audioCommands.length; ++i) {
                audioCommands[i].doCommand(this.track, this.audioChannels);
            }
        }
    }

    @Override
    public long getTotalDuration() {
        if (this.globalFrameDuration == -1) {
            return (long)((float)this.track.getTotalDuration() * this.jiffieMillis);
        }
        return this.track.getFrameCount() * this.globalFrameDuration;
    }

    @Override
    public boolean isCached() {
        return this.isCached;
    }

    @Override
    public boolean isAudioAvailable() {
        return this.isAudioAvailable;
    }

    private void setAudioAvailable(boolean newValue) {
        boolean oldValue = this.isAudioAvailable;
        this.isAudioAvailable = newValue;
        this.propertyChangeSupport.firePropertyChange("audioAvailable", oldValue, newValue);
    }

    public void setPingPong(boolean newValue) {
        boolean oldValue = this.isPingPong;
        this.isPingPong = newValue;
        if (!newValue) {
            this.playDirection = 1;
        }
        this.propertyChangeSupport.firePropertyChange("pingPong", oldValue, newValue);
    }

    public boolean isPingPong() {
        return this.isPingPong;
    }

    private void setColorCyclingAvailable(boolean newValue) {
        boolean oldValue = this.isColorCyclingAvailable;
        this.isColorCyclingAvailable = newValue;
        this.propertyChangeSupport.firePropertyChange("colorCyclingAvailable", oldValue, newValue);
    }

    @Override
    public boolean isColorCyclingStarted() {
        return this.isColorCyclingStarted;
    }

    @Override
    public void setColorCyclingStarted(boolean newValue) {
        boolean oldValue = this.isColorCyclingStarted;
        this.isColorCyclingStarted = newValue;
        if (this.memoryImage != null) {
            this.memoryImage.setColorCyclingStarted(newValue);
            this.propertyChangeSupport.firePropertyChange("colorCyclingStarted", oldValue, newValue);
        }
    }

    @Override
    public boolean isColorCyclingAvailable() {
        return this.isColorCyclingAvailable;
    }

    @Override
    public void setBlendedColorCycling(boolean newValue) {
        if (this.memoryImage != null) {
            boolean oldValue = this.memoryImage.isBlendedColorCycling();
            this.memoryImage.setBlendedColorCycling(newValue);
            this.propertyChangeSupport.firePropertyChange("blendedColorCycling", oldValue, newValue);
        }
    }

    @Override
    public boolean isBlendedColorCycling() {
        return this.memoryImage == null ? false : this.memoryImage.isBlendedColorCycling();
    }

    private class Handler
    implements MouseListener,
    PropertyChangeListener,
    ChangeListener {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (ANIMPlayer.this.getState() != -1 && event.getModifiers() == 16) {
                if (ANIMPlayer.this.getState() == 5 && ANIMPlayer.this.getTargetState() == 5 && event.getClickCount() == 1) {
                    ANIMPlayer.this.stop();
                } else if (ANIMPlayer.this.getState() != 5 && ANIMPlayer.this.getTargetState() != 5 && event.getClickCount() == 2) {
                    ANIMPlayer.this.start();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (ANIMPlayer.this.timeModel != null) {
                int count = ANIMPlayer.this.track.getFrameCount();
                ANIMPlayer.this.timeModel.setMaximum(count > 0 ? count - 1 : 0);
                Object object = ANIMPlayer.this.decoderLock;
                synchronized (object) {
                    ANIMPlayer.this.decoderLock.notifyAll();
                }
            }
            if (event.getPropertyName().equals("audioClipCount")) {
                ANIMPlayer.this.setAudioAvailable(ANIMPlayer.this.track.getAudioClipCount() > 0);
            } else if (event.getPropertyName().equals("colorCyclesCount")) {
                ANIMPlayer.this.setColorCyclingAvailable(ANIMPlayer.this.track.getColorCyclesCount() > 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == ANIMPlayer.this.timeModel) {
                if (ANIMPlayer.this.getState() == 5) {
                    Handler handler = this;
                    synchronized (handler) {
                        this.notifyAll();
                    }
                } else {
                    ANIMPlayer.this.dispatcher.dispatch(new Runnable(){

                        @Override
                        public void run() {
                            ANIMPlayer.this.renderVideo(ANIMPlayer.this.getTimeModel().getValue());
                        }
                    });
                }
            }
        }
    }
}

