/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.File;
import java.io.IOException;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Multiplexer;
import org.monte.media.anim.ANIMOutputStream;
import org.monte.media.image.BitmapImage;
import org.monte.media.math.Rational;

public class ANIMMultiplexer
extends ANIMOutputStream
implements Multiplexer {
    protected Rational inputTime;

    public ANIMMultiplexer(File file) throws IOException {
        super(file);
    }

    @Override
    public void write(int trackIndex, Buffer buf) throws IOException {
        if (!buf.isFlag(BufferFlag.DISCARD)) {
            long jiffies = this.getJiffies();
            if (this.inputTime == null) {
                this.inputTime = new Rational(0L, 1L);
            }
            this.inputTime = this.inputTime.add(buf.sampleDuration.multiply(buf.sampleCount));
            Rational outputTime = new Rational(this.getMovieTime(), jiffies);
            Rational outputDuration = this.inputTime.subtract(outputTime);
            outputDuration = outputDuration.round(jiffies);
            int outputMediaDuration = Math.max(1, (int)(outputDuration.getNumerator() * jiffies / outputDuration.getDenominator()));
            outputTime = outputTime.add(new Rational(outputMediaDuration, jiffies));
            this.writeFrame((BitmapImage)buf.data, outputMediaDuration);
        }
    }
}

