/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.mpo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.jpeg.JFIFInputStream;
import org.monte.media.jpeg.JFIFOutputStream;

public class MPOFiles {
    private MPOFiles() {
    }

    public static ArrayList<File> splitMPOFile(File f) throws IOException {
        int imgCount = 0;
        ArrayList<File> splittedFiles = new ArrayList<File>();
        JFIFOutputStream out = null;
        byte[] buf = new byte[2048];
        JFIFInputStream in = new JFIFInputStream(f);
        JFIFInputStream.Segment seg = in.getNextSegment();
        while (seg != null) {
            block9: {
                block11: {
                    block10: {
                        int n;
                        int count;
                        block8: {
                            String ext;
                            if (seg.marker != 65496) break block8;
                            switch (imgCount++) {
                                case 0: {
                                    ext = "_l.JPG";
                                    break;
                                }
                                case 1: {
                                    ext = "_r.JPG";
                                    break;
                                }
                                default: {
                                    ext = "_" + imgCount + ".JPG";
                                }
                            }
                            String name = f.getName();
                            int p = name.lastIndexOf(46);
                            if (p == -1) {
                                p = name.length();
                            }
                            File imgFile = new File(f.getParentFile(), name.substring(0, p) + ext);
                            splittedFiles.add(imgFile);
                            out = new JFIFOutputStream(imgFile);
                            out.pushSegment(seg.marker);
                            out.popSegment();
                            break block9;
                        }
                        if (out == null) break block9;
                        if (seg.marker != 65506) break block10;
                        int len = 4;
                        int off = 0;
                        for (n = 0; n < len && (count = in.read(buf, off + n, len - n)) >= 0; n += count) {
                        }
                        if (n == 4 && (buf[0] & 0xFF) == 77 && (buf[1] & 0xFF) == 80 && (buf[2] & 0xFF) == 70 && buf[3] == 0) break block9;
                        out.pushSegment(seg.marker);
                        out.write(buf, 0, n);
                        break block11;
                    }
                    out.pushSegment(seg.marker);
                }
                int len = in.read(buf, 0, buf.length);
                while (len != -1) {
                    out.write(buf, 0, len);
                    len = in.read(buf, 0, buf.length);
                }
                out.popSegment();
            }
            seg = in.getNextSegment();
        }
        return splittedFiles;
    }
}

