/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.converter;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;

public class FrameRateConverter
extends AbstractVideoCodec {
    private Rational inputTime;
    private Rational outputTime;

    public FrameRateConverter() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class, VideoFormatKeys.FixedFrameRateKey, false})});
        this.name = "Frame Rate Converter";
    }

    @Override
    public Format[] getOutputFormats(Format input) {
        Format forceVFR = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, "image", VideoFormatKeys.DataClassKey, BufferedImage.class, VideoFormatKeys.FixedFrameRateKey, false});
        ArrayList<Format> of = new ArrayList<Format>(this.outputFormats.length);
        for (Format f : this.outputFormats) {
            of.add(forceVFR.append(f.append(input)));
        }
        return of.toArray(new Format[of.size()]);
    }

    @Override
    public Format setOutputFormat(Format f) {
        Format forceFFR = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, "image", VideoFormatKeys.DataClassKey, BufferedImage.class, VideoFormatKeys.FixedFrameRateKey, true});
        Format forceVFR = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, "image", VideoFormatKeys.DataClassKey, BufferedImage.class, VideoFormatKeys.FixedFrameRateKey, false});
        for (Format sf : this.getOutputFormats(f)) {
            if (!sf.matches(f) && !forceFFR.append(sf).matches(f) && !forceVFR.append(sf).matches(f)) continue;
            this.outputFormat = forceVFR.append(f);
            return sf;
        }
        this.outputFormat = null;
        return null;
    }

    @Override
    public void reset() {
        this.inputTime = null;
        this.outputTime = null;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        if (this.inputTime == null) {
            this.inputTime = new Rational(0L, 1L);
            this.outputTime = new Rational(0L, 1L);
        }
        Format vf = this.outputFormat;
        this.inputTime = this.inputTime.add(in.sampleDuration);
        Rational outputDuration = this.inputTime.subtract(this.outputTime);
        long jiffies = ((Rational)vf.get(VideoFormatKeys.FrameRateKey)).getNumerator();
        outputDuration = outputDuration.round(jiffies);
        long outputMediaDuration = (int)(outputDuration.getNumerator() * jiffies / outputDuration.getDenominator());
        long remainder = outputMediaDuration % ((Rational)vf.get(VideoFormatKeys.FrameRateKey)).getDenominator();
        outputDuration = new Rational(outputMediaDuration, jiffies);
        if (outputDuration.isLessOrEqualZero()) {
            out.setFlag(BufferFlag.DISCARD, true);
            out.sampleDuration = outputDuration;
            return 0;
        }
        out.format = this.outputFormat;
        out.setDataTo(in);
        out.timeStamp = this.outputTime;
        out.sampleDuration = outputDuration;
        this.outputTime = this.outputTime.add(outputDuration);
        return 0;
    }
}

