/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.binary;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.monte.media.binary.BinaryModel;
import org.monte.media.binary.ByteArrayBinaryModel;

public class BinaryPanel
extends JComponent {
    public static final Color[] HIGHLIGHT_COLORS = new Color[]{new Color(16741740), new Color(16430421), new Color(15916890), new Color(12442714), new Color(13344222), new Color(6730239), new Color(0xB5B5B5)};
    private BinaryModel model_;
    private final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private ArrayList<Highlight> highlights = new ArrayList();

    public BinaryPanel() {
        this.model_ = new ByteArrayBinaryModel();
        this.updateUI();
        this.setToolTipText("Hi");
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension d = new Dimension(fm.charWidth('0') * 68, (int)((long)fm.getHeight() * (this.model_.getLength() + 15L) / 16L));
        return d;
    }

    public void setModel(BinaryModel m) {
        this.model_ = m;
        this.revalidate();
        this.repaint();
    }

    public BinaryModel getModel() {
        return this.model_;
    }

    public void clearHighlights() {
        this.highlights.clear();
    }

    public void addHighlight(int from, int to) {
        this.addHighlight(from, to, HIGHLIGHT_COLORS[2], null);
    }

    public void addHighlight(int from, int to, Color c, String label) {
        this.highlights.add(new Highlight(from, to, c, label));
    }

    public void addHighlight(Highlight h) {
        this.highlights.add(h);
    }

    public void addHighlights(List<Highlight> h) {
        if (h != null) {
            this.highlights.addAll(h);
        }
    }

    public void setHighlights(List<Highlight> h) {
        this.clearHighlights();
        this.addHighlights(h);
    }

    private int getOffsetAt(int x, int y) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int row = y / fm.getHeight();
        int column = x / fm.getWidths()[48];
        int offset = column < 10 ? -1 : (column < 18 ? row * 16 + (column - 10) / 2 : (column < 19 ? -1 : (column < 27 ? row * 16 + (column - 11) / 2 : (column < 28 ? -1 : (column < 36 ? row * 16 + (column - 12) / 2 : (column < 37 ? -1 : (column < 45 ? row * 16 + (column - 13) / 2 : (column < 48 ? -1 : (column < 52 ? row * 16 + (column - 48) : (column < 53 ? -1 : (column < 57 ? row * 16 + (column - 49) : (column < 58 ? -1 : (column < 62 ? row * 16 + (column - 50) : (column < 63 ? -1 : (column < 67 ? row * 16 + (column - 51) : -1)))))))))))))));
        return offset;
    }

    private Highlight getHighlightAt(int x, int y) {
        int offset = this.getOffsetAt(x, y);
        if (offset == -1) {
            return null;
        }
        for (int i = this.highlights.size() - 1; i >= 0; --i) {
            Highlight hl = this.highlights.get(i);
            if (hl.from > (long)offset || hl.to <= (long)offset) continue;
            return hl;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics(this.getFont());
        g.setColor(this.getBackground());
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        g.setColor(this.getForeground());
        int endLine = Math.min((clipRect.y + clipRect.height) / fm.getHeight() + 1, (int)((this.model_.getLength() + 15L) / 16L));
        byte[] bytes = new byte[16];
        char[] chars = new char[69];
        for (int startLine = clipRect.y / fm.getHeight(); startLine < endLine; ++startLine) {
            Arrays.fill(chars, ' ');
            int offset = 0;
            int startOfData = 0;
            int address = startLine * 16;
            for (int i = 0; i < 8; ++i) {
                chars[offset++] = this.HEX[address >>> 28];
                address <<= 4;
            }
            chars[offset++] = 62;
            startOfData = ++offset;
            int len = this.model_.getBytes(startLine * 16, 16, bytes);
            for (int i = 0; i < len; ++i) {
                chars[offset++] = this.HEX[bytes[i] >>> 4 & 0xF];
                chars[offset++] = this.HEX[bytes[i] & 0xF];
                char ch = (char)(bytes[i] & 0xFF);
                int n = chars[i + 48 + i / 4] = Character.isISOControl(ch) ? 46 : (int)ch;
                if (i % 4 != 3) continue;
                ++offset;
            }
            String str = new String(chars);
            for (Highlight hl : this.highlights) {
                address = startLine * 16;
                if ((long)(address + 16) < hl.from || (long)address > hl.to) continue;
                int dataStart = (int)Math.max(0L, hl.from - (long)address);
                int dataEnd = (int)Math.max(0L, Math.min((long)(address + 16), hl.to) - (long)address);
                if (dataEnd <= dataStart) continue;
                int from = (int)fm.getStringBounds(str, 0, startOfData + dataStart * 2 + dataStart / 4, g).getWidth();
                int length = (int)fm.getStringBounds(str, startOfData + dataStart * 2 + dataStart / 4, startOfData + dataEnd * 2 + Math.max(0, (dataEnd - 1) / 4), g).getWidth();
                g.setColor(hl.color);
                g.fillRect(from + 1, startLine * fm.getHeight(), length - 2, fm.getAscent() + 1);
                from = (int)fm.getStringBounds(str, 0, startOfData + 38 + dataStart + dataStart / 4, g).getWidth();
                length = (int)fm.getStringBounds(str, startOfData + 38 + dataStart + dataStart / 4, startOfData + 38 + dataEnd + Math.max(0, (dataEnd - 1) / 4), g).getWidth();
                g.fillRect(from + 1, startLine * fm.getHeight(), length - 2, fm.getAscent() + 1);
            }
            g.setColor(this.getForeground());
            g.drawString(str, 0, startLine * fm.getHeight() + fm.getAscent());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setForeground(UIManager.getColor("TextArea.foreground"));
        if (UIManager.getLookAndFeel().getID().equals("MacOS")) {
            this.setFont(new Font("Monospaced", 0, 10));
        } else {
            this.setFont(new Font("Monospaced", 0, 12));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Highlight h = this.getHighlightAt(event.getX(), event.getY());
        return h == null ? null : h.label;
    }

    public static class Highlight {
        public final long from;
        public final long to;
        public final Color color;
        private final String label;

        public Highlight(long from, long to, Color c, String label) {
            this.from = from;
            this.to = to;
            this.color = c;
            this.label = label;
        }

        public String toString() {
            return "Highlight[" + this.label + ", " + this.from + ".." + this.to + ", color:" + Integer.toHexString(this.color.getRGB()) + "]";
        }
    }
}

