/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.monte.media.avi.DataChunkOutputStream;
import org.monte.media.avi.RunLengthCodec;
import org.monte.media.io.ImageOutputStreamAdapter;

public class AVIOutputStreamOLD {
    private ImageOutputStream out;
    private long streamOffset;
    private Object previousData;
    private AVIVideoFormat videoFormat;
    private float quality = 0.9f;
    private Date creationTime;
    private int imgWidth = -1;
    private int imgHeight = -1;
    private int imgDepth = 24;
    private IndexColorModel palette;
    private IndexColorModel previousPalette;
    private RunLengthCodec encoder;
    private int timeScale = 1;
    private int frameRate = 30;
    private int syncInterval = 30;
    private States state = States.FINISHED;
    private LinkedList<Sample> videoFrames;
    private CompositeChunk aviChunk;
    private CompositeChunk moviChunk;
    FixedSizeDataChunk avihChunk;
    FixedSizeDataChunk strhChunk;
    FixedSizeDataChunk strfChunk;

    public AVIOutputStreamOLD(File file, AVIVideoFormat format) throws IOException {
        this(file, format, 24);
    }

    public AVIOutputStreamOLD(File file, AVIVideoFormat format, int bitsPerPixel) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
        this.videoFormat = format;
        this.videoFrames = new LinkedList();
        this.imgDepth = bitsPerPixel;
        if (this.imgDepth == 4) {
            byte[] gray = new byte[16];
            for (int i = 0; i < gray.length; ++i) {
                gray[i] = (byte)(i << 4 | i);
            }
            this.palette = new IndexColorModel(4, 16, gray, gray, gray);
        } else if (this.imgDepth == 8) {
            byte[] gray = new byte[256];
            for (int i = 0; i < gray.length; ++i) {
                gray[i] = (byte)i;
            }
            this.palette = new IndexColorModel(8, 256, gray, gray, gray);
        }
    }

    public AVIOutputStreamOLD(ImageOutputStream out, AVIVideoFormat format) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.out = out;
        this.streamOffset = out.getStreamPosition();
        this.videoFormat = format;
        this.videoFrames = new LinkedList();
    }

    public void setTimeScale(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException("timeScale must be greater 0");
        }
        this.timeScale = newValue;
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public void setFrameRate(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException("frameDuration must be greater 0");
        }
        if (this.state == States.STARTED) {
            throw new IllegalStateException("frameDuration must be set before the first frame is written");
        }
        this.frameRate = newValue;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setPalette(IndexColorModel palette) {
        this.palette = palette;
    }

    public void setVideoCompressionQuality(float newValue) {
        this.quality = newValue;
    }

    public float getVideoCompressionQuality() {
        return this.quality;
    }

    public void setVideoDimension(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height must be greater zero.");
        }
        this.imgWidth = width;
        this.imgHeight = height;
    }

    public Dimension getVideoDimension() {
        if (this.imgWidth < 1 || this.imgHeight < 1) {
            return null;
        }
        return new Dimension(this.imgWidth, this.imgHeight);
    }

    private void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    public void writeFrame(BufferedImage image) throws IOException {
        DataChunk videoFrameChunk;
        this.ensureOpen();
        this.ensureStarted();
        if (this.imgWidth == -1) {
            this.imgWidth = image.getWidth();
            this.imgHeight = image.getHeight();
        } else if (this.imgWidth != image.getWidth() || this.imgHeight != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of image[" + this.videoFrames.size() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from image[0] (width=" + this.imgWidth + ", height=" + this.imgHeight);
        }
        long offset = this.getRelativeStreamPosition();
        boolean isSync = true;
        block0 : switch (this.videoFormat) {
            case RAW: {
                IndexColorModel imgPalette;
                switch (this.imgDepth) {
                    case 4: {
                        imgPalette = (IndexColorModel)image.getColorModel();
                        int[] imgRGBs = new int[16];
                        imgPalette.getRGBs(imgRGBs);
                        int[] previousRGBs = new int[16];
                        if (this.previousPalette == null) {
                            this.previousPalette = this.palette;
                        }
                        this.previousPalette.getRGBs(previousRGBs);
                        if (!Arrays.equals(imgRGBs, previousRGBs)) {
                            this.previousPalette = imgPalette;
                            DataChunk paletteChangeChunk = new DataChunk("00pc");
                            int first = 0;
                            int last = imgPalette.getMapSize() - 1;
                            DataChunkOutputStream pOut = paletteChangeChunk.getOutputStream();
                            pOut.writeByte(first);
                            pOut.writeByte(last - first + 1);
                            pOut.writeShort(0);
                            for (int i = first; i <= last; ++i) {
                                pOut.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                                pOut.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                                pOut.writeByte(imgRGBs[i] & 0xFF);
                                pOut.writeByte(0);
                            }
                            this.moviChunk.add(paletteChangeChunk);
                            paletteChangeChunk.finish();
                            long length = this.getRelativeStreamPosition() - offset;
                            this.videoFrames.add(new Sample(paletteChangeChunk.chunkType, 0, offset, length - 8L, false));
                            offset = this.getRelativeStreamPosition();
                        }
                        videoFrameChunk = new DataChunk("00db");
                        byte[] rgb8 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        byte[] rgb4 = new byte[this.imgWidth / 2];
                        for (int y = (this.imgHeight - 1) * this.imgWidth; y >= 0; y -= this.imgWidth) {
                            int x = 0;
                            int xx = 0;
                            int n = this.imgWidth;
                            while (x < n) {
                                rgb4[xx] = (byte)((rgb8[y + x] & 0xF) << 4 | rgb8[y + x + 1] & 0xF);
                                x += 2;
                                ++xx;
                            }
                            videoFrameChunk.getOutputStream().write(rgb4);
                        }
                        break block0;
                    }
                    case 8: {
                        imgPalette = (IndexColorModel)image.getColorModel();
                        int[] imgRGBs = new int[256];
                        imgPalette.getRGBs(imgRGBs);
                        int[] previousRGBs = new int[256];
                        if (this.previousPalette == null) {
                            this.previousPalette = this.palette;
                        }
                        this.previousPalette.getRGBs(previousRGBs);
                        if (!Arrays.equals(imgRGBs, previousRGBs)) {
                            this.previousPalette = imgPalette;
                            DataChunk paletteChangeChunk = new DataChunk("00pc");
                            int first = 0;
                            int last = imgPalette.getMapSize() - 1;
                            DataChunkOutputStream pOut = paletteChangeChunk.getOutputStream();
                            pOut.writeByte(first);
                            pOut.writeByte(last - first + 1);
                            pOut.writeShort(0);
                            for (int i = first; i <= last; ++i) {
                                pOut.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                                pOut.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                                pOut.writeByte(imgRGBs[i] & 0xFF);
                                pOut.writeByte(0);
                            }
                            this.moviChunk.add(paletteChangeChunk);
                            paletteChangeChunk.finish();
                            long length = this.getRelativeStreamPosition() - offset;
                            this.videoFrames.add(new Sample(paletteChangeChunk.chunkType, 0, offset, length - 8L, false));
                            offset = this.getRelativeStreamPosition();
                        }
                        videoFrameChunk = new DataChunk("00db");
                        byte[] rgb8 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        for (int y = (this.imgHeight - 1) * this.imgWidth; y >= 0; y -= this.imgWidth) {
                            videoFrameChunk.getOutputStream().write(rgb8, y, this.imgWidth);
                        }
                        break block0;
                    }
                    default: {
                        videoFrameChunk = new DataChunk("00db");
                        WritableRaster raster = image.getRaster();
                        int[] raw = new int[this.imgWidth * 3];
                        byte[] bytes = new byte[this.imgWidth * 3];
                        for (int y = this.imgHeight - 1; y >= 0; --y) {
                            raster.getPixels(0, y, this.imgWidth, 1, raw);
                            int n = this.imgWidth * 3;
                            for (int x = 0; x < n; x += 3) {
                                bytes[x + 2] = (byte)raw[x];
                                bytes[x + 1] = (byte)raw[x + 1];
                                bytes[x] = (byte)raw[x + 2];
                            }
                            videoFrameChunk.getOutputStream().write(bytes);
                        }
                        break block0;
                    }
                }
            }
            case RLE: {
                IndexColorModel imgPalette;
                if (this.encoder == null) {
                    this.encoder = new RunLengthCodec();
                }
                isSync = this.videoFrames.size() % this.syncInterval == 0;
                switch (this.imgDepth) {
                    case 4: {
                        throw new UnsupportedOperationException("RLE 4-bit not implemented.");
                    }
                    case 8: {
                        imgPalette = (IndexColorModel)image.getColorModel();
                        int[] imgRGBs = new int[256];
                        imgPalette.getRGBs(imgRGBs);
                        int[] previousRGBs = new int[256];
                        if (this.previousPalette == null) {
                            this.previousPalette = this.palette;
                        }
                        this.previousPalette.getRGBs(previousRGBs);
                        if (!Arrays.equals(imgRGBs, previousRGBs)) {
                            isSync = true;
                            this.previousPalette = imgPalette;
                            DataChunk paletteChangeChunk = new DataChunk("00pc");
                            int first = 0;
                            int last = imgPalette.getMapSize() - 1;
                            DataChunkOutputStream pOut = paletteChangeChunk.getOutputStream();
                            pOut.writeByte(first);
                            pOut.writeByte(last - first + 1);
                            pOut.writeShort(0);
                            for (int i = first; i <= last; ++i) {
                                pOut.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                                pOut.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                                pOut.writeByte(imgRGBs[i] & 0xFF);
                                pOut.writeByte(0);
                            }
                            this.moviChunk.add(paletteChangeChunk);
                            paletteChangeChunk.finish();
                            long length = this.getRelativeStreamPosition() - offset;
                            this.videoFrames.add(new Sample(paletteChangeChunk.chunkType, 0, offset, length - 8L, false));
                            offset = this.getRelativeStreamPosition();
                        }
                        videoFrameChunk = new DataChunk("00dc");
                        byte[] rgb8 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        if (isSync) {
                            this.encoder.writeKey8(videoFrameChunk.getOutputStream(), rgb8, 0, this.imgWidth, this.imgWidth, this.imgHeight);
                        } else {
                            this.encoder.writeDelta8(videoFrameChunk.getOutputStream(), rgb8, (byte[])this.previousData, 0, this.imgWidth, this.imgWidth, this.imgHeight);
                        }
                        if (this.previousData == null) {
                            this.previousData = new byte[rgb8.length];
                        }
                        System.arraycopy(rgb8, 0, this.previousData, 0, rgb8.length);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("RLE only supports 4-bit and 8-bit video.");
            }
            case JPG: {
                videoFrameChunk = new DataChunk("00dc");
                ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
                ImageWriteParam iwParam = iw.getDefaultWriteParam();
                iwParam.setCompressionMode(2);
                iwParam.setCompressionQuality(this.quality);
                MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(videoFrameChunk.getOutputStream());
                iw.setOutput(imgOut);
                IIOImage img = new IIOImage(image, null, null);
                iw.write(null, img, iwParam);
                iw.dispose();
                break;
            }
            default: {
                videoFrameChunk = new DataChunk("00dc");
                ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/png").next();
                ImageWriteParam iwParam = iw.getDefaultWriteParam();
                MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(videoFrameChunk.getOutputStream());
                iw.setOutput(imgOut);
                IIOImage img = new IIOImage(image, null, null);
                iw.write(null, img, iwParam);
                iw.dispose();
                break;
            }
        }
        long length = this.getRelativeStreamPosition() - offset;
        this.moviChunk.add(videoFrameChunk);
        videoFrameChunk.finish();
        this.videoFrames.add(new Sample(videoFrameChunk.chunkType, this.frameRate, offset, length - 8L, isSync));
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.writeFrame(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void writeFrame(InputStream in) throws IOException {
        int len;
        this.ensureOpen();
        this.ensureStarted();
        DataChunk videoFrameChunk = new DataChunk(this.videoFormat == AVIVideoFormat.RAW ? "00db" : "00dc");
        this.moviChunk.add(videoFrameChunk);
        DataChunkOutputStream mdatOut = videoFrameChunk.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        videoFrameChunk.finish();
        this.videoFrames.add(new Sample(videoFrameChunk.chunkType, this.frameRate, offset, length - 8L, true));
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                throw new IllegalStateException("image width and height must be specified");
            }
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
            this.imgHeight = -1;
            this.imgWidth = -1;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    private void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new CompositeChunk("RIFF", "AVI ");
        CompositeChunk hdrlChunk = new CompositeChunk("LIST", "hdrl");
        this.aviChunk.add(hdrlChunk);
        this.avihChunk = new FixedSizeDataChunk("avih", 56L);
        this.avihChunk.seekToEndOfChunk();
        hdrlChunk.add(this.avihChunk);
        CompositeChunk strlChunk = new CompositeChunk("LIST", "strl");
        hdrlChunk.add(strlChunk);
        this.strhChunk = new FixedSizeDataChunk("strh", 56L);
        this.strhChunk.seekToEndOfChunk();
        strlChunk.add(this.strhChunk);
        this.strfChunk = new FixedSizeDataChunk("strf", this.palette == null ? 40L : (long)(40 + this.palette.getMapSize() * 4));
        this.strfChunk.seekToEndOfChunk();
        strlChunk.add(this.strfChunk);
        this.moviChunk = new CompositeChunk("LIST", "movi");
        this.aviChunk.add(this.moviChunk);
    }

    private void writeEpilog() throws IOException {
        int duration = 0;
        for (Sample s : this.videoFrames) {
            duration += s.duration;
        }
        long bufferSize = 0L;
        for (Sample s : this.videoFrames) {
            if (s.length <= bufferSize) continue;
            bufferSize = s.length;
        }
        DataChunk idx1Chunk = new DataChunk("idx1");
        this.aviChunk.add(idx1Chunk);
        DataChunkOutputStream d = idx1Chunk.getOutputStream();
        long moviListOffset = this.moviChunk.offset + 8L;
        for (Sample f : this.videoFrames) {
            d.writeType(f.chunkType);
            d.writeUInt((f.chunkType.endsWith("pc") ? 256 : 0) | (f.isSync ? 16 : 0));
            d.writeUInt(f.offset - moviListOffset);
            d.writeUInt(f.length);
        }
        idx1Chunk.finish();
        this.avihChunk.seekToStartOfData();
        d = this.avihChunk.getOutputStream();
        d.writeUInt(1000000L * (long)this.timeScale / (long)this.frameRate);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(16L);
        d.writeUInt(this.videoFrames.size());
        d.writeUInt(0L);
        d.writeUInt(1L);
        d.writeUInt(bufferSize);
        d.writeUInt(this.imgWidth);
        d.writeUInt(this.imgHeight);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        d.writeUInt(0L);
        this.strhChunk.seekToStartOfData();
        d = this.strhChunk.getOutputStream();
        d.writeType("vids");
        switch (this.videoFormat) {
            case RAW: {
                d.writeType("DIB ");
                break;
            }
            case RLE: {
                d.writeType("RLE ");
                break;
            }
            case JPG: {
                d.writeType("MJPG");
                break;
            }
            default: {
                d.writeType("png ");
            }
        }
        if (this.imgDepth <= 8) {
            d.writeUInt(65536L);
        } else {
            d.writeUInt(0L);
        }
        d.writeUShort(0);
        d.writeUShort(0);
        d.writeUInt(0L);
        d.writeUInt(this.timeScale);
        d.writeUInt(this.frameRate);
        d.writeUInt(0L);
        d.writeUInt(this.videoFrames.size());
        d.writeUInt(bufferSize);
        d.writeInt(-1);
        d.writeUInt(0L);
        d.writeUShort(0);
        d.writeUShort(0);
        d.writeUShort(this.imgWidth);
        d.writeUShort(this.imgHeight);
        this.strfChunk.seekToStartOfData();
        d = this.strfChunk.getOutputStream();
        d.writeUInt(40L);
        d.writeInt(this.imgWidth);
        d.writeInt(this.imgHeight);
        d.writeShort(1);
        d.writeShort(this.imgDepth);
        switch (this.videoFormat) {
            default: {
                d.writeInt(0);
                break;
            }
            case RLE: {
                if (this.imgDepth == 8) {
                    d.writeInt(1);
                    break;
                }
                if (this.imgDepth == 4) {
                    d.writeInt(2);
                    break;
                }
                throw new UnsupportedOperationException("RLE only supports 4-bit and 8-bit images");
            }
            case JPG: {
                d.writeType("MJPG");
                break;
            }
            case PNG: {
                d.writeType("png ");
            }
        }
        switch (this.videoFormat) {
            case RAW: {
                d.writeInt(0);
                break;
            }
            default: {
                if (this.imgDepth == 4) {
                    d.writeInt(this.imgWidth * this.imgHeight / 2);
                    break;
                }
                int bytesPerPixel = Math.max(1, this.imgDepth / 8);
                d.writeInt(this.imgWidth * this.imgHeight * bytesPerPixel);
            }
        }
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(this.palette == null ? 0 : this.palette.getMapSize());
        d.writeInt(0);
        if (this.palette != null) {
            int n = this.palette.getMapSize();
            for (int i = 0; i < n; ++i) {
                d.write(this.palette.getBlue(i));
                d.write(this.palette.getGreen(i));
                d.write(this.palette.getRed(i));
                d.write(0);
            }
        }
        this.aviChunk.finish();
    }

    private class FixedSizeDataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;
        private long fixedSize;

        public FixedSizeDataChunk(String chunkType, long fixedSize) throws IOException {
            super(chunkType);
            this.fixedSize = fixedSize;
            this.data = new DataChunkOutputStream(new ImageOutputStreamAdapter(AVIOutputStreamOLD.this.out), false);
            this.data.writeType(chunkType);
            this.data.writeUInt(fixedSize);
            this.data.clearCount();
            byte[] buf = new byte[(int)Math.min(512L, fixedSize)];
            for (long written = 0L; written < fixedSize; written += Math.min((long)buf.length, fixedSize - written)) {
                this.data.write(buf, 0, (int)Math.min((long)buf.length, fixedSize - written));
            }
            if (fixedSize % 2L == 1L) {
                AVIOutputStreamOLD.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public DataChunkOutputStream getOutputStream() {
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        public void seekToStartOfData() throws IOException {
            AVIOutputStreamOLD.this.seekRelative(this.offset + 8L);
            this.data.clearCount();
        }

        public void seekToEndOfChunk() throws IOException {
            AVIOutputStreamOLD.this.seekRelative(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    private class DataChunk
    extends Chunk {
        private DataChunkOutputStream data;
        private boolean finished;

        public DataChunk(String name) throws IOException {
            super(name);
            AVIOutputStreamOLD.this.out.writeLong(0L);
            this.data = new DataChunkOutputStream(new ImageOutputStreamAdapter(AVIOutputStreamOLD.this.out), false);
        }

        public DataChunkOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                System.out.println("sizeBefore:" + sizeBefore);
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AVIOutputStreamOLD.this.getRelativeStreamPosition();
                AVIOutputStreamOLD.this.seekRelative(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new ImageOutputStreamAdapter(AVIOutputStreamOLD.this.out), false);
                headerData.writeType(this.chunkType);
                headerData.writeUInt(this.size() - 8L);
                AVIOutputStreamOLD.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AVIOutputStreamOLD.this.out.writeByte(0);
                }
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    private class CompositeChunk
    extends Chunk {
        protected String compositeType;
        private LinkedList<Chunk> children;
        private boolean finished;

        public CompositeChunk(String compositeType, String chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            AVIOutputStreamOLD.this.out.writeLong(0L);
            AVIOutputStreamOLD.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AVIOutputStreamOLD.this.getRelativeStreamPosition();
                AVIOutputStreamOLD.this.seekRelative(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new ImageOutputStreamAdapter(AVIOutputStreamOLD.this.out), false);
                headerData.writeType(this.compositeType);
                headerData.writeUInt(this.size() - 8L);
                headerData.writeType(this.chunkType);
                for (Chunk child : this.children) {
                    child.finish();
                }
                AVIOutputStreamOLD.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AVIOutputStreamOLD.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 12L;
            for (Chunk child : this.children) {
                length += child.size() + child.size() % 2L;
            }
            return length;
        }
    }

    private abstract class Chunk {
        protected String chunkType;
        protected long offset;

        public Chunk(String chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = AVIOutputStreamOLD.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    private static class Sample {
        String chunkType;
        long offset;
        long length;
        int duration;
        boolean isSync;

        public Sample(String chunkId, int duration, long offset, long length, boolean isSync) {
            this.chunkType = chunkId;
            this.duration = duration;
            this.offset = offset;
            this.length = length;
            this.isSync = isSync;
        }
    }

    private static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }

    public static enum AVIVideoFormat {
        RAW,
        RLE,
        JPG,
        PNG;

    }
}

