/*
 * @(#)MovieConverterXMain.java  1.0  2011-09-04
 * 
 * Copyright (c) 2011 Werner Randelshofer, Goldau, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package org.monte.movieconverter;

import org.monte.media.DefaultMovie;
import org.monte.media.Movie;
import org.monte.media.MovieReader;
import org.monte.media.Registry;
import org.monte.media.gui.Worker;
import org.monte.media.gui.datatransfer.DropFileTransferHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;

/**
 * MovieConverterXMain.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-09-04 Created.
 */
public class MovieConverterXMain extends javax.swing.JFrame {

    private class Handler implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            File f=new File(e.getActionCommand());
            if (isEnabled())
            setMovieFile(f);
        }
        
    }
    private Handler handler=new Handler();
    
    /** Creates new form MovieConverterXMain */
    public MovieConverterXMain() {
        initComponents();
        DropFileTransferHandler dfth=new DropFileTransferHandler(JFileChooser.FILES_ONLY);
        dfth.setActionListener(handler);
        setTransferHandler(dfth);
        movieConverterPanel.setTransferHandler(dfth);
    }
    
    public void setMovieFile(final File newFile) {
        setEnabled(false);
        setTitle(null);
        getRootPane().putClientProperty("Window.documentFile", null);
        new Worker<Movie>() {

            @Override
            protected Movie construct() throws Exception {
                
                MovieReader r=Registry.getInstance().getReader(newFile);
                if (r==null)throw new IOException("no reader");
                DefaultMovie m=new DefaultMovie();
                m.setReader(r);
                return m;
            }

            @Override
            protected void done(Movie movie) {
        getRootPane().putClientProperty("Window.documentFile", newFile);
        setTitle(newFile.getName());
        movieConverterPanel.setMovie(movie);
            }

            @Override
            protected void finished() {
              setEnabled(true);
            }
            
            
        }.start();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        movieConverterPanel = new MovieConverterPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().add(movieConverterPanel, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            @Override
            public void run() {
                new MovieConverterXMain().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private MovieConverterPanel movieConverterPanel;
    // End of variables declaration//GEN-END:variables
}
