/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.multipartycall;

import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.VoiceUpdater;
import com.plivo.api.models.multipartycall.MultiPartyCallStartPlayAudioResponse;
import com.plivo.api.models.multipartycall.MultiPartyCallUtils;
import com.plivo.api.validators.UrlValues;
import com.plivo.api.validators.Validate;
import retrofit2.Call;

public class MultiPartyCallStartPlayAudio
extends VoiceUpdater<MultiPartyCallStartPlayAudioResponse> {
    @UrlValues
    private String url;

    public MultiPartyCallStartPlayAudio(String mpcId, String secondaryId) {
        super(mpcId, secondaryId);
    }

    @Override
    protected Call<MultiPartyCallStartPlayAudioResponse> obtainCall() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        Validate.check(this);
        return this.client().getVoiceApiService().mpcStartPlayAudio(this.client().getAuthId(), this.id, this.secondaryId, this);
    }

    @Override
    protected Call<MultiPartyCallStartPlayAudioResponse> obtainFallback1Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        Validate.check(this);
        return this.client().getVoiceFallback1Service().mpcStartPlayAudio(this.client().getAuthId(), this.id, this.secondaryId, this);
    }

    @Override
    protected Call<MultiPartyCallStartPlayAudioResponse> obtainFallback2Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        Validate.check(this);
        return this.client().getVoiceFallback1Service().mpcStartPlayAudio(this.client().getAuthId(), this.id, this.secondaryId, this);
    }

    public String url() {
        return this.url;
    }

    public MultiPartyCallStartPlayAudio url(String url) {
        this.url = url;
        return this;
    }
}

