/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.plivo.api.models.base.Creator;
import com.plivo.api.models.message.MessageCreateResponse;
import com.plivo.api.models.message.MessageType;
import com.plivo.api.serializers.DelimitedListSerializer;
import com.plivo.api.util.Utils;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import retrofit2.Call;

public class MessageCreator
extends Creator<MessageCreateResponse> {
    @JsonProperty(value="src")
    private String source;
    @JsonSerialize(using=DelimitedListSerializer.class)
    @JsonProperty(value="dst")
    private final List<String> destination;
    private final String text;
    @JsonProperty(value="powerpack_uuid")
    private String powerpackUUID;
    private MessageType type = null;
    private URL url = null;
    private String method = "POST";
    private Boolean log = null;
    private Boolean trackable = null;
    private String[] media_urls = null;
    private String[] media_ids = null;
    private Long message_expiry;

    MessageCreator(String source, String destination, String text) {
        if (!Utils.allNotNull(source, destination)) {
            throw new IllegalArgumentException("source, destination must not be null");
        }
        if (destination.equals(source)) {
            throw new IllegalArgumentException("destination cannot include source");
        }
        if (source.length() <= 14) {
            this.source = source;
            this.destination = Collections.singletonList(destination);
            this.text = text;
        } else {
            this.powerpackUUID = source;
            this.destination = Collections.singletonList(destination);
            this.text = text;
        }
    }

    MessageCreator(String source, List<String> destination, String text) {
        if (!Utils.allNotNull(source, destination)) {
            throw new IllegalArgumentException("source, destination must not be null");
        }
        if (destination.contains(source)) {
            throw new IllegalArgumentException("destination cannot include source");
        }
        this.source = source;
        this.destination = destination;
        this.text = text;
    }

    MessageCreator(List<String> destination, String text, String powerpackUUID) {
        if (!Utils.allNotNull(powerpackUUID, destination)) {
            throw new IllegalArgumentException("powerpack uuid, destination and text must not be null");
        }
        this.destination = destination;
        this.text = text;
        this.powerpackUUID = powerpackUUID;
    }

    public String source() {
        return this.source;
    }

    public List<String> destination() {
        return this.destination;
    }

    public String text() {
        return this.text;
    }

    public MessageType type() {
        return this.type;
    }

    public URL url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Boolean log() {
        return this.log;
    }

    public String[] media_urls() {
        return this.media_urls;
    }

    public String[] media_ids() {
        return this.media_ids;
    }

    public Long message_expiry() {
        return this.message_expiry;
    }

    public MessageCreator type(MessageType type) {
        this.type = type;
        return this;
    }

    public MessageCreator url(URL url) {
        this.url = url;
        return this;
    }

    public MessageCreator method(String method) {
        this.method = method;
        return this;
    }

    public MessageCreator log(Boolean log) {
        this.log = log;
        return this;
    }

    public MessageCreator trackable(Boolean trackable) {
        this.trackable = trackable;
        return this;
    }

    public MessageCreator media_urls(String[] media_urls) {
        this.media_urls = media_urls;
        return this;
    }

    public MessageCreator media_ids(String[] media_ids) {
        this.media_ids = media_ids;
        return this;
    }

    public MessageCreator message_expiry(Long message_expiry) {
        this.message_expiry = message_expiry;
        return this;
    }

    @Override
    protected Call<MessageCreateResponse> obtainCall() {
        return this.client().getApiService().messageSend(this.client().getAuthId(), this);
    }
}

