/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.common.spring;

import com.playtika.testcontainer.common.properties.TestcontainersProperties;
import com.playtika.testcontainer.common.spring.AllContainers;
import com.playtika.testcontainer.common.spring.DockerPresenceMarker;
import com.playtika.testcontainer.common.spring.NoDockerPresenceMarkerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@AutoConfigureOrder(value=0x7FFFFFFF)
@ConditionalOnProperty(prefix="embedded.containers", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TestcontainersProperties.class})
public class EmbeddedContainersShutdownAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedContainersShutdownAutoConfiguration.class);
    public static final String ALL_CONTAINERS = "allContainers";

    @Bean(name={"allContainers"})
    public AllContainers allContainers(@Autowired(required=false) DockerPresenceMarker dockerAvailable, @Autowired(required=false) GenericContainer[] allContainers, TestcontainersProperties testcontainersProperties) {
        if (dockerAvailable == null) {
            throw new NoDockerPresenceMarkerException("No docker presence marker available. Did you add spring cloud starter into classpath?");
        }
        List<GenericContainer> containers = allContainers != null ? Arrays.asList(allContainers) : Collections.emptyList();
        return new AllContainers(containers, testcontainersProperties);
    }
}

