/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.common.checks;

import com.playtika.testcontainer.common.checks.AbstractRetryingWaitStrategy;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerState;

public abstract class AbstractCommandWaitStrategy
extends AbstractRetryingWaitStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandWaitStrategy.class);

    public abstract String[] getCheckCommand();

    @Override
    protected boolean isReady() {
        String commandName = this.getContainerType();
        String containerId = this.waitStrategyTarget.getContainerId();
        Object[] checkCommand = this.getCheckCommand();
        log.debug("{} execution of command {} for container id: {} ", new Object[]{commandName, Arrays.toString(checkCommand), containerId});
        Container.ExecResult healthCheckCmdResult = ContainerUtils.executeInContainer((ContainerState)this.waitStrategyTarget, (String[])checkCommand);
        log.debug("{} executed with result: {}", (Object)commandName, (Object)healthCheckCmdResult);
        if (healthCheckCmdResult.getExitCode() != 0) {
            log.debug("{} executed with exitCode !=0, considering status as unknown", (Object)commandName);
            return false;
        }
        log.debug("{} command executed, considering container {} successfully started", (Object)commandName, (Object)containerId);
        return true;
    }
}

