/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.rabbitmq;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.rabbitmq.RabbitMQProperties;
import com.playtika.testcontainer.toxiproxy.ToxiproxyClientProxy;
import com.playtika.testcontainer.toxiproxy.ToxiproxyHelper;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.rabbitmq.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RabbitMQProperties.class})
public class EmbeddedRabbitMQBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRabbitMQBootstrapConfiguration.class);
    private static final String RABBITMQ_NETWORK_ALIAS = "rabbitmq.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="rabbitmq")
    ToxiproxyClientProxy rabbitmqContainerProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedRabbitMq") RabbitMQContainer rabbitmq, ConfigurableEnvironment environment, RabbitMQProperties properties) {
        ToxiproxyClientProxy proxy = ToxiproxyHelper.createProxy((ToxiproxyClient)toxiproxyClient, (ToxiproxyContainer)toxiproxyContainer, (GenericContainer)rabbitmq, (int)properties.getPort(), (String)"rabbitmq");
        ToxiproxyHelper.registerProxyEnvironment((ToxiproxyClientProxy)proxy, (String)"embedded.rabbitmq", (String)"embeddedRabbitmqToxiproxyInfo", (ConfigurableEnvironment)environment);
        return proxy;
    }

    @Bean(name={"embeddedRabbitMq"}, destroyMethod="stop")
    public RabbitMQContainer rabbitmq(ConfigurableEnvironment environment, RabbitMQProperties properties, Optional<Network> network) {
        Integer[] exposedPorts = (Integer[])Stream.concat(properties.getAdditionalPorts().stream(), Stream.of(properties.getPort(), properties.getHttpPort())).distinct().toArray(Integer[]::new);
        RabbitMQContainer rabbitMQ = (RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withAdminPassword(properties.getPassword()).withEnv("RABBITMQ_DEFAULT_VHOST", properties.getVhost())).withExposedPorts(exposedPorts)).withNetworkAliases(new String[]{RABBITMQ_NETWORK_ALIAS});
        if (properties.getEnabledPlugins() != null && properties.getEnabledPlugins().size() != 0) {
            rabbitMQ = rabbitMQ.withPluginsEnabled(properties.getEnabledPlugins().toArray(new String[0]));
        }
        network.ifPresent(arg_0 -> ((RabbitMQContainer)rabbitMQ).withNetwork(arg_0));
        rabbitMQ = (RabbitMQContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)rabbitMQ, (CommonContainerProperties)properties, (Logger)log);
        this.registerRabbitMQEnvironment(rabbitMQ, environment, properties);
        return rabbitMQ;
    }

    private void registerRabbitMQEnvironment(RabbitMQContainer rabbitMQ, ConfigurableEnvironment environment, RabbitMQProperties properties) {
        Integer mappedPort = rabbitMQ.getMappedPort(properties.getPort());
        Integer mappedHttpPort = rabbitMQ.getMappedPort(properties.getHttpPort());
        LinkedHashMap<Integer, Integer> additionalPorts = new LinkedHashMap<Integer, Integer>();
        for (Integer port : properties.getAdditionalPorts()) {
            additionalPorts.put(port, rabbitMQ.getMappedPort(port.intValue()));
        }
        String host = rabbitMQ.getHost();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("embedded.rabbitmq.port", mappedPort);
        map.put("embedded.rabbitmq.host", host);
        map.put("embedded.rabbitmq.vhost", properties.getVhost());
        map.put("embedded.rabbitmq.user", rabbitMQ.getAdminUsername());
        map.put("embedded.rabbitmq.password", rabbitMQ.getAdminPassword());
        map.put("embedded.rabbitmq.httpPort", mappedHttpPort);
        map.put("embedded.rabbitmq.networkAlias", RABBITMQ_NETWORK_ALIAS);
        map.put("embedded.rabbitmq.internalPort", properties.getPort());
        map.put("embedded.rabbitmq.internalHttpPort", properties.getHttpPort());
        for (Integer port : additionalPorts.keySet()) {
            map.put("embedded.rabbitmq.additionalPorts." + port, additionalPorts.get(port));
        }
        log.info("Started RabbitMQ server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedRabbitMqInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

