/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keycloak;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.keycloak.KeycloakContainer;
import com.playtika.testcontainer.keycloak.KeycloakProperties;
import com.playtika.testcontainer.toxiproxy.ToxiproxyClientProxy;
import com.playtika.testcontainer.toxiproxy.ToxiproxyHelper;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.DynamicPropertyRegistrar;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerJwtConfiguration"})
@EnableConfigurationProperties(value={KeycloakProperties.class})
@ConditionalOnProperty(name={"embedded.keycloak.enabled"}, matchIfMissing=true)
public class EmbeddedKeycloakBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakBootstrapConfiguration.class);
    private static final String KEYCLOAK_NETWORK_ALIAS = "keycloak.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="keycloak")
    ToxiproxyClientProxy keycloakContainerProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedKeycloak") KeycloakContainer keycloakContainer) {
        return ToxiproxyHelper.createProxy((ToxiproxyClient)toxiproxyClient, (ToxiproxyContainer)toxiproxyContainer, (GenericContainer)keycloakContainer, (int)keycloakContainer.getHttpPort(), (String)"keycloak");
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="keycloak")
    public DynamicPropertyRegistrar keycloakToxiProxyDynamicPropertyRegistrar(@Qualifier(value="keycloakContainerProxy") ToxiproxyClientProxy proxy) {
        return ToxiproxyHelper.createToxiProxyDynamicPropertyRegistrar((ToxiproxyClientProxy)proxy, (String)"embedded.keycloak");
    }

    @Bean(name={"embeddedKeycloak"}, destroyMethod="stop")
    public KeycloakContainer keycloak(KeycloakProperties properties, ResourceLoader resourceLoader, Optional<Network> network) {
        KeycloakContainer keycloak = (KeycloakContainer)new KeycloakContainer(properties, resourceLoader).withNetworkAliases(new String[]{KEYCLOAK_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((KeycloakContainer)keycloak).withNetwork(arg_0));
        return (KeycloakContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)keycloak, (CommonContainerProperties)properties, (Logger)log);
    }

    @Bean
    public DynamicPropertyRegistrar keycloakDynamicPropertyRegistrar(@Qualifier(value="embeddedKeycloak") KeycloakContainer keycloak, KeycloakProperties properties) {
        return registry -> {
            registry.add("embedded.keycloak.host", () -> ((KeycloakContainer)keycloak).getHost());
            registry.add("embedded.keycloak.http-port", keycloak::getHttpPort);
            registry.add("embedded.keycloak.auth-server-url", keycloak::getAuthServerUrl);
            registry.add("embedded.keycloak.port", () -> keycloak.getMappedPort(8080));
            registry.add("embedded.keycloak.networkAlias", () -> KEYCLOAK_NETWORK_ALIAS);
            registry.add("embedded.keycloak.internalPort", () -> 8080);
        };
    }
}

