/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keycloak;

import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.keycloak.KeycloakContainer;
import com.playtika.testcontainer.keycloak.KeycloakContainerFactory;
import com.playtika.testcontainer.keycloak.KeycloakProperties;
import com.playtika.testcontainer.toxiproxy.ToxiproxyClientProxy;
import com.playtika.testcontainer.toxiproxy.ToxiproxyHelper;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@EnableConfigurationProperties(value={KeycloakProperties.class})
@ConditionalOnProperty(name={"embedded.keycloak.enabled"}, matchIfMissing=true)
public class EmbeddedKeycloakBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakBootstrapConfiguration.class);

    @Bean
    @ConditionalOnToxiProxyEnabled(module="keycloak")
    ToxiproxyClientProxy keycloakContainerProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedKeycloak") KeycloakContainer keycloakContainer, KeycloakProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyClientProxy proxy = ToxiproxyHelper.createProxy((ToxiproxyClient)toxiproxyClient, (ToxiproxyContainer)toxiproxyContainer, (GenericContainer)keycloakContainer, (int)keycloakContainer.getHttpPort(), (String)"keycloak");
        ToxiproxyHelper.registerProxyEnvironment((ToxiproxyClientProxy)proxy, (String)"embedded.keycloak", (String)"embeddedKeycloakToxiproxyInfo", (ConfigurableEnvironment)environment);
        return proxy;
    }

    @Bean
    public KeycloakContainerFactory keycloakContainerFactory(ConfigurableEnvironment environment, KeycloakProperties properties, ResourceLoader resourceLoader, Optional<Network> network) {
        return new KeycloakContainerFactory(environment, properties, resourceLoader, network);
    }

    @Bean(name={"embeddedKeycloak"}, destroyMethod="stop")
    public KeycloakContainer keycloakContainer(KeycloakContainerFactory factory) {
        return Objects.requireNonNull(factory).newKeycloakContainer();
    }
}

