/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keycloak;

import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.keycloak.KeycloakContainer;
import com.playtika.testcontainer.keycloak.KeycloakContainerFactory;
import com.playtika.testcontainer.keycloak.KeycloakProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@EnableConfigurationProperties(value={KeycloakProperties.class})
@ConditionalOnProperty(name={"embedded.keycloak.enabled"}, matchIfMissing=true)
public class EmbeddedKeycloakBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakBootstrapConfiguration.class);

    @Bean
    @ConditionalOnToxiProxyEnabled(module="keycloak")
    ToxiproxyContainer.ContainerProxy keycloakContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedKeycloak") KeycloakContainer keycloakContainer, KeycloakProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)keycloakContainer, keycloakContainer.getHttpPort().intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.keycloak.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.keycloak.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.keycloak.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedKeycloakToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Keycloak ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean
    public KeycloakContainerFactory keycloakContainerFactory(ConfigurableEnvironment environment, KeycloakProperties properties, ResourceLoader resourceLoader, Optional<Network> network) {
        return new KeycloakContainerFactory(environment, properties, resourceLoader, network);
    }

    @Bean(name={"embeddedKeycloak"}, destroyMethod="stop")
    public KeycloakContainer keycloakContainer(KeycloakContainerFactory factory) {
        return Objects.requireNonNull(factory).newKeycloakContainer();
    }
}

