/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.sleuth.camel;

import brave.Span;
import brave.Tags;
import brave.Tracer;
import brave.propagation.ThreadLocalSpan;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.impl.event.AbstractExchangeEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentEventNotifier
extends EventNotifierSupport {
    private static final Logger log = LoggerFactory.getLogger(SentEventNotifier.class);
    public static final String EXCHANGE_EVENT_SENT_ANNOTATION = "camel-exchange-event-sent";
    private final Tracer tracer;
    private final ThreadLocalSpan threadLocalSpan;

    public void notify(CamelEvent event) {
        if (!(event instanceof CamelEvent.ExchangeFailedEvent || event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeSentEvent)) {
            return;
        }
        log.trace("Caught an event [{} - {}] - processing...", (Object)event.getClass().getSimpleName(), (Object)event);
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan == null) {
            log.debug("Skipping event [{}] since it's not tracing...", (Object)event);
            return;
        }
        Exchange exchange = ((AbstractExchangeEvent)event).getExchange();
        if (!this.isCamelSpan(exchange)) {
            log.debug("Skipping span {}, since it's not camel one.", (Object)currentSpan);
            return;
        }
        if (!this.isFromSourceEndpoint(event)) {
            log.debug("Skipping span {}, since exchange came not from its source route. Event - [{}].", (Object)currentSpan, (Object)event);
            return;
        }
        exchange.removeProperty("ExchangeIsInTracingContext");
        Span spanToFinish = this.threadLocalSpan.remove();
        this.logExceptionIfExists(event, spanToFinish);
        spanToFinish.annotate(EXCHANGE_EVENT_SENT_ANNOTATION);
        spanToFinish.finish();
        log.debug("Span {} successfully closed.", (Object)spanToFinish);
    }

    private boolean isCamelSpan(Exchange exchange) {
        Boolean isTracing = (Boolean)exchange.getProperty("ExchangeIsInTracingContext", Boolean.class);
        return isTracing != null && isTracing != false;
    }

    private boolean isFromSourceEndpoint(CamelEvent event) {
        if (!(event instanceof ExchangeSentEvent)) {
            return true;
        }
        ExchangeSentEvent exchangeSentEvent = (ExchangeSentEvent)event;
        Exchange exchange = exchangeSentEvent.getExchange();
        String exchangeEndpointKey = exchange.getFromEndpoint().getEndpointKey();
        String eventEndpointKey = exchangeSentEvent.getEndpoint().getEndpointKey();
        return Objects.equals(exchangeEndpointKey, eventEndpointKey);
    }

    private void logExceptionIfExists(CamelEvent event, Span span) {
        AbstractExchangeEvent abstractExchangeEvent = (AbstractExchangeEvent)event;
        Exception exception = abstractExchangeEvent.getExchange().getException();
        if (exception != null) {
            Tags.ERROR.tag((Object)exception, span);
        }
    }

    public SentEventNotifier(Tracer tracer, ThreadLocalSpan threadLocalSpan) {
        this.tracer = tracer;
        this.threadLocalSpan = threadLocalSpan;
    }
}

