/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.sleuth.camel;

import brave.ErrorParser;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.ThreadLocalSpan;
import com.playtika.sleuth.camel.CreatedEventNotifier;
import com.playtika.sleuth.camel.SentEventNotifier;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.EventNotifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={CamelContext.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.camel.enabled"}, matchIfMissing=true)
public class SleuthCamelAutoConfiguration {
    private final CamelContext camelContext;
    private final Tracer tracer;

    @Bean
    @ConditionalOnMissingBean
    public CreatedEventNotifier createdEventNotifier(Tracing tracing, ThreadLocalSpan threadLocalSpan) {
        CreatedEventNotifier createdEventNotifier = new CreatedEventNotifier(tracing, threadLocalSpan, this.tracer);
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)createdEventNotifier);
        return createdEventNotifier;
    }

    @Bean
    @ConditionalOnMissingBean
    public SentEventNotifier sentEventNotifier(ErrorParser errorParser, ThreadLocalSpan threadLocalSpan) {
        SentEventNotifier sentEventNotifier = new SentEventNotifier(this.tracer, threadLocalSpan, errorParser);
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)sentEventNotifier);
        return sentEventNotifier;
    }

    @Bean
    public ThreadLocalSpan threadLocalSpan() {
        return ThreadLocalSpan.create((Tracer)this.tracer);
    }

    public SleuthCamelAutoConfiguration(CamelContext camelContext, Tracer tracer) {
        this.camelContext = camelContext;
        this.tracer = tracer;
    }
}

