/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.sleuth.camel;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.ThreadLocalSpan;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

public class CreatedEventNotifier
extends EventNotifierSupport {
    private static final Logger log = LoggerFactory.getLogger(CreatedEventNotifier.class);
    static final String EXCHANGE_EVENT_CREATED_ANNOTATION = "camel-exchange-event-created";
    static final String EXCHANGE_ID_TAG_ANNOTATION = "camel-exchange-id";
    private static final String MESSAGE_COMPONENT = "camel";
    private final ThreadLocalSpan threadLocalSpan;
    private final TraceContext.Injector<Message> injector;
    private final TraceContext.Extractor<Message> extractor;
    private final Tracer tracer;

    public CreatedEventNotifier(Tracing tracing, ThreadLocalSpan threadLocalSpan, Tracer tracer) {
        this.threadLocalSpan = threadLocalSpan;
        this.tracer = tracer;
        this.injector = tracing.propagation().injector(Message::setHeader);
        this.extractor = tracing.propagation().extractor((carrier, key) -> (String)carrier.getHeader(key, String.class));
    }

    public void notify(CamelEvent event) {
        log.trace("Caught an event [{} - {}] - processing...", (Object)event.getClass().getSimpleName(), (Object)event);
        CamelEvent.ExchangeCreatedEvent exchangeCreatedEvent = (CamelEvent.ExchangeCreatedEvent)event;
        Exchange exchange = exchangeCreatedEvent.getExchange();
        Endpoint endpoint = exchange.getFromEndpoint();
        Message message = exchange.getIn();
        TraceContextOrSamplingFlags extractedContext = this.extractor.extract((Object)message);
        boolean isExternalContext = TraceContextOrSamplingFlags.EMPTY != extractedContext;
        Span possiblyExistingSpan = this.tracer.currentSpan();
        Span span = this.threadLocalSpan.next(extractedContext);
        String spanName = this.getSpanName(endpoint);
        span.name(spanName);
        span.start();
        span.annotate(EXCHANGE_EVENT_CREATED_ANNOTATION);
        span.tag(EXCHANGE_ID_TAG_ANNOTATION, exchange.getExchangeId());
        exchange.setProperty("ExchangeIsInTracingContext", (Object)Boolean.TRUE);
        if (!isExternalContext) {
            if (null != possiblyExistingSpan) {
                this.injector.inject(possiblyExistingSpan.context(), (Object)message);
            } else {
                this.injector.inject(span.context(), (Object)message);
            }
        }
        log.debug("Created/continued span [{}]", (Object)span);
    }

    private String getSpanName(Endpoint endpoint) {
        return SpanNameUtil.shorten((String)("camel::" + endpoint.getEndpointKey()));
    }

    public boolean isEnabled(CamelEvent event) {
        return event instanceof CamelEvent.ExchangeCreatedEvent;
    }
}

