/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import reactivefeign.webclient.WebReactiveOptions;
import reactor.netty.http.HttpResources;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;
import reactor.netty.transport.ProxyProvider;

class NettyClientHttpConnectorBuilder {
    private static final Log LOG = LogFactory.getLog(NettyClientHttpConnectorBuilder.class);

    private NettyClientHttpConnectorBuilder() {
    }

    public static ClientHttpConnector buildNettyClientHttpConnector(HttpClient httpClient, WebReactiveOptions webOptions) {
        if (httpClient == null) {
            ConnectionProvider connectionProvider = webOptions.getConnectionProvider();
            if (connectionProvider == null) {
                connectionProvider = TcpResources.get();
            }
            ConnectionProvider.Builder connectionProviderBuilder = connectionProvider.mutate();
            if (webOptions.getConnectionMetricsEnabled() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.metrics(webOptions.getConnectionMetricsEnabled().booleanValue());
            }
            if (webOptions.getMaxConnections() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.maxConnections(webOptions.getMaxConnections().intValue());
            }
            if (webOptions.getConnectionMaxIdleTimeMillis() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.maxIdleTime(Duration.ofMillis(webOptions.getConnectionMaxIdleTimeMillis()));
            }
            if (webOptions.getConnectionMaxLifeTimeMillis() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.maxLifeTime(Duration.ofMillis(webOptions.getConnectionMaxLifeTimeMillis()));
            }
            if (webOptions.getPendingAcquireMaxCount() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.pendingAcquireMaxCount(webOptions.getPendingAcquireMaxCount().intValue());
            }
            if (webOptions.getPendingAcquireTimeoutMillis() != null) {
                connectionProviderBuilder = (ConnectionProvider.Builder)connectionProviderBuilder.pendingAcquireTimeout(Duration.ofMillis(webOptions.getPendingAcquireTimeoutMillis()));
            }
            connectionProvider = connectionProviderBuilder.build();
            httpClient = (HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).runOn((LoopResources)HttpResources.get(), LoopResources.DEFAULT_NATIVE);
        }
        if (webOptions.getMetricsEnabled() != null) {
            httpClient = httpClient.metrics(webOptions.getMetricsEnabled().booleanValue(), Function.identity());
        }
        if (webOptions.getConnectTimeoutMillis() != null) {
            httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)webOptions.getConnectTimeoutMillis().intValue());
        }
        httpClient = (HttpClient)httpClient.doOnConnected(connection -> {
            if (webOptions.getReadTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(webOptions.getReadTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
            if (webOptions.getWriteTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler(webOptions.getWriteTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
        });
        WebReactiveOptions.WebProxySettings proxySettings = (WebReactiveOptions.WebProxySettings)webOptions.getProxySettings();
        if (proxySettings != null) {
            httpClient = (HttpClient)httpClient.proxy(typeSpec -> {
                ProxyProvider.Builder proxyBuilder = typeSpec.type(ProxyProvider.Proxy.HTTP).host(proxySettings.getHost()).port(proxySettings.getPort()).username(proxySettings.getUsername()).password(password -> proxySettings.getPassword());
                if (proxySettings.getTimeout() != null) {
                    proxyBuilder.connectTimeoutMillis(proxySettings.getTimeout().longValue());
                }
            });
        }
        if (webOptions.getResponseTimeoutMillis() != null) {
            httpClient = httpClient.responseTimeout(Duration.ofMillis(webOptions.getResponseTimeoutMillis()));
        }
        if (webOptions.isTryUseCompression() != null) {
            httpClient = httpClient.compress(true);
        }
        if (webOptions.isFollowRedirects() != null) {
            httpClient = httpClient.followRedirect(webOptions.isFollowRedirects().booleanValue());
        }
        if (webOptions.getSslContext() != null) {
            httpClient = httpClient.secure(sslProviderBuilder -> sslProviderBuilder.sslContext(webOptions.getSslContext()));
        } else if (Objects.equals(Boolean.TRUE, webOptions.isDisableSslValidation())) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                httpClient = httpClient.secure(sslProviderBuilder -> sslProviderBuilder.sslContext(sslContext));
            }
            catch (SSLException e) {
                LOG.warn((Object)"Error creating SSLContext. The WebClient will verify all new HTTPS calls", (Throwable)e);
            }
        }
        return new ReactorClientHttpConnector(httpClient);
    }
}

