/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import reactivefeign.ReactiveOptions;

public class WebReactiveOptions
extends ReactiveOptions {
    public static final WebReactiveOptions DEFAULT_OPTIONS = (WebReactiveOptions)new Builder().setReadTimeoutMillis(10000L).setWriteTimeoutMillis(10000L).setConnectTimeoutMillis(5000L).build();
    private final Long readTimeoutMillis;
    private final Long writeTimeoutMillis;
    private final Long responseTimeoutMillis;
    private final Boolean disableSslValidation;
    private final Integer maxConnections;
    private final Integer pendingAcquireMaxCount;

    private WebReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Long readTimeoutMillis, Long writeTimeoutMillis, Long responseTimeoutMillis, Boolean tryUseCompression, Boolean followRedirects, ReactiveOptions.ProxySettings proxySettings, Boolean disableSslValidation, Integer maxConnections, Integer pendingAcquireMaxCount) {
        super(useHttp2, connectTimeoutMillis, tryUseCompression, followRedirects, proxySettings);
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.disableSslValidation = disableSslValidation;
        this.maxConnections = maxConnections;
        this.pendingAcquireMaxCount = pendingAcquireMaxCount;
    }

    public Long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public Long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.readTimeoutMillis == null && this.writeTimeoutMillis == null;
    }

    public Boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getPendingAcquireMaxCount() {
        return this.pendingAcquireMaxCount;
    }

    public static class WebProxySettingsBuilder
    extends ReactiveOptions.ProxySettingsBuilder {
        private String username;
        private String password;
        private Long timeout;

        public ReactiveOptions.ProxySettingsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ReactiveOptions.ProxySettingsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ReactiveOptions.ProxySettingsBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public WebProxySettings build() {
            return new WebProxySettings(this.host, this.port, this.username, this.password, this.timeout);
        }
    }

    public static class WebProxySettings
    extends ReactiveOptions.ProxySettings {
        private final String username;
        private final String password;
        private final Long timeout;

        protected WebProxySettings(String host, int port, String username, String password, Long timeout) {
            super(host, port);
            this.username = username;
            this.password = password;
            this.timeout = timeout;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public Long getTimeout() {
            return this.timeout;
        }
    }

    public static class Builder
    extends ReactiveOptions.Builder {
        private Long readTimeoutMillis;
        private Long writeTimeoutMillis;
        private Long responseTimeoutMillis;
        private Boolean disableSslValidation;
        private Integer maxConnections;
        private Integer pendingAcquireMaxCount;

        public Builder setReadTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setWriteTimeoutMillis(long writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder setResponseTimeoutMillis(long responseTimeoutMillis) {
            this.responseTimeoutMillis = responseTimeoutMillis;
            return this;
        }

        public Builder setDisableSslValidation(boolean disableSslValidation) {
            this.disableSslValidation = disableSslValidation;
            return this;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setPendingAcquireMaxCount(Integer pendingAcquireMaxCount) {
            this.pendingAcquireMaxCount = pendingAcquireMaxCount;
            return this;
        }

        public WebReactiveOptions build() {
            return new WebReactiveOptions(this.useHttp2, this.connectTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.responseTimeoutMillis, this.acceptCompressed, this.followRedirects, this.proxySettings, this.disableSslValidation, this.maxConnections, this.pendingAcquireMaxCount);
        }
    }
}

