/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.handler.ssl.SslContext;
import reactivefeign.ReactiveOptions;
import reactor.netty.resources.ConnectionProvider;

public class WebReactiveOptions
extends ReactiveOptions {
    public static final WebReactiveOptions DEFAULT_OPTIONS = (WebReactiveOptions)new Builder().setReadTimeoutMillis(10000L).setWriteTimeoutMillis(10000L).setConnectTimeoutMillis(5000L).build();
    private final Long readTimeoutMillis;
    private final Long writeTimeoutMillis;
    private final Long responseTimeoutMillis;
    private final SslContext sslContext;
    private final Boolean disableSslValidation;
    private final Boolean metricsEnabled;
    private final ConnectionProvider connectionProvider;
    private final Integer maxConnections;
    private final Boolean connectionMetricsEnabled;
    private final Long connectionMaxIdleTimeMillis;
    private final Long connectionMaxLifeTimeMillis;
    private final Integer pendingAcquireMaxCount;
    private final Long pendingAcquireTimeoutMillis;

    private WebReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Long readTimeoutMillis, Long writeTimeoutMillis, Long responseTimeoutMillis, Boolean tryUseCompression, Boolean followRedirects, ReactiveOptions.ProxySettings proxySettings, SslContext sslContext, Boolean disableSslValidation, Boolean metricsEnabled, ConnectionProvider connectionProvider, Integer maxConnections, Boolean connectionMetricsEnabled, Long connectionMaxIdleTimeMillis, Long connectionMaxLifeTimeMillis, Integer pendingAcquireMaxCount, Long pendingAcquireTimeoutMillis) {
        super(useHttp2, connectTimeoutMillis, tryUseCompression, followRedirects, proxySettings);
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.sslContext = sslContext;
        this.disableSslValidation = disableSslValidation;
        this.metricsEnabled = metricsEnabled;
        this.connectionProvider = connectionProvider;
        this.maxConnections = maxConnections;
        this.connectionMetricsEnabled = connectionMetricsEnabled;
        this.connectionMaxIdleTimeMillis = connectionMaxIdleTimeMillis;
        this.connectionMaxLifeTimeMillis = connectionMaxLifeTimeMillis;
        this.pendingAcquireMaxCount = pendingAcquireMaxCount;
        this.pendingAcquireTimeoutMillis = pendingAcquireTimeoutMillis;
    }

    public Long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public Long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.readTimeoutMillis == null && this.writeTimeoutMillis == null;
    }

    public Boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public Boolean getMetricsEnabled() {
        return this.metricsEnabled;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Boolean getConnectionMetricsEnabled() {
        return this.connectionMetricsEnabled;
    }

    public Long getConnectionMaxIdleTimeMillis() {
        return this.connectionMaxIdleTimeMillis;
    }

    public Long getConnectionMaxLifeTimeMillis() {
        return this.connectionMaxLifeTimeMillis;
    }

    public Integer getPendingAcquireMaxCount() {
        return this.pendingAcquireMaxCount;
    }

    public Long getPendingAcquireTimeoutMillis() {
        return this.pendingAcquireTimeoutMillis;
    }

    public static class WebProxySettingsBuilder
    extends ReactiveOptions.ProxySettingsBuilder {
        private String username;
        private String password;
        private Long timeout;

        public WebProxySettingsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public WebProxySettingsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public WebProxySettingsBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public WebProxySettings build() {
            return new WebProxySettings(this.host, this.port, this.username, this.password, this.timeout);
        }
    }

    public static class WebProxySettings
    extends ReactiveOptions.ProxySettings {
        private final String username;
        private final String password;
        private final Long timeout;

        protected WebProxySettings(String host, int port, String username, String password, Long timeout) {
            super(host, port);
            this.username = username;
            this.password = password;
            this.timeout = timeout;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public Long getTimeout() {
            return this.timeout;
        }
    }

    public static class Builder
    extends ReactiveOptions.Builder {
        private Long readTimeoutMillis;
        private Long writeTimeoutMillis;
        private Long responseTimeoutMillis;
        private Boolean disableSslValidation;
        private SslContext sslContext;
        private Boolean metricsEnabled;
        private ConnectionProvider connectionProvider;
        private Integer maxConnections;
        private Boolean connectionMetricsEnabled;
        private Long connectionMaxIdleTimeMillis;
        private Long connectionMaxLifeTimeMillis;
        private Integer pendingAcquireMaxCount;
        private Long pendingAcquireTimeoutMillis;

        public Builder setReadTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setWriteTimeoutMillis(long writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder setResponseTimeoutMillis(long responseTimeoutMillis) {
            this.responseTimeoutMillis = responseTimeoutMillis;
            return this;
        }

        public Builder setDisableSslValidation(boolean disableSslValidation) {
            this.disableSslValidation = disableSslValidation;
            return this;
        }

        public Builder setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setMetricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public Builder setConnectionProvider(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder setConnectionMetricsEnabled(Boolean connectionMetricsEnabled) {
            this.connectionMetricsEnabled = connectionMetricsEnabled;
            return this;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setConnectionMaxIdleTimeMillis(Long connectionMaxIdleTimeMillis) {
            this.connectionMaxIdleTimeMillis = connectionMaxIdleTimeMillis;
            return this;
        }

        public Builder setConnectionMaxLifeTimeMillis(Long connectionMaxLifeTimeMillis) {
            this.connectionMaxLifeTimeMillis = connectionMaxLifeTimeMillis;
            return this;
        }

        public Builder setPendingAcquireMaxCount(Integer pendingAcquireMaxCount) {
            this.pendingAcquireMaxCount = pendingAcquireMaxCount;
            return this;
        }

        public Builder setPendingAcquireTimeoutMillis(Long pendingAcquireTimeoutMillis) {
            this.pendingAcquireTimeoutMillis = pendingAcquireTimeoutMillis;
            return this;
        }

        public WebReactiveOptions build() {
            return new WebReactiveOptions(this.useHttp2, this.connectTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.responseTimeoutMillis, this.acceptCompressed, this.followRedirects, this.proxySettings, this.sslContext, this.disableSslValidation, this.metricsEnabled, this.connectionProvider, this.maxConnections, this.connectionMetricsEnabled, this.connectionMaxIdleTimeMillis, this.connectionMaxLifeTimeMillis, this.pendingAcquireMaxCount, this.pendingAcquireTimeoutMillis);
        }
    }
}

