/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class WebReactiveHttpResponse
implements ReactiveHttpResponse {
    private final ClientResponse clientResponse;
    private final Type returnPublisherType;
    private final ParameterizedTypeReference<Object> returnActualType;

    WebReactiveHttpResponse(ClientResponse clientResponse, Type returnPublisherType, ParameterizedTypeReference<Object> returnActualType) {
        this.clientResponse = clientResponse;
        this.returnPublisherType = returnPublisherType;
        this.returnActualType = returnActualType;
    }

    public int status() {
        return this.clientResponse.statusCode().value();
    }

    public Map<String, List<String>> headers() {
        return this.clientResponse.headers().asHttpHeaders();
    }

    public Publisher<Object> body() {
        if (this.returnPublisherType == Mono.class) {
            return this.clientResponse.bodyToMono(this.returnActualType);
        }
        if (this.returnPublisherType == Flux.class) {
            return this.clientResponse.bodyToFlux(this.returnActualType);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    public Mono<byte[]> bodyData() {
        return this.clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).defaultIfEmpty((Object)new byte[0]);
    }
}

